/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.predicates.simplification;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentitySet;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QueryPredicateMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.TypedMatcher;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AndOrPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AndPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.OrPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.simplification.QueryPredicateSimplificationRule;
import com.apple.foundationdb.record.query.plan.cascades.predicates.simplification.QueryPredicateSimplificationRuleCall;
import com.apple.foundationdb.record.query.plan.planning.BooleanPredicateNormalizer;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class AbsorptionRule<P extends AndOrPredicate>
extends QueryPredicateSimplificationRule<P> {
    @Nonnull
    private final Class<P> majorClass;
    @Nonnull
    private final BindingMatcher<QueryPredicate> termMatcher;

    public AbsorptionRule(@Nonnull Class<P> majorClass, @Nonnull BindingMatcher<QueryPredicate> termMatcher, @Nonnull BindingMatcher<P> rootMatcher) {
        super(rootMatcher);
        this.majorClass = majorClass;
        this.termMatcher = termMatcher;
    }

    @Override
    @Nonnull
    public Optional<Class<?>> getRootOperator() {
        return Optional.empty();
    }

    @Override
    public void onMatch(@Nonnull QueryPredicateSimplificationRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        List<QueryPredicate> majorTerms = bindings.getAll(this.termMatcher);
        Class<AndOrPredicate> minorClass = AbsorptionRule.minorForMajor(this.majorClass);
        List<Collection<? extends QueryPredicate>> majorOfMinors = majorTerms.stream().map(term -> {
            if (minorClass.isInstance(term)) {
                return Lists.newArrayList(term.getChildren());
            }
            return Lists.newArrayList(term);
        }).collect(Collectors.toList());
        List<Collection<? extends QueryPredicate>> absorbed = BooleanPredicateNormalizer.applyAbsorptionLaw(majorOfMinors);
        if (absorbed.size() < majorOfMinors.size()) {
            QueryPredicate simplifiedPredicate = this.with(this.majorClass, absorbed.stream().map(minor -> this.with((Class<? extends AndOrPredicate>)minorClass, (Collection<? extends QueryPredicate>)minor)).collect(Collectors.toList()));
            Set allMajorOfMinors = majorOfMinors.stream().flatMap(Collection::stream).collect(LinkedIdentitySet.toLinkedIdentitySet());
            Set retainedMajorOfMinors = absorbed.stream().flatMap(Collection::stream).collect(LinkedIdentitySet.toLinkedIdentitySet());
            call.yieldResultBuilder().addConstraintsFrom((QueryPredicate)bindings.get(this.getMatcher())).addConstraintsFrom(Sets.difference(allMajorOfMinors, retainedMajorOfMinors)).yieldResult(simplifiedPredicate);
        }
    }

    @Nonnull
    private QueryPredicate with(@Nonnull Class<? extends AndOrPredicate> majorOrMinorClass, @Nonnull Collection<? extends QueryPredicate> terms) {
        if (majorOrMinorClass == OrPredicate.class) {
            return OrPredicate.or(terms);
        }
        if (majorOrMinorClass == AndPredicate.class) {
            return AndPredicate.and(terms);
        }
        throw new RecordCoreException("unsupported major or minor", new Object[0]);
    }

    @Nonnull
    private static Class<? extends AndOrPredicate> minorForMajor(@Nonnull Class<? extends AndOrPredicate> majorClass) {
        if (majorClass == AndPredicate.class) {
            return OrPredicate.class;
        }
        if (majorClass == OrPredicate.class) {
            return AndPredicate.class;
        }
        throw new RecordCoreException("unsupported major", new Object[0]);
    }

    @Nonnull
    public static <P extends AndOrPredicate> AbsorptionRule<P> withMajor(@Nonnull Class<P> majorClass) {
        TypedMatcher<QueryPredicate> termMatcher = QueryPredicateMatchers.anyPredicate();
        return new AbsorptionRule<P>(majorClass, termMatcher, QueryPredicateMatchers.ofTypeWithChildren(majorClass, MultiMatcher.all(termMatcher)));
    }
}

