/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.predicates.simplification;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QueryPredicateMatchers;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ConstantPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.OrPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.simplification.QueryPredicateSimplificationRule;
import com.apple.foundationdb.record.query.plan.cascades.predicates.simplification.QueryPredicateSimplificationRuleCall;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class AnnulmentOrRule
extends QueryPredicateSimplificationRule<OrPredicate> {
    @Nonnull
    private static final BindingMatcher<QueryPredicate> orTermMatcher = QueryPredicateMatchers.anyPredicate();
    @Nonnull
    private static final BindingMatcher<OrPredicate> rootMatcher = QueryPredicateMatchers.orPredicate(MultiMatcher.all(orTermMatcher));

    public AnnulmentOrRule() {
        super(rootMatcher);
    }

    @Override
    @Nonnull
    public Optional<Class<?>> getRootOperator() {
        return Optional.of(OrPredicate.class);
    }

    @Override
    public void onMatch(@Nonnull QueryPredicateSimplificationRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        List<QueryPredicate> orTerms = bindings.getAll(orTermMatcher);
        if (orTerms.stream().anyMatch(QueryPredicate::isTautology)) {
            call.yieldResultBuilder().addConstraintsFrom(bindings.get(rootMatcher)).addConstraintsFrom(orTerms).yieldResult(new ConstantPredicate((Boolean)true));
        }
    }
}

