/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.predicates.simplification;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ListMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QueryPredicateMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ValueMatchers;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ConstantPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithValueAndRanges;
import com.apple.foundationdb.record.query.plan.cascades.predicates.RangeConstraints;
import com.apple.foundationdb.record.query.plan.cascades.predicates.simplification.ConstantPredicateFoldingUtil;
import com.apple.foundationdb.record.query.plan.cascades.predicates.simplification.QueryPredicateSimplificationRule;
import com.apple.foundationdb.record.query.plan.cascades.predicates.simplification.QueryPredicateSimplificationRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Optional;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class ConstantFoldingMultiConstraintPredicateRule
extends QueryPredicateSimplificationRule<PredicateWithValueAndRanges> {
    @Nonnull
    private static final BindingMatcher<RangeConstraints> rangeMatcher = QueryPredicateMatchers.rangeConstraint(MultiMatcher.atLeastTwo(QueryPredicateMatchers.anyComparison()));
    @Nonnull
    private static final BindingMatcher<Value> comparandMatcher = ValueMatchers.anyValue();
    @Nonnull
    private static final BindingMatcher<PredicateWithValueAndRanges> rootMatcher = QueryPredicateMatchers.predicateWithValueAndRanges(comparandMatcher, ListMatcher.exactly(rangeMatcher));

    public ConstantFoldingMultiConstraintPredicateRule() {
        super(rootMatcher);
    }

    @Override
    public void onMatch(@Nonnull QueryPredicateSimplificationRuleCall call) {
        RangeConstraints multiConstraintRange = call.getBindings().get(rangeMatcher);
        Value lhs = call.getBindings().get(comparandMatcher);
        this.foldConjunctionRangesMaybe(lhs, multiConstraintRange).ifPresent(call::yieldResult);
    }

    @Nonnull
    private Optional<ConstantPredicate> foldConjunctionRangesMaybe(Value lhs, @Nonnull RangeConstraints rangeConstraints) {
        if (rangeConstraints.getComparisons().isEmpty()) {
            return Optional.empty();
        }
        ImmutableSet.Builder predicateCategoriesBuilder = ImmutableSet.builder();
        for (Comparisons.Comparison comparison : rangeConstraints.getComparisons()) {
            predicateCategoriesBuilder.add((Object)ConstantPredicateFoldingUtil.foldComparisonMaybe(lhs, comparison));
        }
        ImmutableCollection predicateCategories = predicateCategoriesBuilder.build();
        if (predicateCategories.size() == 1) {
            return ((ConstantPredicateFoldingUtil.PredicateCategory)((Object)Iterables.getOnlyElement(predicateCategories))).getPredicateMaybe();
        }
        if (predicateCategories.contains((Object)ConstantPredicateFoldingUtil.PredicateCategory.SINGLETON_FALSE)) {
            return Optional.of(ConstantPredicate.FALSE);
        }
        if (predicateCategories.contains((Object)ConstantPredicateFoldingUtil.PredicateCategory.UNKNOWN)) {
            return Optional.empty();
        }
        if (predicateCategories.stream().noneMatch(p -> p == ConstantPredicateFoldingUtil.PredicateCategory.SINGLETON_FALSE)) {
            Verify.verify(predicateCategories.contains((Object)ConstantPredicateFoldingUtil.PredicateCategory.SINGLETON_TRUE));
            Verify.verify(predicateCategories.contains((Object)ConstantPredicateFoldingUtil.PredicateCategory.SINGLETON_NULL));
            return Optional.of(ConstantPredicate.NULL);
        }
        return Optional.of(ConstantPredicate.FALSE);
    }
}

