/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.predicates.simplification;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ListMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QueryPredicateMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ValueMatchers;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithValueAndRanges;
import com.apple.foundationdb.record.query.plan.cascades.predicates.RangeConstraints;
import com.apple.foundationdb.record.query.plan.cascades.predicates.simplification.ConstantPredicateFoldingUtil;
import com.apple.foundationdb.record.query.plan.cascades.predicates.simplification.QueryPredicateSimplificationRule;
import com.apple.foundationdb.record.query.plan.cascades.predicates.simplification.QueryPredicateSimplificationRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.google.common.collect.Iterables;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class ConstantFoldingPredicateWithRangesRule
extends QueryPredicateSimplificationRule<PredicateWithValueAndRanges> {
    @Nonnull
    private static final BindingMatcher<RangeConstraints> booleanSingletonRangeMatcher = QueryPredicateMatchers.rangeConstraint(ListMatcher.exactly(QueryPredicateMatchers.anyComparison()));
    @Nonnull
    private static final BindingMatcher<Value> comparandMatcher = ValueMatchers.anyValue();
    @Nonnull
    private static final BindingMatcher<PredicateWithValueAndRanges> rootMatcher = QueryPredicateMatchers.predicateWithValueAndRanges(comparandMatcher, ListMatcher.exactly(booleanSingletonRangeMatcher));

    public ConstantFoldingPredicateWithRangesRule() {
        super(rootMatcher);
    }

    @Override
    public void onMatch(@Nonnull QueryPredicateSimplificationRuleCall call) {
        PredicateWithValueAndRanges root = call.getBindings().get(rootMatcher);
        RangeConstraints booleanSingletonRange = call.getBindings().get(booleanSingletonRangeMatcher);
        Comparisons.Comparison comparison = Iterables.getOnlyElement(booleanSingletonRange.getComparisons());
        Value lhsValue = root.getValue();
        ConstantPredicateFoldingUtil.foldComparisonMaybe(lhsValue, comparison).getPredicateMaybe().ifPresent(call::yieldResult);
    }
}

