/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.predicates.simplification;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QueryPredicateMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ValueMatchers;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ValuePredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.simplification.ConstantPredicateFoldingUtil;
import com.apple.foundationdb.record.query.plan.cascades.predicates.simplification.QueryPredicateSimplificationRule;
import com.apple.foundationdb.record.query.plan.cascades.predicates.simplification.QueryPredicateSimplificationRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class ConstantFoldingValuePredicateRule
extends QueryPredicateSimplificationRule<ValuePredicate> {
    @Nonnull
    private static final BindingMatcher<Comparisons.Comparison> comparisonMatcher = QueryPredicateMatchers.anyComparison();
    @Nonnull
    private static final BindingMatcher<Value> comparandMatcher = ValueMatchers.anyValue();
    @Nonnull
    private static final BindingMatcher<ValuePredicate> rootMatcher = QueryPredicateMatchers.valuePredicate(comparandMatcher, comparisonMatcher);

    public ConstantFoldingValuePredicateRule() {
        super(rootMatcher);
    }

    @Override
    public void onMatch(@Nonnull QueryPredicateSimplificationRuleCall call) {
        ValuePredicate root = call.getBindings().get(rootMatcher);
        Comparisons.Comparison comparison = call.getBindings().get(comparisonMatcher);
        Value lhsValue = root.getValue();
        ConstantPredicateFoldingUtil.foldComparisonMaybe(lhsValue, comparison).getPredicateMaybe().ifPresent(call::yieldResult);
    }
}

