/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.predicates.simplification;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ConstantPredicate;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.LiteralValue;
import com.apple.foundationdb.record.query.plan.cascades.values.NullValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public final class ConstantPredicateFoldingUtil {
    public static PredicateCategory foldComparisonMaybe(@Nonnull Value operand, @Nonnull Comparisons.Comparison comparison) {
        EffectiveConstant rhsOperand;
        Comparisons.Type comparisonType = comparison.getType();
        EffectiveConstant lhsOperand = EffectiveConstant.from(operand);
        if (comparisonType.isUnary()) {
            switch (comparisonType) {
                case IS_NULL: {
                    switch (lhsOperand) {
                        case NULL: {
                            return PredicateCategory.SINGLETON_TRUE;
                        }
                        case TRUE: 
                        case FALSE: 
                        case NOT_NULL: {
                            return PredicateCategory.SINGLETON_FALSE;
                        }
                    }
                    return PredicateCategory.UNKNOWN;
                }
                case NOT_NULL: {
                    switch (lhsOperand) {
                        case NULL: {
                            return PredicateCategory.SINGLETON_FALSE;
                        }
                        case TRUE: 
                        case FALSE: 
                        case NOT_NULL: {
                            return PredicateCategory.SINGLETON_TRUE;
                        }
                    }
                    return PredicateCategory.UNKNOWN;
                }
            }
            return PredicateCategory.UNKNOWN;
        }
        if (comparison instanceof Comparisons.ValueComparison) {
            Comparisons.ValueComparison valueComparison = (Comparisons.ValueComparison)comparison;
            Value rhsValue = valueComparison.getValue();
            rhsOperand = EffectiveConstant.from(rhsValue);
        } else if (comparison instanceof Comparisons.SimpleComparison) {
            Comparisons.SimpleComparison simpleComparison = (Comparisons.SimpleComparison)comparison;
            Object rhsValue = simpleComparison.getComparand();
            rhsOperand = EffectiveConstant.from(rhsValue);
        } else {
            return PredicateCategory.UNKNOWN;
        }
        switch (comparisonType) {
            case EQUALS: 
            case NOT_EQUALS: {
                if (lhsOperand != EffectiveConstant.NULL && rhsOperand != EffectiveConstant.NULL) break;
                return PredicateCategory.SINGLETON_NULL;
            }
            default: {
                return PredicateCategory.UNKNOWN;
            }
        }
        if (rhsOperand.isUnknownLiteral() || lhsOperand.isUnknownLiteral()) {
            return PredicateCategory.UNKNOWN;
        }
        switch (comparisonType) {
            case EQUALS: {
                if (lhsOperand.equals((Object)rhsOperand)) {
                    return PredicateCategory.SINGLETON_TRUE;
                }
                return PredicateCategory.SINGLETON_FALSE;
            }
            case NOT_EQUALS: {
                if (!lhsOperand.equals((Object)rhsOperand)) {
                    return PredicateCategory.SINGLETON_TRUE;
                }
                return PredicateCategory.SINGLETON_FALSE;
            }
        }
        return PredicateCategory.UNKNOWN;
    }

    public static enum EffectiveConstant {
        TRUE(true),
        FALSE(true),
        NULL(true),
        NOT_NULL(false),
        UNKNOWN(false);

        private final boolean isKnownLiteral;

        private EffectiveConstant(boolean isKnownLiteral) {
            this.isKnownLiteral = isKnownLiteral;
        }

        boolean isUnknownLiteral() {
            return !this.isKnownLiteral;
        }

        public static EffectiveConstant from(@Nullable Object value) {
            if (value == null) {
                return NULL;
            }
            if (value instanceof Value) {
                return EffectiveConstant.from((Value)value);
            }
            if (value instanceof Boolean) {
                if (((Boolean)value).booleanValue()) {
                    return TRUE;
                }
                return FALSE;
            }
            return NOT_NULL;
        }

        public static EffectiveConstant from(@Nonnull Value value) {
            if (value instanceof NullValue) {
                return NULL;
            }
            if (value.getResultType().getTypeCode() == Type.TypeCode.BOOLEAN && value instanceof LiteralValue) {
                Boolean plainValue = (Boolean)((LiteralValue)value).getLiteralValue();
                if (plainValue == null) {
                    return NULL;
                }
                if (plainValue.booleanValue()) {
                    return TRUE;
                }
                return FALSE;
            }
            if (value.getResultType().isNotNullable()) {
                return NOT_NULL;
            }
            return UNKNOWN;
        }
    }

    public static enum PredicateCategory {
        SINGLETON_NULL(ConstantPredicate.NULL),
        SINGLETON_TRUE(ConstantPredicate.TRUE),
        SINGLETON_FALSE(ConstantPredicate.FALSE),
        UNKNOWN(null);

        @Nonnull
        private final Optional<ConstantPredicate> predicateMaybe;

        private PredicateCategory(ConstantPredicate predicate) {
            this.predicateMaybe = Optional.ofNullable(predicate);
        }

        @Nonnull
        Optional<ConstantPredicate> getPredicateMaybe() {
            return this.predicateMaybe;
        }
    }
}

