/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.predicates.simplification;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ListMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QueryPredicateMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.TypedMatcher;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AndOrPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AndPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.NotPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.OrPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.simplification.QueryPredicateSimplificationRule;
import com.apple.foundationdb.record.query.plan.cascades.predicates.simplification.QueryPredicateSimplificationRuleCall;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class DeMorgansTheoremRule<P extends AndOrPredicate>
extends QueryPredicateSimplificationRule<NotPredicate> {
    @Nonnull
    private final Class<P> majorClass;
    @Nonnull
    private final BindingMatcher<QueryPredicate> termMatcher;
    @Nonnull
    private final BindingMatcher<P> andOrPredicateMatcher;

    public DeMorgansTheoremRule(@Nonnull Class<P> majorClass, @Nonnull BindingMatcher<QueryPredicate> termMatcher, @Nonnull BindingMatcher<P> andOrPredicateMatcher, @Nonnull BindingMatcher<NotPredicate> rootMatcher) {
        super(rootMatcher);
        this.majorClass = majorClass;
        this.andOrPredicateMatcher = andOrPredicateMatcher;
        this.termMatcher = termMatcher;
    }

    @Override
    @Nonnull
    public Optional<Class<?>> getRootOperator() {
        return Optional.of(NotPredicate.class);
    }

    @Override
    public void onMatch(@Nonnull QueryPredicateSimplificationRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        List<QueryPredicate> majorTerms = bindings.getAll(this.termMatcher);
        ImmutableList minorTerms = majorTerms.stream().map(NotPredicate::not).collect(ImmutableList.toImmutableList());
        call.yieldResultBuilder().addConstraintsFrom((QueryPredicate)bindings.get(this.getMatcher()), (QueryPredicate)bindings.get(this.andOrPredicateMatcher)).yieldResultAndReExplore(this.minorWith(minorTerms));
    }

    private QueryPredicate minorWith(@Nonnull Collection<? extends QueryPredicate> terms) {
        if (this.majorClass == AndPredicate.class) {
            return OrPredicate.or(terms);
        }
        if (this.majorClass == OrPredicate.class) {
            return AndPredicate.and(terms);
        }
        throw new RecordCoreException("unsupported major", new Object[0]);
    }

    public static <P extends AndOrPredicate> DeMorgansTheoremRule<P> withMajor(@Nonnull Class<P> majorClass) {
        TypedMatcher<QueryPredicate> termMatcher = QueryPredicateMatchers.anyPredicate();
        BindingMatcher<P> andOrPredicateMatcher = QueryPredicateMatchers.ofTypeWithChildren(majorClass, MultiMatcher.all(termMatcher));
        return new DeMorgansTheoremRule<P>(majorClass, termMatcher, andOrPredicateMatcher, QueryPredicateMatchers.notPredicate(ListMatcher.exactly(andOrPredicateMatcher)));
    }
}

