/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.predicates.simplification;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QueryPredicateMatchers;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.simplification.QueryPredicateSimplificationRule;
import com.apple.foundationdb.record.query.plan.cascades.predicates.simplification.QueryPredicateSimplificationRuleCall;
import com.apple.foundationdb.record.query.plan.planning.BooleanPredicateNormalizer;
import java.util.Optional;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class NormalFormRule
extends QueryPredicateSimplificationRule<QueryPredicate> {
    @Nonnull
    private static final BindingMatcher<QueryPredicate> anyPredicateMatcher = QueryPredicateMatchers.anyPredicate();
    @Nonnull
    private final BooleanPredicateNormalizer normalizer;

    public NormalFormRule(@Nonnull BooleanPredicateNormalizer normalizer) {
        super(anyPredicateMatcher);
        this.normalizer = normalizer;
    }

    @Override
    @Nonnull
    public Optional<Class<?>> getRootOperator() {
        return Optional.empty();
    }

    @Override
    public void onMatch(@Nonnull QueryPredicateSimplificationRuleCall call) {
        if (!call.isRoot()) {
            return;
        }
        PlannerBindings bindings = call.getBindings();
        QueryPredicate predicate = bindings.get(anyPredicateMatcher);
        Optional<QueryPredicate> normalizedPredicateMaybe = this.normalizer.normalize(predicate, false);
        normalizedPredicateMaybe.ifPresent(normalizedPredicate -> call.yieldResultAndReExplore((QueryPredicate)normalizedPredicateMaybe.get()));
    }
}

