/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.predicates.simplification;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ListMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QueryPredicateMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ValueMatchers;
import com.apple.foundationdb.record.query.plan.cascades.predicates.NotPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ValuePredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.simplification.QueryPredicateSimplificationRule;
import com.apple.foundationdb.record.query.plan.cascades.predicates.simplification.QueryPredicateSimplificationRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import java.util.Optional;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class NotOverComparisonRule
extends QueryPredicateSimplificationRule<NotPredicate> {
    @Nonnull
    private static final BindingMatcher<Value> anyValueMatcher = ValueMatchers.anyValue();
    @Nonnull
    private static final BindingMatcher<Comparisons.Comparison> anyComparisonMatcher = QueryPredicateMatchers.anyComparison();
    @Nonnull
    private static final BindingMatcher<ValuePredicate> anyValuePredicateMatcher = QueryPredicateMatchers.valuePredicate(anyValueMatcher, anyComparisonMatcher);
    @Nonnull
    private static final BindingMatcher<NotPredicate> rootMatcher = QueryPredicateMatchers.notPredicate(ListMatcher.exactly(anyValuePredicateMatcher));

    public NotOverComparisonRule() {
        super(rootMatcher);
    }

    @Override
    @Nonnull
    public Optional<Class<?>> getRootOperator() {
        return Optional.of(NotPredicate.class);
    }

    @Override
    public void onMatch(@Nonnull QueryPredicateSimplificationRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        Value value = bindings.get(anyValueMatcher);
        Comparisons.Comparison comparison = bindings.get(anyComparisonMatcher);
        Comparisons.Type invertedComparisonType = Comparisons.invertComparisonType(comparison.getType());
        if (invertedComparisonType == null) {
            return;
        }
        call.yieldResultBuilder().addConstraintsFrom(bindings.get(rootMatcher)).addConstraintsFrom(bindings.getAll(anyValuePredicateMatcher)).yieldResult(new ValuePredicate(value, comparison.withType(invertedComparisonType)));
    }
}

