/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.predicates.simplification;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QueryPredicateMatchers;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithValue;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.simplification.QueryPredicateSimplificationRule;
import com.apple.foundationdb.record.query.plan.cascades.predicates.simplification.QueryPredicateSimplificationRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.DereferenceConstantObjectValueRuleSet;
import java.util.Optional;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class ValuePredicateSimplificationRule
extends QueryPredicateSimplificationRule<PredicateWithValue> {
    @Nonnull
    private static final BindingMatcher<PredicateWithValue> rootMatcher = QueryPredicateMatchers.predicateWithValue();

    public ValuePredicateSimplificationRule() {
        super(rootMatcher);
    }

    @Override
    @Nonnull
    public Optional<Class<?>> getRootOperator() {
        return Optional.empty();
    }

    @Override
    public void onMatch(@Nonnull QueryPredicateSimplificationRuleCall call) {
        PredicateWithValue predicateWithValue = call.getBindings().get(rootMatcher);
        Optional<? extends PredicateWithValue> simplifiedPredicateMaybe = predicateWithValue.translateValueAndComparisonsMaybe(value -> Optional.of(value.simplify(call.getEvaluationContext(), call.getEquivalenceMap(), call.getConstantAliases(), DereferenceConstantObjectValueRuleSet.instance())), comparison -> {
            Comparisons.Type comparisonType;
            if (comparison instanceof Comparisons.ValueComparison && !(comparisonType = comparison.getType()).isUnary()) {
                Value simplifiedOperand = comparison.getValue().simplify(call.getEvaluationContext(), call.getEquivalenceMap(), call.getConstantAliases(), DereferenceConstantObjectValueRuleSet.instance());
                return Optional.of(comparison.withValue(simplifiedOperand));
            }
            return Optional.of(comparison);
        });
        if (simplifiedPredicateMaybe.isPresent() && simplifiedPredicateMaybe.get() != predicateWithValue) {
            call.yieldResult((QueryPredicate)simplifiedPredicateMaybe.get());
        }
    }
}

