/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.properties;

import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.plan.bitmap.ComposedBitmapIndexQueryPlan;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ExpressionProperty;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.Ordering;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.ValueIndexScanMatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.WithPrimaryKeyMatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.expressions.DeleteExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.ExplodeExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.FullUnorderedScanExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.GroupByExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.InsertExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalDistinctExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalFilterExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalIntersectionExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalProjectionExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalSortExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalTypeFilterExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalUnionExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalUniqueExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.MatchableSortExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RecursiveUnionExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.TableFunctionExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.TempTableInsertExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.TempTableScanExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.UpdateExpression;
import com.apple.foundationdb.record.query.plan.cascades.values.LiteralValue;
import com.apple.foundationdb.record.query.plan.cascades.values.StreamingValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.plans.InComparandSource;
import com.apple.foundationdb.record.query.plan.plans.InParameterSource;
import com.apple.foundationdb.record.query.plan.plans.InSource;
import com.apple.foundationdb.record.query.plan.plans.InValuesSource;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryAggregateIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryComparatorPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryCoveringIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryDefaultOnEmptyPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryDeletePlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryExplodePlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFirstOrDefaultPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFlatMapPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInComparandJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInParameterJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInUnionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInUnionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInUnionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInValuesJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInsertPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryLoadByKeysPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryMapPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryMultiIntersectionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPredicatesFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryRangePlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryRecursiveDfsJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryRecursiveLevelUnionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryScanPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryScoreForRankPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQuerySelectorPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryStreamingAggregationPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTableFunctionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTextIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTypeFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedDistinctPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedPrimaryKeyDistinctPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedUnionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUpdatePlan;
import com.apple.foundationdb.record.query.plan.plans.TempTableInsertPlan;
import com.apple.foundationdb.record.query.plan.plans.TempTableScanPlan;
import com.apple.foundationdb.record.query.plan.sorting.RecordQueryDamPlan;
import com.apple.foundationdb.record.query.plan.sorting.RecordQuerySortPlan;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import javax.annotation.Nonnull;

public class CardinalitiesProperty
implements ExpressionProperty<Cardinalities> {
    private static final CardinalitiesProperty CARDINALITIES = new CardinalitiesProperty();

    private CardinalitiesProperty() {
    }

    @Override
    @Nonnull
    public RelationalExpressionVisitor<Cardinalities> createVisitor() {
        return new CardinalitiesVisitor();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Nonnull
    public Cardinalities evaluate(@Nonnull Reference ref) {
        return this.evaluate(ref.get());
    }

    @Nonnull
    public Cardinalities evaluate(@Nonnull RelationalExpression expression) {
        return this.createVisitor().visit(expression);
    }

    @Nonnull
    public static CardinalitiesProperty cardinalities() {
        return CARDINALITIES;
    }

    public static class CardinalitiesVisitor
    implements RelationalExpressionVisitor<Cardinalities> {
        @Override
        @Nonnull
        public Cardinalities visitRecordQueryUpdatePlan(@Nonnull RecordQueryUpdatePlan updatePlan) {
            return this.fromChild(updatePlan);
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryPredicatesFilterPlan(@Nonnull RecordQueryPredicatesFilterPlan predicatesFilterPlan) {
            Cardinalities cardinalitiesFromChild = this.fromChild(predicatesFilterPlan);
            return cardinalitiesFromChild.floor(0L);
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryLoadByKeysPlan(@Nonnull RecordQueryLoadByKeysPlan element) {
            RecordQueryLoadByKeysPlan.KeysSource keysSource = element.getKeysSource();
            if (keysSource.maxCardinality() == Integer.MAX_VALUE) {
                return Cardinalities.unknownCardinalities;
            }
            return new Cardinalities(Cardinality.ofCardinality(0L), Cardinality.ofCardinality(keysSource.maxCardinality()));
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryInValuesJoinPlan(@Nonnull RecordQueryInValuesJoinPlan inValuesJoinPlan) {
            Cardinalities childCardinalities = this.fromChild(inValuesJoinPlan);
            int valuesSize = inValuesJoinPlan.getInListValues().size();
            return new Cardinalities(Cardinality.ofCardinality(valuesSize).times(childCardinalities.getMinCardinality()), Cardinality.ofCardinality(valuesSize).times(childCardinalities.getMaxCardinality()));
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryAggregateIndexPlan(@Nonnull RecordQueryAggregateIndexPlan aggregateIndexPlan) {
            Optional<Value> groupingValueMaybe = aggregateIndexPlan.getGroupingValueMaybe();
            if (groupingValueMaybe.isEmpty()) {
                return Cardinalities.atMostOne();
            }
            Value groupingValue = groupingValueMaybe.get();
            RecordQueryIndexPlan indexScanPlan = aggregateIndexPlan.getIndexPlan();
            Optional<? extends MatchCandidate> matchCandidateOptional = indexScanPlan.getMatchCandidateMaybe();
            if (matchCandidateOptional.isEmpty()) {
                return Cardinalities.unknownMaxCardinality();
            }
            Ordering ordering = matchCandidateOptional.get().computeOrderingFromScanComparisons(indexScanPlan.getScanComparisons(), indexScanPlan.isReverse(), false);
            if (ordering.getEqualityBoundValues().contains(groupingValue)) {
                return Cardinalities.atMostOne();
            }
            return Cardinalities.unknownMaxCardinality();
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryCoveringIndexPlan(@Nonnull RecordQueryCoveringIndexPlan coveringIndexPlan) {
            if (!(coveringIndexPlan.getIndexPlan() instanceof RecordQueryIndexPlan)) {
                return Cardinalities.unknownMaxCardinality();
            }
            return this.visitRecordQueryIndexPlan((RecordQueryIndexPlan)coveringIndexPlan.getIndexPlan());
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryDeletePlan(@Nonnull RecordQueryDeletePlan deletePlan) {
            return this.fromChild(deletePlan);
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryMapPlan(@Nonnull RecordQueryMapPlan mapPlan) {
            return this.fromChild(mapPlan);
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryComparatorPlan(@Nonnull RecordQueryComparatorPlan comparatorPlan) {
            return this.weakenCardinalities(this.fromChildren(comparatorPlan));
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryUnorderedDistinctPlan(@Nonnull RecordQueryUnorderedDistinctPlan unorderedDistinctPlan) {
            return this.fromChild(unorderedDistinctPlan);
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryIntersectionOnKeyExpressionPlan(@Nonnull RecordQueryIntersectionOnKeyExpressionPlan intersectionOnKeyExpressionPlan) {
            return this.intersectCardinalities(this.fromChildren(intersectionOnKeyExpressionPlan));
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQuerySelectorPlan(@Nonnull RecordQuerySelectorPlan selectorPlan) {
            return this.weakenCardinalities(this.fromChildren(selectorPlan));
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryRangePlan(@Nonnull RecordQueryRangePlan rangePlan) {
            Value limitValue = rangePlan.getExclusiveLimitValue();
            if (limitValue instanceof LiteralValue) {
                Cardinality limit = Cardinality.ofCardinality(((Integer)Verify.verifyNotNull(limitValue.evalWithoutStore(EvaluationContext.EMPTY))).intValue());
                return new Cardinalities(limit, limit);
            }
            return Cardinalities.unknownMaxCardinality();
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryExplodePlan(@Nonnull RecordQueryExplodePlan element) {
            return Cardinalities.unknownMaxCardinality();
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryInsertPlan(@Nonnull RecordQueryInsertPlan insertPlan) {
            return this.fromChild(insertPlan);
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryTableFunctionPlan(@Nonnull RecordQueryTableFunctionPlan element) {
            return Cardinalities.unknownMaxCardinality();
        }

        @Override
        @Nonnull
        public Cardinalities visitTempTableInsertPlan(@Nonnull TempTableInsertPlan tempTableInsertPlan) {
            return this.fromChild(tempTableInsertPlan);
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryIntersectionOnValuesPlan(@Nonnull RecordQueryIntersectionOnValuesPlan intersectionOnValuesPlan) {
            return this.intersectCardinalities(this.fromChildren(intersectionOnValuesPlan));
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryScoreForRankPlan(@Nonnull RecordQueryScoreForRankPlan scoreForRankPlan) {
            return this.fromChild(scoreForRankPlan);
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryIndexPlan(@Nonnull RecordQueryIndexPlan indexPlan) {
            List<Value> primaryKeyValues;
            Optional<List<Value>> primaryKeyValuesOptional;
            Optional<? extends MatchCandidate> matchCandidateOptional = indexPlan.getMatchCandidateMaybe();
            if (matchCandidateOptional.isEmpty()) {
                return Cardinalities.unknownMaxCardinality();
            }
            MatchCandidate matchCandidate = matchCandidateOptional.get();
            Ordering ordering = matchCandidate.computeOrderingFromScanComparisons(indexPlan.getScanComparisons(), indexPlan.isReverse(), false);
            Set<Value> equalityBoundValues = ordering.getEqualityBoundValues();
            if (matchCandidate instanceof WithPrimaryKeyMatchCandidate && (primaryKeyValuesOptional = ((WithPrimaryKeyMatchCandidate)matchCandidate).getPrimaryKeyValuesMaybe()).isPresent() && equalityBoundValues.containsAll(primaryKeyValues = primaryKeyValuesOptional.get())) {
                return Cardinalities.atMostOne();
            }
            if (matchCandidate.isUnique() && matchCandidate instanceof ValueIndexScanMatchCandidate) {
                ValueIndexScanMatchCandidate valueIndexScanMatchCandidate = (ValueIndexScanMatchCandidate)matchCandidate;
                AliasMap translationMap = AliasMap.ofAliases(valueIndexScanMatchCandidate.getBaseAlias(), Quantifier.current());
                ImmutableList keyValues = valueIndexScanMatchCandidate.getIndexKeyValues().stream().limit(matchCandidate.getColumnSize()).map(keyValue -> keyValue.rebase(translationMap)).collect(ImmutableList.toImmutableList());
                if (equalityBoundValues.containsAll(keyValues)) {
                    return Cardinalities.atMostOne();
                }
            }
            return Cardinalities.unknownMaxCardinality();
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryFirstOrDefaultPlan(@Nonnull RecordQueryFirstOrDefaultPlan element) {
            return new Cardinalities(Cardinality.ofCardinality(1L), Cardinality.ofCardinality(1L));
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryDefaultOnEmptyPlan(@Nonnull RecordQueryDefaultOnEmptyPlan defaultOnEmptyPlan) {
            Cardinalities cardinalitiesFromChild = this.fromChild(defaultOnEmptyPlan);
            return cardinalitiesFromChild.floor(1L);
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryUnionOnKeyExpressionPlan(@Nonnull RecordQueryUnionOnKeyExpressionPlan unionOnKeyExpressionPlan) {
            return this.unionCardinalities(this.fromChildren(unionOnKeyExpressionPlan));
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryFilterPlan(@Nonnull RecordQueryFilterPlan filterPlan) {
            Cardinalities cardinalitiesFromChild = this.fromChild(filterPlan);
            return new Cardinalities(Cardinality.ofCardinality(0L), cardinalitiesFromChild.getMaxCardinality());
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryUnorderedPrimaryKeyDistinctPlan(@Nonnull RecordQueryUnorderedPrimaryKeyDistinctPlan unorderedPrimaryKeyDistinctPlan) {
            Cardinalities cardinalitiesFromChild = this.fromChild(unorderedPrimaryKeyDistinctPlan);
            if (!cardinalitiesFromChild.getMinCardinality().isUnknown() && cardinalitiesFromChild.getMinCardinality().getCardinality() >= 1L) {
                return new Cardinalities(Cardinality.ofCardinality(1L), cardinalitiesFromChild.getMaxCardinality());
            }
            return cardinalitiesFromChild;
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryTextIndexPlan(@Nonnull RecordQueryTextIndexPlan element) {
            return Cardinalities.unknownMaxCardinality();
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryFetchFromPartialRecordPlan(@Nonnull RecordQueryFetchFromPartialRecordPlan fetchFromPartialRecordPlan) {
            return this.fromChild(fetchFromPartialRecordPlan);
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryTypeFilterPlan(@Nonnull RecordQueryTypeFilterPlan typeFilterPlan) {
            return this.fromChild(typeFilterPlan);
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryInUnionOnKeyExpressionPlan(@Nonnull RecordQueryInUnionOnKeyExpressionPlan inUnionOnKeyExpressionPlan) {
            return this.visitRecordQueryInUnionPlan(inUnionOnKeyExpressionPlan);
        }

        @Nonnull
        public Cardinalities visitRecordQueryInUnionPlan(@Nonnull RecordQueryInUnionPlan inUnionPlan) {
            List<? extends InSource> inSources = inUnionPlan.getInSources();
            Optional<Cardinalities> inSourcesCardinalitiesOptional = inSources.stream().map(inSource -> {
                if (inSource instanceof InParameterSource || inSource instanceof InComparandSource) {
                    return Cardinalities.unknownMaxCardinality();
                }
                Verify.verify(inSource instanceof InValuesSource);
                InValuesSource inValuesSource = (InValuesSource)inSource;
                int size = inValuesSource.getValues().size();
                return new Cardinalities(Cardinality.ofCardinality(size), Cardinality.ofCardinality(size));
            }).reduce(Cardinalities::times);
            Verify.verify(inSourcesCardinalitiesOptional.isPresent());
            Cardinalities inSourcesCardinalities = inSourcesCardinalitiesOptional.get();
            Cardinalities childCardinalities = this.fromChild(inUnionPlan);
            return inSourcesCardinalities.times(childCardinalities);
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryMultiIntersectionOnValuesPlan(@Nonnull RecordQueryMultiIntersectionOnValuesPlan recordQueryMultiIntersectionOnValuesPlan) {
            return this.intersectCardinalities(this.fromChildren(recordQueryMultiIntersectionOnValuesPlan));
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryInParameterJoinPlan(@Nonnull RecordQueryInParameterJoinPlan element) {
            return Cardinalities.unknownMaxCardinality();
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryInComparandJoinPlan(@Nonnull RecordQueryInComparandJoinPlan element) {
            return Cardinalities.unknownMaxCardinality();
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryRecursiveLevelUnionPlan(@Nonnull RecordQueryRecursiveLevelUnionPlan element) {
            Cardinalities initialStateCardinality = this.fromChild(element.getChildren().get(0));
            return new Cardinalities(initialStateCardinality.minCardinality, Cardinality.unknownCardinality);
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryFlatMapPlan(@Nonnull RecordQueryFlatMapPlan flatMapPlan) {
            List<Cardinalities> fromChildren = this.fromChildren(flatMapPlan);
            Cardinalities outerCardinalities = fromChildren.get(0);
            Cardinalities innerCardinalities = fromChildren.get(1);
            return outerCardinalities.times(innerCardinalities);
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryStreamingAggregationPlan(@Nonnull RecordQueryStreamingAggregationPlan element) {
            if (element.getGroupingValue() == null) {
                return new Cardinalities(Cardinality.ofCardinality(0L), Cardinality.ofCardinality(1L));
            }
            if (element.getGroupingValue().isConstant()) {
                return new Cardinalities(Cardinality.ofCardinality(0L), Cardinality.ofCardinality(1L));
            }
            return Cardinalities.unknownMaxCardinality();
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryUnionOnValuesPlan(@Nonnull RecordQueryUnionOnValuesPlan unionOnValuesPlan) {
            return this.unionCardinalities(this.fromChildren(unionOnValuesPlan));
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryUnorderedUnionPlan(@Nonnull RecordQueryUnorderedUnionPlan unorderedUnionPlan) {
            return this.unionCardinalities(this.fromChildren(unorderedUnionPlan));
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryScanPlan(@Nonnull RecordQueryScanPlan scanPlan) {
            Optional<? extends WithPrimaryKeyMatchCandidate> matchCandidateOptional = scanPlan.getMatchCandidateMaybe();
            if (matchCandidateOptional.isEmpty()) {
                return Cardinalities.unknownMaxCardinality();
            }
            WithPrimaryKeyMatchCandidate matchCandidate = matchCandidateOptional.get();
            Optional<List<Value>> primaryKeyValuesOptional = matchCandidate.getPrimaryKeyValuesMaybe();
            if (primaryKeyValuesOptional.isEmpty()) {
                return Cardinalities.unknownMaxCardinality();
            }
            List<Value> primaryKeyValues = primaryKeyValuesOptional.get();
            Ordering ordering = matchCandidate.computeOrderingFromScanComparisons(scanPlan.getScanComparisons(), scanPlan.isReverse(), false);
            Set<Value> equalityBoundValues = ordering.getEqualityBoundValues();
            if (equalityBoundValues.containsAll(primaryKeyValues)) {
                return new Cardinalities(Cardinality.ofCardinality(0L), Cardinality.ofCardinality(1L));
            }
            return Cardinalities.unknownMaxCardinality();
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryInUnionOnValuesPlan(@Nonnull RecordQueryInUnionOnValuesPlan inUnionOnValuesPlan) {
            return this.visitRecordQueryInUnionPlan(inUnionOnValuesPlan);
        }

        @Override
        @Nonnull
        public Cardinalities visitComposedBitmapIndexQueryPlan(@Nonnull ComposedBitmapIndexQueryPlan element) {
            return Cardinalities.unknownMaxCardinality();
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryDamPlan(@Nonnull RecordQueryDamPlan damPlan) {
            return this.fromChild(damPlan);
        }

        @Override
        @Nonnull
        public Cardinalities visitMatchableSortExpression(@Nonnull MatchableSortExpression matchableSortExpression) {
            return this.fromChild(matchableSortExpression);
        }

        @Override
        @Nonnull
        public Cardinalities visitInsertExpression(@Nonnull InsertExpression insertExpression) {
            return this.fromChild(insertExpression);
        }

        @Override
        @Nonnull
        public Cardinalities visitTempTableInsertExpression(@Nonnull TempTableInsertExpression tempTableInsertExpression) {
            return this.fromChild(tempTableInsertExpression);
        }

        @Override
        @Nonnull
        public Cardinalities visitRecursiveUnionExpression(@Nonnull RecursiveUnionExpression element) {
            Cardinalities initialStateCardinality = this.fromQuantifier(element.getQuantifiers().get(0));
            return new Cardinalities(initialStateCardinality.minCardinality, Cardinality.unknownCardinality);
        }

        @Override
        @Nonnull
        public Cardinalities visitLogicalSortExpression(@Nonnull LogicalSortExpression logicalSortExpression) {
            return this.fromChild(logicalSortExpression);
        }

        @Override
        @Nonnull
        public Cardinalities visitLogicalTypeFilterExpression(@Nonnull LogicalTypeFilterExpression logicalTypeFilterExpression) {
            return this.fromChild(logicalTypeFilterExpression);
        }

        @Override
        @Nonnull
        public Cardinalities visitLogicalUnionExpression(@Nonnull LogicalUnionExpression logicalUnionExpression) {
            return this.unionCardinalities(this.fromChildren(logicalUnionExpression));
        }

        @Override
        @Nonnull
        public Cardinalities visitLogicalIntersectionExpression(@Nonnull LogicalIntersectionExpression logicalIntersectionExpression) {
            return this.intersectCardinalities(this.fromChildren(logicalIntersectionExpression));
        }

        @Override
        @Nonnull
        public Cardinalities visitTableFunctionExpression(@Nonnull TableFunctionExpression element) {
            StreamingValue streamingValue = element.getValue();
            return streamingValue.getCardinalities();
        }

        @Override
        @Nonnull
        public Cardinalities visitLogicalUniqueExpression(@Nonnull LogicalUniqueExpression logicalUniqueExpression) {
            return this.fromChild(logicalUniqueExpression);
        }

        @Override
        @Nonnull
        public Cardinalities visitLogicalProjectionExpression(@Nonnull LogicalProjectionExpression logicalProjectionExpression) {
            return this.fromChild(logicalProjectionExpression);
        }

        @Override
        @Nonnull
        public Cardinalities visitSelectExpression(@Nonnull SelectExpression selectExpression) {
            return (Cardinalities)this.fromChildren(selectExpression).stream().reduce(Cardinalities::times).orElseThrow(() -> new RecordCoreException("must have at least one quantifier", new Object[0]));
        }

        @Override
        @Nonnull
        public Cardinalities visitExplodeExpression(@Nonnull ExplodeExpression element) {
            return Cardinalities.unknownMaxCardinality();
        }

        @Override
        @Nonnull
        public Cardinalities visitFullUnorderedScanExpression(@Nonnull FullUnorderedScanExpression element) {
            return Cardinalities.unknownMaxCardinality();
        }

        @Override
        @Nonnull
        public Cardinalities visitTempTableScanExpression(@Nonnull TempTableScanExpression element) {
            return Cardinalities.unknownMaxCardinality();
        }

        @Override
        @Nonnull
        public Cardinalities visitGroupByExpression(@Nonnull GroupByExpression element) {
            if (element.getGroupingValue() == null) {
                return Cardinalities.exactlyOne();
            }
            if (element.getGroupingValue().isConstant()) {
                return Cardinalities.atMostOne();
            }
            return Cardinalities.unknownMaxCardinality();
        }

        @Override
        @Nonnull
        public Cardinalities visitUpdateExpression(@Nonnull UpdateExpression updateExpression) {
            return this.fromChild(updateExpression);
        }

        @Override
        @Nonnull
        public Cardinalities visitLogicalDistinctExpression(@Nonnull LogicalDistinctExpression logicalDistinctExpression) {
            return this.fromChild(logicalDistinctExpression);
        }

        @Override
        @Nonnull
        public Cardinalities visitLogicalFilterExpression(@Nonnull LogicalFilterExpression logicalFilterExpression) {
            return this.fromChild(logicalFilterExpression);
        }

        @Override
        @Nonnull
        public Cardinalities visitDeleteExpression(@Nonnull DeleteExpression deleteExpression) {
            return this.fromChild(deleteExpression);
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQuerySortPlan(@Nonnull RecordQuerySortPlan querySortPlan) {
            return this.fromChild(querySortPlan);
        }

        @Override
        @Nonnull
        public Cardinalities visitRecordQueryRecursiveDfsJoinPlan(@Nonnull RecordQueryRecursiveDfsJoinPlan recursiveDfsJoinPlan) {
            return Cardinalities.unknownMaxCardinality();
        }

        @Override
        @Nonnull
        public Cardinalities visitTempTableScanPlan(@Nonnull TempTableScanPlan element) {
            return Cardinalities.unknownMaxCardinality();
        }

        @Nonnull
        private Cardinalities intersectCardinalities(@Nonnull Iterable<Cardinalities> cardinalitiesIterable) {
            Cardinality minCardinality = Cardinality.unknownCardinality();
            Cardinality maxCardinality = Cardinality.unknownCardinality();
            for (Cardinalities cardinalities : cardinalitiesIterable) {
                minCardinality = minCardinality.isUnknown() ? cardinalities.getMinCardinality() : (!cardinalities.getMinCardinality().isUnknown() ? Cardinality.ofCardinality(0L) : Cardinality.unknownCardinality());
                if (maxCardinality.isUnknown()) {
                    maxCardinality = cardinalities.getMaxCardinality();
                    continue;
                }
                if (!cardinalities.getMaxCardinality().isUnknown()) {
                    maxCardinality = Cardinality.ofCardinality(Math.min(maxCardinality.getCardinality(), cardinalities.getMaxCardinality().getCardinality()));
                    continue;
                }
                maxCardinality = Cardinality.unknownCardinality();
            }
            return new Cardinalities(minCardinality, maxCardinality);
        }

        @Nonnull
        private Cardinalities unionCardinalities(@Nonnull Iterable<Cardinalities> cardinalitiesIterable) {
            Iterator<Cardinalities> iterator = cardinalitiesIterable.iterator();
            if (!iterator.hasNext()) {
                return Cardinalities.unknownMaxCardinality();
            }
            Cardinalities cardinalities = iterator.next();
            Cardinality minCardinality = cardinalities.getMinCardinality();
            Cardinality maxCardinality = cardinalities.getMaxCardinality();
            while (iterator.hasNext()) {
                cardinalities = iterator.next();
                if (!minCardinality.isUnknown()) {
                    Cardinality currentMinCardinality = cardinalities.getMinCardinality();
                    minCardinality = currentMinCardinality.isUnknown() ? Cardinality.unknownCardinality() : Cardinality.ofCardinality(minCardinality.getCardinality() + currentMinCardinality.getCardinality());
                }
                if (maxCardinality.isUnknown()) continue;
                Cardinality currentMaxCardinality = cardinalities.getMaxCardinality();
                if (currentMaxCardinality.isUnknown()) {
                    maxCardinality = Cardinality.unknownCardinality();
                    continue;
                }
                maxCardinality = Cardinality.ofCardinality(maxCardinality.getCardinality() + currentMaxCardinality.getCardinality());
            }
            return new Cardinalities(minCardinality, maxCardinality);
        }

        @Nonnull
        private Cardinalities weakenCardinalities(@Nonnull Iterable<Cardinalities> cardinalitiesIterable) {
            Iterator<Cardinalities> iterator = cardinalitiesIterable.iterator();
            if (!iterator.hasNext()) {
                return Cardinalities.unknownMaxCardinality();
            }
            Cardinalities cardinalities = iterator.next();
            Cardinality minCardinality = cardinalities.getMinCardinality();
            Cardinality maxCardinality = cardinalities.getMaxCardinality();
            while (iterator.hasNext()) {
                Cardinality currentMaxCardinality;
                Cardinality currentMinCardinality;
                cardinalities = iterator.next();
                if (!minCardinality.isUnknown() && ((currentMinCardinality = cardinalities.getMinCardinality()).isUnknown() || minCardinality.getCardinality() > currentMinCardinality.getCardinality())) {
                    minCardinality = currentMinCardinality;
                }
                if (maxCardinality.isUnknown() || !(currentMaxCardinality = cardinalities.getMaxCardinality()).isUnknown() && maxCardinality.getCardinality() >= currentMaxCardinality.getCardinality()) continue;
                maxCardinality = currentMaxCardinality;
            }
            return new Cardinalities(minCardinality, maxCardinality);
        }

        @Nonnull
        private Cardinalities fromChild(@Nonnull RelationalExpression relationalExpression) {
            Verify.verify(relationalExpression.getQuantifiers().size() == 1);
            return Iterables.getOnlyElement(this.fromChildren(relationalExpression));
        }

        @Nonnull
        private List<Cardinalities> fromChildren(@Nonnull RelationalExpression relationalExpression) {
            return this.fromQuantifiers(relationalExpression.getQuantifiers());
        }

        @Nonnull
        private List<Cardinalities> fromQuantifiers(@Nonnull List<? extends Quantifier> quantifiers) {
            ArrayList<Cardinalities> quantifierResults = Lists.newArrayListWithCapacity(quantifiers.size());
            for (Quantifier quantifier : quantifiers) {
                quantifierResults.add(this.fromQuantifier(quantifier));
            }
            return quantifierResults;
        }

        @Nonnull
        private Cardinalities fromQuantifier(@Nonnull Quantifier quantifier) {
            if (quantifier instanceof Quantifier.Existential) {
                return Cardinalities.exactlyOne();
            }
            Cardinalities childCardinalities = (Cardinalities)this.visit(quantifier.getRangesOver().get());
            if (quantifier instanceof Quantifier.ForEach && ((Quantifier.ForEach)quantifier).isNullOnEmpty()) {
                return childCardinalities.floor(1L);
            }
            return childCardinalities;
        }

        @Override
        @Nonnull
        public Cardinalities visitDefault(@Nonnull RelationalExpression element) {
            throw new RecordCoreException("not implemented", new Object[0]);
        }
    }

    @SpotBugsSuppressWarnings(value={"SING_SINGLETON_HAS_NONPRIVATE_CONSTRUCTOR"}, justification="False positive as this is not a singleton class")
    public static class Cardinalities {
        @Nonnull
        private static final Cardinalities unknownCardinalities = new Cardinalities(Cardinality.unknownCardinality(), Cardinality.unknownCardinality());
        @Nonnull
        private static final Cardinalities unknownMaxCardinality = new Cardinalities(Cardinality.zero, Cardinality.unknownCardinality());
        @Nonnull
        private static final Cardinalities exactlyOne = new Cardinalities(Cardinality.one, Cardinality.one);
        @Nonnull
        private static final Cardinalities atMostOne = new Cardinalities(Cardinality.zero, Cardinality.one);
        @Nonnull
        private final Cardinality minCardinality;
        @Nonnull
        private final Cardinality maxCardinality;

        public Cardinalities(@Nonnull Cardinality minCardinality, @Nonnull Cardinality maxCardinality) {
            this.minCardinality = minCardinality;
            this.maxCardinality = maxCardinality;
        }

        @Nonnull
        public Cardinality getMinCardinality() {
            return this.minCardinality;
        }

        @Nonnull
        public Cardinality getMaxCardinality() {
            return this.maxCardinality;
        }

        public Cardinalities times(@Nonnull Cardinalities otherCardinalities) {
            return new Cardinalities(this.getMinCardinality().times(otherCardinalities.getMinCardinality()), this.getMaxCardinality().times(otherCardinalities.getMaxCardinality()));
        }

        @Nonnull
        public Cardinalities floor(long minimum) {
            Cardinality newMin = this.minCardinality.floor(minimum);
            Cardinality newMax = this.maxCardinality.floor(minimum);
            if (newMin.equals(this.minCardinality) && newMax.equals(this.maxCardinality)) {
                return this;
            }
            return new Cardinalities(newMin, newMax);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Cardinalities that = (Cardinalities)object;
            return Objects.equals(this.minCardinality, that.minCardinality) && Objects.equals(this.maxCardinality, that.maxCardinality);
        }

        public int hashCode() {
            return Objects.hash(this.minCardinality, this.maxCardinality);
        }

        @Nonnull
        public static Cardinalities unknownCardinalities() {
            return unknownCardinalities;
        }

        @Nonnull
        public static Cardinalities exactlyOne() {
            return exactlyOne;
        }

        @Nonnull
        public static Cardinalities atMostOne() {
            return atMostOne;
        }

        @Nonnull
        public static Cardinalities unknownMaxCardinality() {
            return unknownMaxCardinality;
        }
    }

    public static class Cardinality {
        private static final Cardinality unknownCardinality = new Cardinality(OptionalLong.empty());
        private static final Cardinality zero = Cardinality.ofCardinality(0L);
        private static final Cardinality one = Cardinality.ofCardinality(1L);
        @Nonnull
        private final OptionalLong cardinalityOptional;

        private Cardinality(@Nonnull OptionalLong cardinalityOptional) {
            this.cardinalityOptional = cardinalityOptional;
        }

        public boolean isUnknown() {
            return this.cardinalityOptional.isEmpty();
        }

        public long getCardinality() {
            Verify.verify(this.cardinalityOptional.isPresent());
            return this.cardinalityOptional.getAsLong();
        }

        public Cardinality times(@Nonnull Cardinality otherCardinality) {
            if (this.isUnknown() || otherCardinality.isUnknown()) {
                return Cardinality.unknownCardinality();
            }
            return Cardinality.ofCardinality(this.getCardinality() * otherCardinality.getCardinality());
        }

        @Nonnull
        public Cardinality floor(long minimum) {
            if (this.cardinalityOptional.isEmpty() || this.cardinalityOptional.getAsLong() >= minimum) {
                return this;
            }
            return new Cardinality(OptionalLong.of(minimum));
        }

        public static Cardinality ofCardinality(long cardinality) {
            Preconditions.checkArgument(cardinality >= 0L);
            return new Cardinality(OptionalLong.of(cardinality));
        }

        public static Cardinality unknownCardinality() {
            return unknownCardinality;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Cardinality that = (Cardinality)object;
            return Objects.equals(this.cardinalityOptional, that.cardinalityOptional);
        }

        public int hashCode() {
            return this.cardinalityOptional.hashCode();
        }
    }
}

