/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.properties;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.cascades.ExpressionProperty;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.SimpleExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryCoveringIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithComparisons;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryScoreForRankPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTextIndexPlan;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class ComparisonsProperty
implements ExpressionProperty<Set<Comparisons.Comparison>> {
    private static final ComparisonsProperty COMPARISONS = new ComparisonsProperty();

    private ComparisonsProperty() {
    }

    @Nonnull
    public ComparisonsVisitor createVisitor() {
        return new ComparisonsVisitor();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Nonnull
    public Set<Comparisons.Comparison> evaluate(@Nonnull Reference reference) {
        return Objects.requireNonNull(reference.acceptVisitor(this.createVisitor()));
    }

    @Nonnull
    public Set<Comparisons.Comparison> evaluate(@Nonnull RelationalExpression expression) {
        return Objects.requireNonNull(expression.acceptVisitor(this.createVisitor()));
    }

    @Nonnull
    public static ComparisonsProperty comparisons() {
        return COMPARISONS;
    }

    public static class ComparisonsVisitor
    implements SimpleExpressionVisitor<Set<Comparisons.Comparison>> {
        @Override
        @Nonnull
        public Set<Comparisons.Comparison> evaluateAtExpression(@Nonnull RelationalExpression expression, @Nonnull List<Set<Comparisons.Comparison>> childResults) {
            RecordQueryPlanWithComparisons planWithComparisons;
            ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
            for (Set<Comparisons.Comparison> childResult : childResults) {
                if (childResult == null) continue;
                resultBuilder.addAll(childResult);
            }
            if (expression instanceof RecordQueryCoveringIndexPlan) {
                expression = ((RecordQueryCoveringIndexPlan)expression).getIndexPlan();
            }
            if (expression instanceof RecordQueryPlanWithComparisons && (planWithComparisons = (RecordQueryPlanWithComparisons)expression).hasComparisons()) {
                resultBuilder.addAll(planWithComparisons.getComparisons());
            }
            return resultBuilder.build();
        }

        @Override
        @Nonnull
        public Set<Comparisons.Comparison> visitRecordQueryIntersectionOnKeyExpressionPlan(@Nonnull RecordQueryIntersectionOnKeyExpressionPlan intersectionOnKeyExpressionPlan) {
            return this.visitRecordQueryIntersectionPlan(intersectionOnKeyExpressionPlan);
        }

        @Override
        @Nonnull
        public Set<Comparisons.Comparison> visitRecordQueryIntersectionOnValuesPlan(@Nonnull RecordQueryIntersectionOnValuesPlan intersectionOnValuesPlan) {
            return this.visitRecordQueryIntersectionPlan(intersectionOnValuesPlan);
        }

        @Nonnull
        private Set<Comparisons.Comparison> visitRecordQueryIntersectionPlan(@Nonnull RecordQueryIntersectionPlan intersectionPlan) {
            List comparisonsFromQuantifiers = this.visitQuantifiers(intersectionPlan);
            Verify.verify(!comparisonsFromQuantifiers.isEmpty());
            if (comparisonsFromQuantifiers.size() == 1) {
                return (Set)Iterables.getOnlyElement(comparisonsFromQuantifiers);
            }
            Iterator it = comparisonsFromQuantifiers.iterator();
            HashSet<Comparisons.Comparison> intersected = Sets.newHashSet((Iterable)it.next());
            while (it.hasNext()) {
                intersected.retainAll((Collection)it.next());
            }
            return intersected;
        }

        @Override
        @Nonnull
        public Set<Comparisons.Comparison> visitRecordQueryScoreForRankPlan(@Nonnull RecordQueryScoreForRankPlan scoreForRankPlan) {
            List<RecordQueryScoreForRankPlan.ScoreForRank> ranks = scoreForRankPlan.getRanks();
            return ranks.stream().flatMap(rank -> rank.getComparisons().stream()).collect(ImmutableSet.toImmutableSet());
        }

        @Override
        @Nonnull
        public Set<Comparisons.Comparison> visitRecordQueryTextIndexPlan(@Nonnull RecordQueryTextIndexPlan textIndexPlan) {
            ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
            ScanComparisons scanComparisons = textIndexPlan.getTextScan().getGroupingComparisons();
            if (scanComparisons != null) {
                ((ImmutableSet.Builder)resultBuilder.addAll(scanComparisons.getEqualityComparisons())).addAll(scanComparisons.getInequalityComparisons());
            }
            resultBuilder.add(textIndexPlan.getTextScan().getTextComparison());
            return resultBuilder.build();
        }

        @Override
        @Nonnull
        public Set<Comparisons.Comparison> evaluateAtRef(@Nonnull Reference ref, @Nonnull List<Set<Comparisons.Comparison>> memberResults) {
            ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
            for (Set<Comparisons.Comparison> memberResult : memberResults) {
                if (memberResult == null) continue;
                resultBuilder.addAll(memberResult);
            }
            return resultBuilder.build();
        }
    }
}

