/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.properties;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.combinatorics.CrossProduct;
import com.apple.foundationdb.record.query.combinatorics.EnumeratingIterable;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.bitmap.ComposedBitmapIndexQueryPlan;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.ExpressionProperty;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.TreeLike;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithComparisons;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithValue;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.FirstOrDefaultStreamingValue;
import com.apple.foundationdb.record.query.plan.cascades.values.FirstOrDefaultValue;
import com.apple.foundationdb.record.query.plan.cascades.values.MessageHelpers;
import com.apple.foundationdb.record.query.plan.cascades.values.QueriedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.StreamingValue;
import com.apple.foundationdb.record.query.plan.cascades.values.ThrowsValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.RegularTranslationMap;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryAggregateIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryComparatorPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryCoveringIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryDefaultOnEmptyPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryDeletePlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryExplodePlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFirstOrDefaultPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFlatMapPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInComparandJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInParameterJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInUnionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInUnionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInUnionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInValuesJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInsertPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryLoadByKeysPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryMapPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryMultiIntersectionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanVisitor;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithComparisonKeyValues;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithComparisons;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPredicatesFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryRangePlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryRecursiveDfsJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryRecursiveLevelUnionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryScanPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryScoreForRankPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQuerySelectorPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQuerySetPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryStreamingAggregationPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTableFunctionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTextIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTypeFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedDistinctPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedPrimaryKeyDistinctPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedUnionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUpdatePlan;
import com.apple.foundationdb.record.query.plan.plans.TempTableInsertPlan;
import com.apple.foundationdb.record.query.plan.plans.TempTableScanPlan;
import com.apple.foundationdb.record.query.plan.sorting.RecordQueryDamPlan;
import com.apple.foundationdb.record.query.plan.sorting.RecordQuerySortPlan;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

public class DerivationsProperty
implements ExpressionProperty<Derivations> {
    private static final DerivationsProperty DERIVATIONS = new DerivationsProperty();

    private DerivationsProperty() {
    }

    @Override
    @Nonnull
    public RelationalExpressionVisitor<Derivations> createVisitor() {
        return ExpressionProperty.toExpressionVisitor(new DerivationsVisitor());
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Nonnull
    public Derivations evaluate(@Nonnull Reference reference) {
        return this.evaluate(reference.getOnlyElementAsPlan());
    }

    @Nonnull
    public Derivations evaluate(@Nonnull RecordQueryPlan recordQueryPlan) {
        return this.createVisitor().visit(recordQueryPlan);
    }

    @Nonnull
    public static DerivationsProperty derivations() {
        return DERIVATIONS;
    }

    @API(value=API.Status.EXPERIMENTAL)
    public static class DerivationsVisitor
    implements RecordQueryPlanVisitor<Derivations> {
        @Override
        @Nonnull
        public Derivations visitUpdatePlan(@Nonnull RecordQueryUpdatePlan updatePlan) {
            Quantifier rangesOver = Iterables.getOnlyElement(updatePlan.getQuantifiers());
            Derivations childDerivations = this.derivationsFromQuantifier(rangesOver);
            List<Value> childResultValues = childDerivations.getResultValues();
            Value computationValue = updatePlan.getComputationValue();
            MessageHelpers.TransformationTrieNode transformationsTrie = updatePlan.getTransformationsTrie();
            ImmutableList.Builder resultValuesBuilder = ImmutableList.builder();
            ImmutableList.Builder localValuesBuilder = ImmutableList.builder();
            localValuesBuilder.addAll(childDerivations.getLocalValues());
            for (Value childResultValue : childResultValues) {
                if (transformationsTrie != null) {
                    RegularTranslationMap translationMap = TranslationMap.regularBuilder().when(rangesOver.getAlias()).then((sourceAlias, leafValue) -> childResultValue).build();
                    transformationsTrie.values().forEach(updateValue -> localValuesBuilder.add(updateValue.translateCorrelations(translationMap, true)));
                }
                RegularTranslationMap resultsTranslationMap = TranslationMap.regularBuilder().when(rangesOver.getAlias()).then((sourceAlias, leafValue) -> childResultValue).when(Quantifier.current()).then((sourceAlias, leafValue) -> new QueriedValue(leafValue.getResultType(), ImmutableList.of(updatePlan.getTargetRecordType()))).build();
                resultValuesBuilder.add(computationValue.translateCorrelations(resultsTranslationMap, true));
            }
            return new Derivations((List<Value>)((Object)resultValuesBuilder.build()), (List<Value>)((Object)localValuesBuilder.build()));
        }

        @Override
        @Nonnull
        public Derivations visitPredicatesFilterPlan(@Nonnull RecordQueryPredicatesFilterPlan predicatesFilterPlan) {
            Derivations childDerivations = this.derivationsFromSingleChild(predicatesFilterPlan);
            List<Value> childResultValues = childDerivations.getResultValues();
            ImmutableList.Builder localValuesBuilder = ImmutableList.builder();
            localValuesBuilder.addAll(childDerivations.getLocalValues());
            Quantifier rangesOver = Iterables.getOnlyElement(predicatesFilterPlan.getQuantifiers());
            for (QueryPredicate queryPredicate : predicatesFilterPlan.getPredicates()) {
                List<Value> valuesFromPredicate = queryPredicate.fold(DerivationsVisitor.valuesInPredicate(), DerivationsVisitor.combineValuesInChildren());
                for (Value childResultValue : childResultValues) {
                    RegularTranslationMap translationMap = TranslationMap.regularBuilder().when(rangesOver.getAlias()).then((sourceAlias, leafValue) -> childResultValue).build();
                    valuesFromPredicate.stream().map(value -> value.translateCorrelations(translationMap, true)).forEach(localValuesBuilder::add);
                }
            }
            return new Derivations(childDerivations.getResultValues(), (List<Value>)((Object)localValuesBuilder.build()));
        }

        @Nonnull
        private static TreeLike.NonnullBiFunction<List<Value>, Iterable<? extends List<Value>>, List<Value>> combineValuesInChildren() {
            return (values, childrenValuesLists) -> {
                ImmutableList.Builder valuesBuilder = ImmutableList.builder();
                valuesBuilder.addAll((Iterable)values);
                childrenValuesLists.forEach(valuesBuilder::addAll);
                return valuesBuilder.build();
            };
        }

        @Nonnull
        private static TreeLike.NonnullFunction<QueryPredicate, List<Value>> valuesInPredicate() {
            return p -> {
                ImmutableList.Builder valuesBuilder = ImmutableList.builder();
                if (p instanceof PredicateWithValue) {
                    valuesBuilder.add(Objects.requireNonNull(((PredicateWithValue)p).getValue()));
                }
                if (p instanceof PredicateWithComparisons) {
                    ((PredicateWithComparisons)((Object)p)).getComparisons().stream().map(Comparisons.Comparison::getValue).filter(Objects::nonNull).forEach(valuesBuilder::add);
                }
                return valuesBuilder.build();
            };
        }

        @Override
        @Nonnull
        public Derivations visitLoadByKeysPlan(@Nonnull RecordQueryLoadByKeysPlan element) {
            return this.derivationsFromSingleChild(element);
        }

        @Override
        @Nonnull
        public Derivations visitInValuesJoinPlan(@Nonnull RecordQueryInValuesJoinPlan inValuesJoinPlan) {
            return this.visitInJoinPlan(inValuesJoinPlan);
        }

        @Override
        @Nonnull
        public Derivations visitInComparandJoinPlan(@Nonnull RecordQueryInComparandJoinPlan inComparandJoinPlan) {
            return this.visitInJoinPlan(inComparandJoinPlan);
        }

        @Override
        @Nonnull
        public Derivations visitAggregateIndexPlan(@Nonnull RecordQueryAggregateIndexPlan aggregateIndexPlan) {
            List<Value> localValues = this.localValuesForComparisons(aggregateIndexPlan.getComparisons());
            return new Derivations(ImmutableList.of(), localValues);
        }

        @Override
        @Nonnull
        public Derivations visitCoveringIndexPlan(@Nonnull RecordQueryCoveringIndexPlan coveringIndexPlan) {
            return (Derivations)this.visit(coveringIndexPlan.getIndexPlan());
        }

        @Override
        @Nonnull
        public Derivations visitDeletePlan(@Nonnull RecordQueryDeletePlan deletePlan) {
            return this.derivationsFromSingleChild(deletePlan);
        }

        @Override
        @Nonnull
        public Derivations visitIntersectionOnKeyExpressionPlan(@Nonnull RecordQueryIntersectionOnKeyExpressionPlan intersectionPlan) {
            throw new RecordCoreException("unsupported plan operator", new Object[0]);
        }

        @Override
        @Nonnull
        public Derivations visitMapPlan(@Nonnull RecordQueryMapPlan mapPlan) {
            Quantifier rangesOver = Iterables.getOnlyElement(mapPlan.getQuantifiers());
            Derivations childDerivations = this.derivationsFromQuantifier(rangesOver);
            List<Value> childResultValues = childDerivations.getResultValues();
            Value resultValue = mapPlan.getResultValue();
            ImmutableList.Builder resultValuesBuilder = ImmutableList.builder();
            ImmutableList.Builder localValuesBuilder = ImmutableList.builder();
            localValuesBuilder.addAll(childDerivations.getLocalValues());
            for (Value childResultValue : childResultValues) {
                RegularTranslationMap resultsTranslationMap = TranslationMap.regularBuilder().when(rangesOver.getAlias()).then((sourceAlias, leafValue) -> childResultValue).build();
                resultValuesBuilder.add(resultValue.translateCorrelations(resultsTranslationMap, true));
            }
            return new Derivations((List<Value>)((Object)resultValuesBuilder.build()), (List<Value>)((Object)localValuesBuilder.build()));
        }

        @Override
        @Nonnull
        public Derivations visitComparatorPlan(@Nonnull RecordQueryComparatorPlan element) {
            throw new RecordCoreException("unsupported plan operator", new Object[0]);
        }

        @Override
        @Nonnull
        public Derivations visitUnorderedDistinctPlan(@Nonnull RecordQueryUnorderedDistinctPlan unorderedDistinctPlan) {
            return this.derivationsFromSingleChild(unorderedDistinctPlan);
        }

        @Override
        @Nonnull
        public Derivations visitSelectorPlan(@Nonnull RecordQuerySelectorPlan element) {
            throw new RecordCoreException("unsupported plan operator", new Object[0]);
        }

        @Override
        @Nonnull
        public Derivations visitRangePlan(@Nonnull RecordQueryRangePlan rangePlan) {
            ImmutableList<Value> values = ImmutableList.of(rangePlan.getResultValue());
            return new Derivations(values, values);
        }

        @Override
        @Nonnull
        public Derivations visitTempTableScanPlan(@Nonnull TempTableScanPlan tempTableScanPlan) {
            return new Derivations(ImmutableList.of(tempTableScanPlan.getResultValue()), ImmutableList.of());
        }

        @Override
        @Nonnull
        public Derivations visitExplodePlan(@Nonnull RecordQueryExplodePlan explodePlan) {
            Value collectionValue = explodePlan.getCollectionValue();
            Type resultType = collectionValue.getResultType();
            Verify.verify(resultType.isArray());
            Type elementType = Objects.requireNonNull(((Type.Array)resultType).getElementType());
            ImmutableList<Value> values = ImmutableList.of(new FirstOrDefaultValue(collectionValue, new ThrowsValue(elementType)));
            return new Derivations(values, values);
        }

        @Override
        @Nonnull
        public Derivations visitInsertPlan(@Nonnull RecordQueryInsertPlan insertPlan) {
            Quantifier rangesOver = Iterables.getOnlyElement(insertPlan.getQuantifiers());
            Derivations childDerivations = this.derivationsFromQuantifier(rangesOver);
            List<Value> childResultValues = childDerivations.getResultValues();
            Value computationValue = insertPlan.getComputationValue();
            ImmutableList.Builder resultValuesBuilder = ImmutableList.builder();
            ImmutableList.Builder localValuesBuilder = ImmutableList.builder();
            localValuesBuilder.addAll(childDerivations.getLocalValues());
            for (Value childResultValue : childResultValues) {
                RegularTranslationMap resultsTranslationMap = TranslationMap.regularBuilder().when(rangesOver.getAlias()).then((sourceAlias, leafValue) -> childResultValue).when(Quantifier.current()).then((sourceAlias, leafValue) -> new QueriedValue(leafValue.getResultType(), ImmutableList.of(insertPlan.getTargetRecordType()))).build();
                resultValuesBuilder.add(computationValue.translateCorrelations(resultsTranslationMap, true));
            }
            return new Derivations((List<Value>)((Object)resultValuesBuilder.build()), (List<Value>)((Object)localValuesBuilder.build()));
        }

        @Override
        @Nonnull
        public Derivations visitTableFunctionPlan(@Nonnull RecordQueryTableFunctionPlan tableFunctionPlan) {
            StreamingValue streamingValue = tableFunctionPlan.getValue();
            Type elementType = streamingValue.getResultType();
            ImmutableList<Value> values = ImmutableList.of(new FirstOrDefaultStreamingValue(streamingValue, new ThrowsValue(elementType)));
            return new Derivations(values, values);
        }

        @Override
        @Nonnull
        public Derivations visitTempTableInsertPlan(@Nonnull TempTableInsertPlan tempTableInsertPlan) {
            return this.derivationsFromSingleChild(tempTableInsertPlan);
        }

        @Override
        @Nonnull
        public Derivations visitIntersectionOnValuesPlan(@Nonnull RecordQueryIntersectionOnValuesPlan intersectionOnValuePlan) {
            return this.visitSetPlan(intersectionOnValuePlan);
        }

        @Override
        @Nonnull
        public Derivations visitScoreForRankPlan(@Nonnull RecordQueryScoreForRankPlan element) {
            throw new RecordCoreException("unsupported plan operator", new Object[0]);
        }

        @Override
        @Nonnull
        public Derivations visitIndexPlan(@Nonnull RecordQueryIndexPlan indexPlan) {
            MatchCandidate matchCandidate = indexPlan.getMatchCandidate();
            return this.visitPlanWithComparisons(indexPlan, matchCandidate.getQueriedRecordTypeNames());
        }

        @Override
        @Nonnull
        public Derivations visitRecursiveLevelUnionPlan(@Nonnull RecordQueryRecursiveLevelUnionPlan recursiveLevelUnionPlan) {
            return Derivations.EMPTY;
        }

        @Nonnull
        private Derivations visitPlanWithComparisons(@Nonnull RecordQueryPlanWithComparisons planWithComparisons, @Nonnull Iterable<String> recordTypeNames) {
            List<Value> comparisonValues = this.localValuesForComparisons(planWithComparisons.getComparisons());
            Value resultValueFromPlan = planWithComparisons.getResultValue();
            QueriedValue resultValue = new QueriedValue(resultValueFromPlan.getResultType(), recordTypeNames);
            return new Derivations(ImmutableList.of(resultValue), comparisonValues);
        }

        @Nonnull
        private List<Value> localValuesForComparisons(@Nonnull Iterable<Comparisons.Comparison> comparisons) {
            return Streams.stream(comparisons).map(Comparisons.Comparison::getValue).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
        }

        @Override
        @Nonnull
        public Derivations visitFirstOrDefaultPlan(@Nonnull RecordQueryFirstOrDefaultPlan firstOrDefaultPlan) {
            Quantifier rangesOver = Iterables.getOnlyElement(firstOrDefaultPlan.getQuantifiers());
            Derivations childDerivations = this.derivationsFromSingleChild(firstOrDefaultPlan);
            List<Value> childResultValues = childDerivations.getResultValues();
            Value onEmptyResultValue = firstOrDefaultPlan.getOnEmptyResultValue();
            ImmutableList.Builder localValuesBuilder = ImmutableList.builder();
            localValuesBuilder.addAll(childDerivations.getLocalValues());
            for (Value childResultValue : childResultValues) {
                RegularTranslationMap resultsTranslationMap = TranslationMap.regularBuilder().when(rangesOver.getAlias()).then((sourceAlias, leafValue) -> childResultValue).build();
                localValuesBuilder.add(onEmptyResultValue.translateCorrelations(resultsTranslationMap, true));
            }
            return new Derivations(childDerivations.getResultValues(), (List<Value>)((Object)localValuesBuilder.build()));
        }

        @Override
        @Nonnull
        public Derivations visitDefaultOnEmptyPlan(@Nonnull RecordQueryDefaultOnEmptyPlan defaultOnEmptyPlan) {
            Quantifier rangesOver = Iterables.getOnlyElement(defaultOnEmptyPlan.getQuantifiers());
            Derivations childDerivations = this.derivationsFromSingleChild(defaultOnEmptyPlan);
            List<Value> childResultValues = childDerivations.getResultValues();
            Value onEmptyResultValue = defaultOnEmptyPlan.getOnEmptyResultValue();
            ImmutableList.Builder localValuesBuilder = ImmutableList.builder();
            localValuesBuilder.addAll(childDerivations.getLocalValues());
            for (Value childResultValue : childResultValues) {
                RegularTranslationMap resultsTranslationMap = TranslationMap.regularBuilder().when(rangesOver.getAlias()).then((sourceAlias, leafValue) -> childResultValue).build();
                localValuesBuilder.add(onEmptyResultValue.translateCorrelations(resultsTranslationMap, true));
            }
            return new Derivations(childDerivations.getResultValues(), (List<Value>)((Object)localValuesBuilder.build()));
        }

        @Nonnull
        public Derivations visitInJoinPlan(@Nonnull RecordQueryInJoinPlan inJoinPlan) {
            CorrelationIdentifier outerAlias = inJoinPlan.getInAlias();
            Quantifier.Physical innerQuantifier = inJoinPlan.getInner();
            Derivations innerDerivations = this.derivationsFromQuantifier(innerQuantifier);
            ImmutableList.Builder innerDecorrelatedLocalValuesBuilder = ImmutableList.builder();
            for (Value innerValue : innerDerivations.getLocalValues()) {
                if (innerValue.isCorrelatedTo(outerAlias)) {
                    RegularTranslationMap translationMap = TranslationMap.regularBuilder().when(outerAlias).then((sourceAlias, leafValue) -> new QueriedValue(leafValue.getResultType())).build();
                    innerDecorrelatedLocalValuesBuilder.add(innerValue.translateCorrelations(translationMap, true));
                    continue;
                }
                innerDecorrelatedLocalValuesBuilder.add(innerValue);
            }
            ImmutableList.Builder innerDecorrelatedResultValuesBuilder = ImmutableList.builder();
            for (Value innerValue : innerDerivations.getResultValues()) {
                if (innerValue.isCorrelatedTo(outerAlias)) {
                    RegularTranslationMap translationMap = TranslationMap.regularBuilder().when(outerAlias).then((sourceAlias, leafValue) -> new QueriedValue(leafValue.getResultType())).build();
                    innerDecorrelatedResultValuesBuilder.add(innerValue.translateCorrelations(translationMap, true));
                    continue;
                }
                innerDecorrelatedResultValuesBuilder.add(innerValue);
            }
            return new Derivations((List<Value>)((Object)innerDecorrelatedResultValuesBuilder.build()), (List<Value>)((Object)innerDecorrelatedLocalValuesBuilder.build()));
        }

        @Override
        @Nonnull
        public Derivations visitFilterPlan(@Nonnull RecordQueryFilterPlan filterPlan) {
            throw new RecordCoreException("unsupported plan operator", new Object[0]);
        }

        @Override
        @Nonnull
        public Derivations visitUnorderedPrimaryKeyDistinctPlan(@Nonnull RecordQueryUnorderedPrimaryKeyDistinctPlan unorderedPrimaryKeyDistinctPlan) {
            return this.derivationsFromSingleChild(unorderedPrimaryKeyDistinctPlan);
        }

        @Override
        @Nonnull
        public Derivations visitUnionOnKeyExpressionPlan(@Nonnull RecordQueryUnionOnKeyExpressionPlan unionOnKeyExpressionPlan) {
            throw new RecordCoreException("unsupported plan operator", new Object[0]);
        }

        @Override
        @Nonnull
        public Derivations visitTextIndexPlan(@Nonnull RecordQueryTextIndexPlan element) {
            throw new RecordCoreException("unsupported plan operator", new Object[0]);
        }

        @Override
        @Nonnull
        public Derivations visitFetchFromPartialRecordPlan(@Nonnull RecordQueryFetchFromPartialRecordPlan element) {
            return this.derivationsFromSingleChild(element);
        }

        @Override
        @Nonnull
        public Derivations visitTypeFilterPlan(@Nonnull RecordQueryTypeFilterPlan typeFilterPlan) {
            Derivations childDerivations = this.derivationsFromSingleChild(typeFilterPlan);
            List<Value> childResultValues = childDerivations.getResultValues();
            ImmutableList.Builder resultValuesBuilder = ImmutableList.builder();
            ImmutableSet<String> filteredRecordTypeNames = ImmutableSet.copyOf(typeFilterPlan.getRecordTypes());
            for (Value childResultValue : childResultValues) {
                Optional replacedChildResultValueOptional = childResultValue.replaceLeavesMaybe(value -> {
                    if (value instanceof QueriedValue) {
                        QueriedValue queriedValue = (QueriedValue)value;
                        List<String> childRecordTypeNames = queriedValue.getRecordTypeNames();
                        if (childRecordTypeNames == null) {
                            return value;
                        }
                        ImmutableList<String> intersectedRecordTypeNames = childRecordTypeNames.stream().filter(filteredRecordTypeNames::contains).collect(ImmutableList.toImmutableList());
                        return new QueriedValue(typeFilterPlan.getResultValue().getResultType(), intersectedRecordTypeNames);
                    }
                    return value;
                });
                Verify.verify(replacedChildResultValueOptional.isPresent());
                resultValuesBuilder.add((Value)replacedChildResultValueOptional.get());
            }
            return new Derivations((List<Value>)((Object)resultValuesBuilder.build()), childDerivations.getLocalValues());
        }

        @Override
        @Nonnull
        public Derivations visitInUnionOnKeyExpressionPlan(@Nonnull RecordQueryInUnionOnKeyExpressionPlan inUnionOnKeyExpressionPlan) {
            throw new RecordCoreException("unsupported plan operator", new Object[0]);
        }

        @Override
        @Nonnull
        public Derivations visitMultiIntersectionOnValuesPlan(@Nonnull RecordQueryMultiIntersectionOnValuesPlan multiIntersectionOnValuesPlan) {
            Value intersectionResultValue = multiIntersectionOnValuesPlan.getResultValue();
            ImmutableList.Builder resultValuesBuilder = ImmutableList.builder();
            ImmutableList.Builder localValuesBuilder = ImmutableList.builder();
            ImmutableList.Builder resultDerivationsBuilder = ImmutableList.builder();
            List<? extends Quantifier> quantifiers = multiIntersectionOnValuesPlan.getQuantifiers();
            for (Quantifier quantifier : quantifiers) {
                Derivations derivations = this.derivationsFromQuantifier(quantifier);
                resultDerivationsBuilder.add(derivations.getResultValues());
                localValuesBuilder.addAll(derivations.getLocalValues());
            }
            EnumeratingIterable crossProductIterable = CrossProduct.crossProduct(resultDerivationsBuilder.build());
            for (List list : crossProductIterable) {
                RegularTranslationMap.Builder translationMapBuilder = RegularTranslationMap.builder();
                for (int i = 0; i < quantifiers.size(); ++i) {
                    Quantifier quantifier = quantifiers.get(i);
                    Value derivationResultValue = (Value)list.get(i);
                    translationMapBuilder.when(quantifier.getAlias()).then((alias, leafValue) -> derivationResultValue);
                }
                resultValuesBuilder.add(intersectionResultValue.translateCorrelations(translationMapBuilder.build()));
            }
            ImmutableCollection immutableCollection = resultValuesBuilder.build();
            localValuesBuilder.addAll(DerivationsVisitor.derivationsFromComparisonKeyValues(multiIntersectionOnValuesPlan, (ImmutableList<Value>)immutableCollection));
            return new Derivations((List<Value>)((Object)immutableCollection), (List<Value>)((Object)localValuesBuilder.build()));
        }

        @Override
        @Nonnull
        public Derivations visitInParameterJoinPlan(@Nonnull RecordQueryInParameterJoinPlan inParameterJoinPlan) {
            return this.visitInJoinPlan(inParameterJoinPlan);
        }

        @Override
        @Nonnull
        public Derivations visitFlatMapPlan(@Nonnull RecordQueryFlatMapPlan flatMapPlan) {
            Quantifier.Physical outerQuantifier = flatMapPlan.getOuterQuantifier();
            Quantifier.Physical innerQuantifier = flatMapPlan.getInnerQuantifier();
            Derivations outerDerivations = this.derivationsFromQuantifier(outerQuantifier);
            Derivations innerDerivations = this.derivationsFromQuantifier(innerQuantifier);
            ImmutableList.Builder innerDecorrelatedLocalValuesBuilder = ImmutableList.builder();
            for (Value innerValue : innerDerivations.getLocalValues()) {
                if (innerValue.isCorrelatedTo(outerQuantifier.getAlias())) {
                    for (Value outerResultValue : outerDerivations.getResultValues()) {
                        RegularTranslationMap translationMap = TranslationMap.regularBuilder().when(outerQuantifier.getAlias()).then((sourceAlias, leafValue) -> outerResultValue).build();
                        innerDecorrelatedLocalValuesBuilder.add(innerValue.translateCorrelations(translationMap, true));
                    }
                    continue;
                }
                innerDecorrelatedLocalValuesBuilder.add(innerValue);
            }
            Value resultValue = flatMapPlan.getResultValue();
            ImmutableList.Builder decorrelatedResultValuesBuilder = ImmutableList.builder();
            for (Value outerResultValue : outerDerivations.getResultValues()) {
                for (Value innerResultValue : innerDerivations.getResultValues()) {
                    RegularTranslationMap translationMap = TranslationMap.regularBuilder().when(outerQuantifier.getAlias()).then((sourceAlias, leafValue) -> outerResultValue).build();
                    Value innerDecorrelatedValue = innerResultValue.translateCorrelations(translationMap, true);
                    RegularTranslationMap resultsTranslationMap = TranslationMap.regularBuilder().when(outerQuantifier.getAlias()).then((sourceAlias, leafValue) -> outerResultValue).when(innerQuantifier.getAlias()).then((sourceAlias, leafValue) -> innerDecorrelatedValue).build();
                    Value decorrelatedResultsValue = resultValue.translateCorrelations(resultsTranslationMap, true);
                    decorrelatedResultValuesBuilder.add(decorrelatedResultsValue);
                    if (resultValue.isCorrelatedTo(innerQuantifier.getAlias())) continue;
                    break;
                }
                if (resultValue.isCorrelatedTo(outerQuantifier.getAlias())) continue;
                break;
            }
            ImmutableCollection decorrelatedResultValues = decorrelatedResultValuesBuilder.build();
            return new Derivations((List<Value>)((Object)decorrelatedResultValues), (List<Value>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(outerDerivations.getLocalValues())).addAll((Iterable)innerDecorrelatedLocalValuesBuilder.build())).addAll((Iterable)decorrelatedResultValues)).build()));
        }

        @Override
        @Nonnull
        public Derivations visitStreamingAggregationPlan(@Nonnull RecordQueryStreamingAggregationPlan streamingAggregationPlan) {
            Value resultValue = streamingAggregationPlan.getResultValue();
            RegularTranslationMap.Builder resultTranslationMap = TranslationMap.regularBuilder();
            Value groupingValue = streamingAggregationPlan.getGroupingValue();
            if (groupingValue != null) {
                resultTranslationMap.when(streamingAggregationPlan.getGroupingKeyAlias()).then((sourceAlias, leafValue) -> streamingAggregationPlan.getGroupingValue());
            }
            resultTranslationMap.when(streamingAggregationPlan.getAggregateAlias()).then((sourceAlias, leafValue) -> streamingAggregationPlan.getAggregateValue());
            Value expandedResultValue = resultValue.translateCorrelations(resultTranslationMap.build(), true);
            Derivations childDerivations = this.derivationsFromSingleChild(streamingAggregationPlan);
            Quantifier.Physical innerQuantifier = streamingAggregationPlan.getInner();
            ImmutableList.Builder decorrelatedResultValuesBuilder = ImmutableList.builder();
            for (Value childResultValue : childDerivations.getResultValues()) {
                RegularTranslationMap translationMap = TranslationMap.regularBuilder().when(innerQuantifier.getAlias()).then((sourceAlias, leafValue) -> childResultValue).build();
                Value decorrelatedExpandedResultValue = expandedResultValue.translateCorrelations(translationMap, true);
                decorrelatedResultValuesBuilder.add(decorrelatedExpandedResultValue);
            }
            ImmutableCollection decorrelatedResultValues = decorrelatedResultValuesBuilder.build();
            return new Derivations((List<Value>)((Object)decorrelatedResultValues), (List<Value>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll((Iterable)decorrelatedResultValues)).addAll(childDerivations.getLocalValues())).build()));
        }

        @Override
        @Nonnull
        public Derivations visitUnionOnValuesPlan(@Nonnull RecordQueryUnionOnValuesPlan unionOnValuesPlan) {
            return this.visitSetPlan(unionOnValuesPlan);
        }

        @Nonnull
        private Derivations visitSetPlan(@Nonnull RecordQuerySetPlan setPlan) {
            Verify.verify(!(setPlan instanceof RecordQueryInUnionPlan));
            ImmutableList.Builder resultValuesBuilder = ImmutableList.builder();
            ImmutableList.Builder localValuesBuilder = ImmutableList.builder();
            for (Quantifier quantifier : setPlan.getQuantifiers()) {
                Derivations childDerivations = this.derivationsFromQuantifier(quantifier);
                resultValuesBuilder.addAll(childDerivations.getResultValues());
                localValuesBuilder.addAll(childDerivations.getLocalValues());
            }
            ImmutableCollection resultValues = resultValuesBuilder.build();
            localValuesBuilder.addAll(DerivationsVisitor.derivationsFromComparisonKeyValues(setPlan, (ImmutableList<Value>)resultValues));
            return new Derivations((List<Value>)((Object)resultValues), (List<Value>)((Object)localValuesBuilder.build()));
        }

        private static List<Value> derivationsFromComparisonKeyValues(@Nonnull RecordQuerySetPlan setPlan, @Nonnull ImmutableList<Value> resultValues) {
            ImmutableList.Builder resultBuilder = ImmutableList.builder();
            if (setPlan instanceof RecordQueryPlanWithComparisonKeyValues) {
                for (Value value : ((RecordQueryPlanWithComparisonKeyValues)((Object)setPlan)).getComparisonKeyValues()) {
                    for (Value resultValue : resultValues) {
                        RegularTranslationMap translationMap = TranslationMap.regularBuilder().when(Quantifier.current()).then((sourceAlias, leafValue) -> resultValue).build();
                        resultBuilder.add(value.translateCorrelations(translationMap, true));
                    }
                }
            }
            return resultBuilder.build();
        }

        @Override
        @Nonnull
        public Derivations visitUnorderedUnionPlan(@Nonnull RecordQueryUnorderedUnionPlan unorderedUnionPlan) {
            return this.visitSetPlan(unorderedUnionPlan);
        }

        @Override
        @Nonnull
        public Derivations visitScanPlan(@Nonnull RecordQueryScanPlan scanPlan) {
            return this.visitPlanWithComparisons(scanPlan, (Iterable<String>)Objects.requireNonNull(scanPlan.getRecordTypes()));
        }

        @Override
        @Nonnull
        public Derivations visitInUnionOnValuesPlan(@Nonnull RecordQueryInUnionOnValuesPlan inUnionOnValuePlan) {
            ImmutableList<CorrelationIdentifier> outerAliases = inUnionOnValuePlan.getInSources().stream().map(inUnionOnValuePlan::getInAlias).collect(ImmutableList.toImmutableList());
            Quantifier.Physical innerQuantifier = inUnionOnValuePlan.getInner();
            Derivations innerDerivations = this.derivationsFromQuantifier(innerQuantifier);
            ImmutableList.Builder innerDecorrelatedLocalValuesBuilder = ImmutableList.builder();
            for (Value value : innerDerivations.getLocalValues()) {
                Set<CorrelationIdentifier> innerCorrelatedTo = value.getCorrelatedTo();
                if (outerAliases.stream().anyMatch(innerCorrelatedTo::contains)) {
                    RegularTranslationMap regularTranslationMap = TranslationMap.regularBuilder().whenAny(outerAliases).then((sourceAlias, leafValue) -> new QueriedValue(leafValue.getResultType())).build();
                    innerDecorrelatedLocalValuesBuilder.add(value.translateCorrelations(regularTranslationMap, true));
                    continue;
                }
                innerDecorrelatedLocalValuesBuilder.add(value);
            }
            ImmutableList.Builder innerDecorrelatedResultValuesBuilder = ImmutableList.builder();
            for (Value innerValue : innerDerivations.getResultValues()) {
                Set<CorrelationIdentifier> set = innerValue.getCorrelatedTo();
                if (outerAliases.stream().anyMatch(set::contains)) {
                    RegularTranslationMap translationMap = TranslationMap.regularBuilder().whenAny(outerAliases).then((sourceAlias, leafValue) -> new QueriedValue(leafValue.getResultType())).build();
                    innerDecorrelatedResultValuesBuilder.add(innerValue.translateCorrelations(translationMap, true));
                    continue;
                }
                innerDecorrelatedResultValuesBuilder.add(innerValue);
            }
            ImmutableCollection immutableCollection = innerDecorrelatedResultValuesBuilder.build();
            for (Value value : inUnionOnValuePlan.getComparisonKeyValues()) {
                for (Value resultValue : immutableCollection) {
                    RegularTranslationMap translationMap = TranslationMap.regularBuilder().when(Quantifier.current()).then((sourceAlias, leafValue) -> resultValue).build();
                    innerDecorrelatedLocalValuesBuilder.add(value.translateCorrelations(translationMap, true));
                }
            }
            return new Derivations((List<Value>)((Object)immutableCollection), (List<Value>)((Object)innerDecorrelatedLocalValuesBuilder.build()));
        }

        @Override
        @Nonnull
        public Derivations visitComposedBitmapIndexQueryPlan(@Nonnull ComposedBitmapIndexQueryPlan element) {
            throw new RecordCoreException("unsupported plan operator", new Object[0]);
        }

        @Override
        @Nonnull
        public Derivations visitDamPlan(@Nonnull RecordQueryDamPlan damPlan) {
            return this.derivationsFromSingleChild(damPlan);
        }

        @Override
        @Nonnull
        public Derivations visitSortPlan(@Nonnull RecordQuerySortPlan sortPlan) {
            return this.derivationsFromSingleChild(sortPlan);
        }

        @Override
        @Nonnull
        public Derivations visitRecursiveDfsJoinPlan(@Nonnull RecordQueryRecursiveDfsJoinPlan recursiveDfsJoinPlan) {
            return Derivations.EMPTY;
        }

        @Override
        @Nonnull
        public Derivations visitDefault(@Nonnull RecordQueryPlan element) {
            throw new RecordCoreException("unsupported plan operator", new Object[0]);
        }

        @Nonnull
        private Derivations derivationsFromSingleChild(@Nonnull RelationalExpression expression) {
            List<? extends Quantifier> quantifiers = expression.getQuantifiers();
            if (quantifiers.size() == 1) {
                return this.derivationsFromQuantifier(Iterables.getOnlyElement(quantifiers));
            }
            throw new RecordCoreException("cannot derive derivations for more than one quantifier", new Object[0]);
        }

        @Nonnull
        private Derivations derivationsFromQuantifier(@Nonnull Quantifier quantifier) {
            return this.evaluateForReference(quantifier.getRangesOver());
        }

        @Nonnull
        private Derivations evaluateForReference(@Nonnull Reference reference) {
            RelationalExpression expression = reference.get();
            return (Derivations)this.visit((RecordQueryPlan)expression);
        }
    }

    @SpotBugsSuppressWarnings(value={"SING_SINGLETON_HAS_NONPRIVATE_CONSTRUCTOR"}, justification="False positive as this is not a singleton class")
    public static class Derivations {
        private static final Derivations EMPTY = new Derivations(ImmutableList.of(), ImmutableList.of());
        @Nonnull
        private final List<Value> resultValues;
        @Nonnull
        private final List<Value> localValues;

        public Derivations(List<Value> resultValues, List<Value> localValues) {
            this.resultValues = ImmutableList.copyOf(resultValues);
            this.localValues = ImmutableList.copyOf(localValues);
        }

        @Nonnull
        public List<Value> getResultValues() {
            return this.resultValues;
        }

        @Nonnull
        public List<Value> getLocalValues() {
            return this.localValues;
        }

        @Nonnull
        public List<Value> simplifyLocalValues() {
            ImmutableList.Builder simplifiedLocalValuesBuilder = ImmutableList.builder();
            for (Value localValue : this.getLocalValues()) {
                AliasMap aliasMap = AliasMap.emptyMap();
                simplifiedLocalValuesBuilder.add(localValue.simplify(EvaluationContext.empty(), aliasMap, ImmutableSet.of()));
            }
            return simplifiedLocalValuesBuilder.build();
        }

        @Nonnull
        public static Derivations empty() {
            return EMPTY;
        }
    }
}

