/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.properties;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.plan.bitmap.ComposedBitmapIndexQueryPlan;
import com.apple.foundationdb.record.query.plan.cascades.ExpressionProperty;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryAggregateIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryComparatorPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryCoveringIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryDefaultOnEmptyPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryDeletePlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryExplodePlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFirstOrDefaultPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFlatMapPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInComparandJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInParameterJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInUnionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInUnionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInValuesJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInsertPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryLoadByKeysPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryMapPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryMultiIntersectionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanVisitor;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithIndex;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPredicatesFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryRangePlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryRecursiveDfsJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryRecursiveLevelUnionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryScanPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryScoreForRankPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQuerySelectorPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryStreamingAggregationPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTableFunctionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTextIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTypeFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedDistinctPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedPrimaryKeyDistinctPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedUnionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUpdatePlan;
import com.apple.foundationdb.record.query.plan.plans.TempTableInsertPlan;
import com.apple.foundationdb.record.query.plan.plans.TempTableScanPlan;
import com.apple.foundationdb.record.query.plan.sorting.RecordQueryDamPlan;
import com.apple.foundationdb.record.query.plan.sorting.RecordQuerySortPlan;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public class DistinctRecordsProperty
implements ExpressionProperty<Boolean> {
    private static final DistinctRecordsProperty DISTINCT_RECORDS = new DistinctRecordsProperty();

    private DistinctRecordsProperty() {
    }

    @Override
    @Nonnull
    public RelationalExpressionVisitor<Boolean> createVisitor() {
        return ExpressionProperty.toExpressionVisitor(new DistinctRecordsVisitor());
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public boolean evaluate(@Nonnull Reference reference) {
        return this.evaluate(reference.getOnlyElementAsPlan());
    }

    public boolean evaluate(@Nonnull RecordQueryPlan recordQueryPlan) {
        return this.createVisitor().visit(recordQueryPlan);
    }

    @Nonnull
    public static DistinctRecordsProperty distinctRecords() {
        return DISTINCT_RECORDS;
    }

    @API(value=API.Status.EXPERIMENTAL)
    public static class DistinctRecordsVisitor
    implements RecordQueryPlanVisitor<Boolean> {
        @Override
        @Nonnull
        public Boolean visitUpdatePlan(@Nonnull RecordQueryUpdatePlan updatePlan) {
            return this.distinctRecordsFromSingleChild(updatePlan);
        }

        @Override
        @Nonnull
        public Boolean visitPredicatesFilterPlan(@Nonnull RecordQueryPredicatesFilterPlan predicatesFilterPlan) {
            return this.distinctRecordsFromSingleChild(predicatesFilterPlan);
        }

        @Override
        @Nonnull
        public Boolean visitLoadByKeysPlan(@Nonnull RecordQueryLoadByKeysPlan element) {
            return true;
        }

        @Override
        @Nonnull
        public Boolean visitInValuesJoinPlan(@Nonnull RecordQueryInValuesJoinPlan inValuesJoinPlan) {
            return this.visitInJoinPlan(inValuesJoinPlan);
        }

        @Override
        @Nonnull
        public Boolean visitInComparandJoinPlan(@Nonnull RecordQueryInComparandJoinPlan inComparandJoinPlan) {
            return this.visitInJoinPlan(inComparandJoinPlan);
        }

        @Override
        @Nonnull
        public Boolean visitAggregateIndexPlan(@Nonnull RecordQueryAggregateIndexPlan aggregateIndexPlan) {
            return true;
        }

        @Override
        @Nonnull
        public Boolean visitCoveringIndexPlan(@Nonnull RecordQueryCoveringIndexPlan coveringIndexPlan) {
            RecordQueryPlanWithIndex indexPlan = coveringIndexPlan.getIndexPlan();
            if (!(indexPlan instanceof RecordQueryIndexPlan)) {
                return false;
            }
            return this.visitIndexPlan((RecordQueryIndexPlan)indexPlan);
        }

        @Override
        @Nonnull
        public Boolean visitDeletePlan(@Nonnull RecordQueryDeletePlan deletePlan) {
            return this.distinctRecordsFromSingleChild(deletePlan);
        }

        @Override
        @Nonnull
        public Boolean visitIntersectionOnKeyExpressionPlan(@Nonnull RecordQueryIntersectionOnKeyExpressionPlan element) {
            return true;
        }

        @Override
        @Nonnull
        public Boolean visitMapPlan(@Nonnull RecordQueryMapPlan mapPlan) {
            Value resultValue = mapPlan.getResultValue();
            if (resultValue instanceof QuantifiedObjectValue && ((QuantifiedObjectValue)resultValue).getAlias().equals(mapPlan.getInner().getAlias())) {
                return this.distinctRecordsFromSingleChild(mapPlan);
            }
            return false;
        }

        @Override
        @Nonnull
        public Boolean visitComparatorPlan(@Nonnull RecordQueryComparatorPlan comparatorPlan) {
            return this.distinctRecordsFromChildren(comparatorPlan).stream().allMatch(d -> d);
        }

        @Override
        @Nonnull
        public Boolean visitUnorderedDistinctPlan(@Nonnull RecordQueryUnorderedDistinctPlan element) {
            return true;
        }

        @Override
        @Nonnull
        public Boolean visitSelectorPlan(@Nonnull RecordQuerySelectorPlan selectorPlan) {
            return this.distinctRecordsFromChildren(selectorPlan).stream().allMatch(d -> d);
        }

        @Override
        @Nonnull
        public Boolean visitRangePlan(@Nonnull RecordQueryRangePlan element) {
            return true;
        }

        @Override
        @Nonnull
        public Boolean visitTempTableScanPlan(@Nonnull TempTableScanPlan element) {
            return false;
        }

        @Override
        @Nonnull
        public Boolean visitExplodePlan(@Nonnull RecordQueryExplodePlan element) {
            return false;
        }

        @Override
        @Nonnull
        public Boolean visitInsertPlan(@Nonnull RecordQueryInsertPlan insertPlan) {
            return this.distinctRecordsFromSingleChild(insertPlan);
        }

        @Override
        @Nonnull
        public Boolean visitTableFunctionPlan(@Nonnull RecordQueryTableFunctionPlan element) {
            return false;
        }

        @Override
        @Nonnull
        public Boolean visitTempTableInsertPlan(@Nonnull TempTableInsertPlan tempTableInsertPlan) {
            return this.distinctRecordsFromSingleChild(tempTableInsertPlan);
        }

        @Override
        @Nonnull
        public Boolean visitIntersectionOnValuesPlan(@Nonnull RecordQueryIntersectionOnValuesPlan element) {
            return true;
        }

        @Override
        @Nonnull
        public Boolean visitScoreForRankPlan(@Nonnull RecordQueryScoreForRankPlan element) {
            return true;
        }

        @Override
        @Nonnull
        public Boolean visitIndexPlan(@Nonnull RecordQueryIndexPlan indexPlan) {
            Optional<? extends MatchCandidate> matchCandidateOptional = indexPlan.getMatchCandidateMaybe();
            if (matchCandidateOptional.isEmpty()) {
                return false;
            }
            MatchCandidate matchCandidate = matchCandidateOptional.get();
            return !matchCandidate.createsDuplicates();
        }

        @Override
        @Nonnull
        public Boolean visitRecursiveLevelUnionPlan(@Nonnull RecordQueryRecursiveLevelUnionPlan element) {
            return false;
        }

        @Override
        @Nonnull
        public Boolean visitFirstOrDefaultPlan(@Nonnull RecordQueryFirstOrDefaultPlan element) {
            return true;
        }

        @Override
        @Nonnull
        public Boolean visitDefaultOnEmptyPlan(@Nonnull RecordQueryDefaultOnEmptyPlan element) {
            return this.distinctRecordsFromSingleChild(element);
        }

        @Nonnull
        public Boolean visitInJoinPlan(@Nonnull RecordQueryInJoinPlan inJoinPlan) {
            return this.distinctRecordsFromSingleChild(inJoinPlan);
        }

        @Override
        @Nonnull
        public Boolean visitFilterPlan(@Nonnull RecordQueryFilterPlan filterPlan) {
            return this.distinctRecordsFromSingleChild(filterPlan);
        }

        @Override
        @Nonnull
        public Boolean visitUnorderedPrimaryKeyDistinctPlan(@Nonnull RecordQueryUnorderedPrimaryKeyDistinctPlan element) {
            return true;
        }

        @Override
        @Nonnull
        public Boolean visitUnionOnKeyExpressionPlan(@Nonnull RecordQueryUnionOnKeyExpressionPlan element) {
            return true;
        }

        @Override
        @Nonnull
        public Boolean visitTextIndexPlan(@Nonnull RecordQueryTextIndexPlan element) {
            return false;
        }

        @Override
        @Nonnull
        public Boolean visitFetchFromPartialRecordPlan(@Nonnull RecordQueryFetchFromPartialRecordPlan fetchFromPartialRecordPlan) {
            return this.distinctRecordsFromSingleChild(fetchFromPartialRecordPlan);
        }

        @Override
        @Nonnull
        public Boolean visitTypeFilterPlan(@Nonnull RecordQueryTypeFilterPlan typeFilterPlan) {
            return this.distinctRecordsFromSingleChild(typeFilterPlan);
        }

        @Override
        @Nonnull
        public Boolean visitInUnionOnKeyExpressionPlan(@Nonnull RecordQueryInUnionOnKeyExpressionPlan element) {
            return true;
        }

        @Override
        @Nonnull
        public Boolean visitMultiIntersectionOnValuesPlan(@Nonnull RecordQueryMultiIntersectionOnValuesPlan element) {
            return true;
        }

        @Override
        @Nonnull
        public Boolean visitInParameterJoinPlan(@Nonnull RecordQueryInParameterJoinPlan inParameterJoinPlan) {
            return this.visitInJoinPlan(inParameterJoinPlan);
        }

        @Override
        @Nonnull
        public Boolean visitFlatMapPlan(@Nonnull RecordQueryFlatMapPlan element) {
            return false;
        }

        @Override
        @Nonnull
        public Boolean visitStreamingAggregationPlan(@Nonnull RecordQueryStreamingAggregationPlan element) {
            return false;
        }

        @Override
        @Nonnull
        public Boolean visitUnionOnValuesPlan(@Nonnull RecordQueryUnionOnValuesPlan element) {
            return true;
        }

        @Override
        @Nonnull
        public Boolean visitUnorderedUnionPlan(@Nonnull RecordQueryUnorderedUnionPlan element) {
            return false;
        }

        @Override
        @Nonnull
        public Boolean visitScanPlan(@Nonnull RecordQueryScanPlan element) {
            return true;
        }

        @Override
        @Nonnull
        public Boolean visitInUnionOnValuesPlan(@Nonnull RecordQueryInUnionOnValuesPlan element) {
            return true;
        }

        @Override
        @Nonnull
        public Boolean visitComposedBitmapIndexQueryPlan(@Nonnull ComposedBitmapIndexQueryPlan element) {
            return false;
        }

        @Override
        @Nonnull
        public Boolean visitDamPlan(@Nonnull RecordQueryDamPlan damPlan) {
            return this.distinctRecordsFromSingleChild(damPlan);
        }

        @Override
        @Nonnull
        public Boolean visitSortPlan(@Nonnull RecordQuerySortPlan sortPlan) {
            return this.distinctRecordsFromSingleChild(sortPlan);
        }

        @Override
        @Nonnull
        public Boolean visitRecursiveDfsJoinPlan(@Nonnull RecordQueryRecursiveDfsJoinPlan recursiveDfsJoinPlan) {
            return false;
        }

        @Override
        @Nonnull
        public Boolean visitDefault(@Nonnull RecordQueryPlan element) {
            return false;
        }

        private boolean distinctRecordsFromSingleChild(@Nonnull RelationalExpression expression) {
            List<? extends Quantifier> quantifiers = expression.getQuantifiers();
            if (quantifiers.size() == 1) {
                return this.evaluateForReference(Iterables.getOnlyElement(quantifiers).getRangesOver());
            }
            throw new RecordCoreException("cannot compute property for expression", new Object[0]);
        }

        @Nonnull
        private List<Boolean> distinctRecordsFromChildren(@Nonnull RelationalExpression expression) {
            return expression.getQuantifiers().stream().map(quantifier -> {
                if (quantifier instanceof Quantifier.Existential) {
                    return true;
                }
                return this.evaluateForReference(quantifier.getRangesOver());
            }).collect(ImmutableList.toImmutableList());
        }

        private boolean evaluateForReference(@Nonnull Reference reference) {
            Collection<Boolean> memberDistinctRecordsCollection = reference.getPropertyForPlans(DISTINCT_RECORDS).values();
            return memberDistinctRecordsCollection.stream().allMatch(d -> d);
        }
    }
}

