/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.properties;

import com.apple.foundationdb.record.query.plan.cascades.ExpressionProperty;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalFilterExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionVisitorWithDefaults;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.TableFunctionExpression;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class ExpressionCountProperty
implements ExpressionProperty<Integer> {
    @Nonnull
    private static final ExpressionCountProperty SELECT_COUNT = ExpressionCountProperty.ofTrackedTypes(SelectExpression.class, LogicalFilterExpression.class);
    @Nonnull
    private static final ExpressionCountProperty TABLE_FUNCTION_COUNT = ExpressionCountProperty.ofTrackedTypes(TableFunctionExpression.class);
    private final boolean isTracked;
    private final Predicate<? super RelationalExpression> filter;

    private ExpressionCountProperty(@Nonnull Predicate<? super RelationalExpression> filter, boolean isTracked) {
        this.filter = filter;
        this.isTracked = isTracked;
    }

    @Nonnull
    public ExpressionCountVisitor createVisitor() {
        return new ExpressionCountVisitor();
    }

    public int evaluate(@Nonnull Reference reference) {
        return this.evaluate(reference.get());
    }

    public int evaluate(@Nonnull RelationalExpression expression) {
        return Objects.requireNonNull((Integer)this.createVisitor().visit(expression));
    }

    @Nonnull
    public static ExpressionCountProperty selectCount() {
        return SELECT_COUNT;
    }

    @Nonnull
    public static ExpressionCountProperty tableFunctionCount() {
        return TABLE_FUNCTION_COUNT;
    }

    @Nonnull
    @SafeVarargs
    private static ExpressionCountProperty ofTrackedTypes(Class<? extends RelationalExpression> ... expressionTypes) {
        return ExpressionCountProperty.ofTypes(true, expressionTypes);
    }

    @Nonnull
    @SafeVarargs
    private static ExpressionCountProperty ofTypes(boolean isTracked, Class<? extends RelationalExpression> ... expressionTypes) {
        return new ExpressionCountProperty(expr -> Arrays.stream(expressionTypes).anyMatch(type -> type.isInstance(expr)), isTracked);
    }

    public class ExpressionCountVisitor
    implements RelationalExpressionVisitorWithDefaults<Integer> {
        @Override
        @Nonnull
        public Integer visitDefault(@Nonnull RelationalExpression expression) {
            return this.fromChildren(expression).stream().mapToInt(Integer::intValue).sum() + (ExpressionCountProperty.this.filter.test(expression) ? 1 : 0);
        }

        @Nonnull
        private List<Integer> fromChildren(@Nonnull RelationalExpression expression) {
            return expression.getQuantifiers().stream().map(quantifier -> this.forReference(quantifier.getRangesOver())).collect(ImmutableList.toImmutableList());
        }

        private int forReference(@Nonnull Reference reference) {
            Set<RelationalExpression> finalExpressions = reference.getFinalExpressions();
            Verify.verify(finalExpressions.size() == 1);
            if (ExpressionCountProperty.this.isTracked) {
                Collection<Integer> memberResults = reference.getPropertyForExpressions(ExpressionCountProperty.this).values();
                return Iterables.getOnlyElement(memberResults);
            }
            return (Integer)this.visit(Iterables.getOnlyElement(finalExpressions));
        }
    }
}

