/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.properties;

import com.apple.foundationdb.record.query.plan.cascades.ExpressionProperty;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.SimpleExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalDistinctExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalTypeFilterExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithIndex;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTypeFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedPrimaryKeyDistinctPlan;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class ExpressionDepthProperty
implements ExpressionProperty<Integer> {
    private static final ExpressionDepthProperty TYPE_FILTER_DEPTH = new ExpressionDepthProperty(ImmutableSet.of(LogicalTypeFilterExpression.class, RecordQueryTypeFilterPlan.class));
    private static final ExpressionDepthProperty DISTINCT_DEPTH = new ExpressionDepthProperty(ImmutableSet.of(LogicalDistinctExpression.class, RecordQueryUnorderedPrimaryKeyDistinctPlan.class));
    private static final ExpressionDepthProperty FETCH_DEPTH = new ExpressionDepthProperty(ImmutableSet.of(RecordQueryFetchFromPartialRecordPlan.class, RecordQueryPlanWithIndex.class));
    @Nonnull
    private final Set<Class<? extends RelationalExpression>> types;

    private ExpressionDepthProperty(@Nonnull Set<Class<? extends RelationalExpression>> types) {
        this.types = ImmutableSet.copyOf(types);
    }

    @Nonnull
    public ExpressionDepthVisitor createVisitor() {
        return new ExpressionDepthVisitor(this.types);
    }

    public int evaluate(@Nonnull Reference reference) {
        return Objects.requireNonNull(reference.acceptVisitor(this.createVisitor()));
    }

    public int evaluate(@Nonnull RelationalExpression expression) {
        return Objects.requireNonNull(expression.acceptVisitor(this.createVisitor()));
    }

    @Nonnull
    public static ExpressionDepthProperty typeFilterDepth() {
        return TYPE_FILTER_DEPTH;
    }

    @Nonnull
    public static ExpressionDepthProperty distinctDepth() {
        return DISTINCT_DEPTH;
    }

    @Nonnull
    public static ExpressionDepthProperty fetchDepth() {
        return FETCH_DEPTH;
    }

    public static class ExpressionDepthVisitor
    implements SimpleExpressionVisitor<Integer> {
        @Nonnull
        private final Set<Class<? extends RelationalExpression>> types;

        public ExpressionDepthVisitor(@Nonnull Set<Class<? extends RelationalExpression>> types) {
            this.types = ImmutableSet.copyOf(types);
        }

        @Override
        @Nonnull
        public Integer evaluateAtExpression(@Nonnull RelationalExpression expression, @Nonnull List<Integer> childResults) {
            for (Class<? extends RelationalExpression> type : this.types) {
                if (!type.isInstance(expression)) continue;
                return 0;
            }
            int min2 = Integer.MAX_VALUE;
            for (Integer result : childResults) {
                if (result == null || result >= min2) continue;
                min2 = result;
            }
            return min2 == Integer.MAX_VALUE ? Integer.MAX_VALUE : min2 + 1;
        }

        @Override
        @Nonnull
        public Integer evaluateAtRef(@Nonnull Reference ref, @Nonnull List<Integer> memberResults) {
            return Collections.min(memberResults);
        }
    }
}

