/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.properties;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.expressions.ComponentWithChildren;
import com.apple.foundationdb.record.query.expressions.ComponentWithNoChildren;
import com.apple.foundationdb.record.query.expressions.ComponentWithSingleChild;
import com.apple.foundationdb.record.query.expressions.FieldWithComparison;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.cascades.ExpressionProperty;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.SimpleExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFilterPlan;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class FieldWithComparisonCountProperty
implements ExpressionProperty<Integer> {
    private static final FieldWithComparisonCountProperty FIELD_WITH_COMPARISON_COUNT = new FieldWithComparisonCountProperty();

    private FieldWithComparisonCountProperty() {
    }

    @Nonnull
    public FieldWithComparisonCountVisitor createVisitor() {
        return new FieldWithComparisonCountVisitor();
    }

    public int evaluate(@Nonnull Reference ref) {
        return Objects.requireNonNull(ref.acceptVisitor(this.createVisitor()));
    }

    public int evaluate(@Nonnull RelationalExpression expression) {
        return Objects.requireNonNull(expression.acceptVisitor(this.createVisitor()));
    }

    @Nonnull
    public static FieldWithComparisonCountProperty fieldWithComparisonCount() {
        return FIELD_WITH_COMPARISON_COUNT;
    }

    public static class FieldWithComparisonCountVisitor
    implements SimpleExpressionVisitor<Integer> {
        @Override
        @Nonnull
        public Integer evaluateAtExpression(@Nonnull RelationalExpression expression, @Nonnull List<Integer> childResults) {
            int total = 0;
            if (expression instanceof RecordQueryFilterPlan) {
                QueryComponent filter = ((RecordQueryFilterPlan)expression).getConjunctedFilter();
                total = FieldWithComparisonCountVisitor.getFieldWithComparisonCount(filter);
            }
            for (Integer childCount : childResults) {
                if (childCount == null) continue;
                total += childCount.intValue();
            }
            return total;
        }

        @Override
        @Nonnull
        public Integer evaluateAtRef(@Nonnull Reference ref, @Nonnull List<Integer> memberResults) {
            int min2 = Integer.MAX_VALUE;
            for (int memberResult : memberResults) {
                if (memberResult >= min2) continue;
                min2 = memberResult;
            }
            return min2;
        }

        private static int getFieldWithComparisonCount(@Nonnull QueryComponent component) {
            if (component instanceof FieldWithComparison) {
                return 1;
            }
            if (component instanceof ComponentWithNoChildren) {
                return 0;
            }
            if (component instanceof ComponentWithSingleChild) {
                return FieldWithComparisonCountVisitor.getFieldWithComparisonCount(((ComponentWithSingleChild)component).getChild());
            }
            if (component instanceof ComponentWithChildren) {
                return ((ComponentWithChildren)component).getChildren().stream().mapToInt(FieldWithComparisonCountVisitor::getFieldWithComparisonCount).sum();
            }
            throw new UnsupportedOperationException();
        }
    }
}

