/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.properties;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.ExpressionProperty;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.SimpleExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionWithPredicates;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AndPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.OrPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.planning.BooleanPredicateNormalizer;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnionOnValuesPlan;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class NormalizedResidualPredicateProperty
implements ExpressionProperty<QueryPredicate> {
    @Nonnull
    private static final NormalizedResidualPredicateProperty NORMALIZED_RESIDUAL_PREDICATE = new NormalizedResidualPredicateProperty();

    private NormalizedResidualPredicateProperty() {
    }

    @Nonnull
    public NormalizedResidualPredicateVisitor createVisitor() {
        return new NormalizedResidualPredicateVisitor();
    }

    @Nonnull
    public QueryPredicate evaluate(@Nonnull Reference reference) {
        return Objects.requireNonNull(reference.acceptVisitor(this.createVisitor()));
    }

    @Nonnull
    public QueryPredicate evaluate(@Nonnull RelationalExpression expression) {
        return Objects.requireNonNull(expression.acceptVisitor(this.createVisitor()));
    }

    @Nonnull
    public static NormalizedResidualPredicateProperty normalizedResidualPredicate() {
        return NORMALIZED_RESIDUAL_PREDICATE;
    }

    public static long countNormalizedConjuncts(@Nonnull RelationalExpression expression) {
        QueryPredicate magicPredicate = NormalizedResidualPredicateProperty.normalizedResidualPredicate().evaluate(expression);
        return magicPredicate.isTautology() ? 0L : BooleanPredicateNormalizer.getDefaultInstanceForCnf().getMetrics(magicPredicate).getNormalFormFullSize();
    }

    public static class NormalizedResidualPredicateVisitor
    implements SimpleExpressionVisitor<QueryPredicate> {
        @Override
        @Nonnull
        public QueryPredicate visitRecordQueryUnionOnValuesPlan(@Nonnull RecordQueryUnionOnValuesPlan unionPlan) {
            ImmutableList predicatesFromQuantifiers = this.visitQuantifiers(unionPlan).stream().filter(Objects::nonNull).filter(predicate -> !predicate.isTautology()).collect(ImmutableList.toImmutableList());
            return OrPredicate.orOrTrue(predicatesFromQuantifiers);
        }

        @Override
        @Nonnull
        public QueryPredicate evaluateAtExpression(@Nonnull RelationalExpression expression, @Nonnull List<QueryPredicate> childResults) {
            ImmutableList.Builder resultPredicatesBuilder = ImmutableList.builder();
            childResults.stream().filter(Objects::nonNull).filter(predicate -> !predicate.isTautology()).forEach(resultPredicatesBuilder::add);
            if (expression instanceof RelationalExpressionWithPredicates) {
                ((RelationalExpressionWithPredicates)expression).getPredicates().stream().filter(predicate -> !predicate.isTautology()).forEach(resultPredicatesBuilder::add);
            }
            return AndPredicate.and(resultPredicatesBuilder.build());
        }

        @Override
        @Nonnull
        public QueryPredicate evaluateAtRef(@Nonnull Reference ref, @Nonnull List<QueryPredicate> memberResults) {
            Verify.verify(memberResults.size() == 1);
            return Iterables.getOnlyElement(memberResults);
        }
    }
}

