/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.properties;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.query.combinatorics.PartiallyOrderedSet;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.bitmap.ComposedBitmapIndexQueryPlan;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.ExpressionProperty;
import com.apple.foundationdb.record.query.plan.cascades.Ordering;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.WithPrimaryKeyMatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ValuePredicate;
import com.apple.foundationdb.record.query.plan.cascades.properties.CardinalitiesProperty;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.ObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.plans.InSource;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryAggregateIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryComparatorPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryCoveringIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryDefaultOnEmptyPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryDeletePlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryExplodePlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFirstOrDefaultPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFlatMapPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInComparandJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInParameterJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInUnionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInUnionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInValuesJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInsertPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryLoadByKeysPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryMapPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryMultiIntersectionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanVisitor;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPredicatesFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryRangePlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryRecursiveDfsJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryRecursiveLevelUnionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryScanPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryScoreForRankPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQuerySelectorPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryStreamingAggregationPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTableFunctionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTextIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTypeFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedDistinctPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedPrimaryKeyDistinctPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedUnionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUpdatePlan;
import com.apple.foundationdb.record.query.plan.plans.TempTableInsertPlan;
import com.apple.foundationdb.record.query.plan.plans.TempTableScanPlan;
import com.apple.foundationdb.record.query.plan.sorting.RecordQueryDamPlan;
import com.apple.foundationdb.record.query.plan.sorting.RecordQuerySortPlan;
import com.apple.foundationdb.record.util.pair.Pair;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OrderingProperty
implements ExpressionProperty<Ordering> {
    private static final OrderingProperty ORDERING = new OrderingProperty();

    private OrderingProperty() {
    }

    @Override
    @Nonnull
    public RelationalExpressionVisitor<Ordering> createVisitor() {
        return ExpressionProperty.toExpressionVisitor(new OrderingVisitor());
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Nonnull
    public Ordering evaluate(@Nonnull Reference reference) {
        return this.evaluate(reference.getOnlyElementAsPlan());
    }

    @Nonnull
    public Ordering evaluate(@Nonnull RecordQueryPlan recordQueryPlan) {
        return this.createVisitor().visit(recordQueryPlan);
    }

    @Nonnull
    public static OrderingProperty ordering() {
        return ORDERING;
    }

    @API(value=API.Status.EXPERIMENTAL)
    public static class OrderingVisitor
    implements RecordQueryPlanVisitor<Ordering> {
        @Override
        @Nonnull
        public Ordering visitUpdatePlan(@Nonnull RecordQueryUpdatePlan updatePlan) {
            return Ordering.empty();
        }

        @Override
        @Nonnull
        public Ordering visitPredicatesFilterPlan(@Nonnull RecordQueryPredicatesFilterPlan predicatesFilterPlan) {
            Ordering childOrdering = this.orderingFromSingleChild(predicatesFilterPlan);
            SetMultimap equalityBoundValuesMap = predicatesFilterPlan.getPredicates().stream().flatMap(queryPredicate -> {
                if (!(queryPredicate instanceof ValuePredicate)) {
                    return Stream.empty();
                }
                ValuePredicate valuePredicate = (ValuePredicate)queryPredicate;
                if (!valuePredicate.getComparison().getType().isEquality()) {
                    return Stream.empty();
                }
                if (!(valuePredicate.getValue() instanceof FieldValue)) {
                    return Stream.empty();
                }
                FieldValue fieldValue = (FieldValue)valuePredicate.getValue();
                if (fieldValue.getFieldPathNamesMaybe().stream().anyMatch(Optional::isEmpty)) {
                    return Stream.empty();
                }
                Set<CorrelationIdentifier> fieldValueCorrelatedTo = fieldValue.getCorrelatedTo();
                CorrelationIdentifier innerAlias = predicatesFilterPlan.getInner().getAlias();
                if (fieldValueCorrelatedTo.size() != 1 || !Iterables.getOnlyElement(fieldValueCorrelatedTo).equals(innerAlias)) {
                    return Stream.empty();
                }
                if (valuePredicate.getComparison().getCorrelatedTo().contains(innerAlias)) {
                    return Stream.empty();
                }
                AliasMap translationMap = AliasMap.ofAliases(innerAlias, Quantifier.current());
                return Stream.of(Pair.of(fieldValue.rebase(translationMap), valuePredicate.getComparison()));
            }).collect(ImmutableSetMultimap.toImmutableSetMultimap(Pair::getLeft, Pair::getRight));
            PartiallyOrderedSet<Value> childOrderingSet = childOrdering.getOrderingSet();
            SetMultimap<Value, Ordering.Binding> childBindingMap = childOrdering.getBindingMap();
            Sets.SetView<Value> resultOrderingSetDomain = Sets.union(childOrderingSet.getSet(), equalityBoundValuesMap.keySet());
            ImmutableSetMultimap.Builder resultBindingMapBuilder = ImmutableSetMultimap.builder();
            for (Value value : resultOrderingSetDomain) {
                if (equalityBoundValuesMap.containsKey(value)) {
                    equalityBoundValuesMap.get(value).stream().map(Ordering.Binding::fixed).forEach(binding -> resultBindingMapBuilder.put(value, binding));
                    continue;
                }
                resultBindingMapBuilder.putAll((Object)value, (Iterable)childBindingMap.get((Object)value));
            }
            ImmutableMultimap resultBindingMap = resultBindingMapBuilder.build();
            PartiallyOrderedSet<Value> orderingSet = Ordering.normalizeOrderingSet((SetMultimap<Value, Ordering.Binding>)((Object)resultBindingMap), PartiallyOrderedSet.of(resultOrderingSetDomain, childOrderingSet.getDependencyMap()));
            return Ordering.ofOrderingSet((SetMultimap<Value, Ordering.Binding>)((Object)resultBindingMap), orderingSet, childOrdering.isDistinct());
        }

        @Override
        @Nonnull
        public Ordering visitLoadByKeysPlan(@Nonnull RecordQueryLoadByKeysPlan element) {
            return Ordering.empty();
        }

        @Override
        @Nonnull
        public Ordering visitInValuesJoinPlan(@Nonnull RecordQueryInValuesJoinPlan inValuesJoinPlan) {
            return this.visitInJoinPlan(inValuesJoinPlan);
        }

        @Override
        @Nonnull
        public Ordering visitInComparandJoinPlan(@Nonnull RecordQueryInComparandJoinPlan inComparandJoinPlan) {
            return this.visitInJoinPlan(inComparandJoinPlan);
        }

        @Override
        @Nonnull
        public Ordering visitAggregateIndexPlan(@Nonnull RecordQueryAggregateIndexPlan aggregateIndexPlan) {
            return (Ordering)this.visit(aggregateIndexPlan.getIndexPlan());
        }

        @Override
        @Nonnull
        public Ordering visitCoveringIndexPlan(@Nonnull RecordQueryCoveringIndexPlan coveringIndexPlan) {
            return (Ordering)this.visit(coveringIndexPlan.getIndexPlan());
        }

        @Override
        @Nonnull
        public Ordering visitDeletePlan(@Nonnull RecordQueryDeletePlan deletePlan) {
            return this.orderingFromSingleChild(deletePlan);
        }

        @Override
        @Nonnull
        public Ordering visitIntersectionOnKeyExpressionPlan(@Nonnull RecordQueryIntersectionOnKeyExpressionPlan intersectionPlan) {
            return Ordering.empty();
        }

        @Override
        @Nonnull
        public Ordering visitMapPlan(@Nonnull RecordQueryMapPlan mapPlan) {
            Ordering childOrdering = this.orderingFromSingleChild(mapPlan);
            Value resultValue = mapPlan.getResultValue();
            return childOrdering.pullUp(resultValue, EvaluationContext.empty(), AliasMap.ofAliases(mapPlan.getInner().getAlias(), Quantifier.current()), mapPlan.getCorrelatedTo());
        }

        @Override
        @Nonnull
        public Ordering visitComparatorPlan(@Nonnull RecordQueryComparatorPlan element) {
            return Ordering.empty();
        }

        @Override
        @Nonnull
        public Ordering visitUnorderedDistinctPlan(@Nonnull RecordQueryUnorderedDistinctPlan unorderedDistinctPlan) {
            return this.orderingFromSingleChild(unorderedDistinctPlan);
        }

        @Override
        @Nonnull
        public Ordering visitSelectorPlan(@Nonnull RecordQuerySelectorPlan element) {
            return Ordering.empty();
        }

        @Override
        @Nonnull
        public Ordering visitRangePlan(@Nonnull RecordQueryRangePlan element) {
            ObjectValue resultValue = ObjectValue.of(Quantifier.current(), Type.primitiveType(Type.TypeCode.INT));
            return Ordering.ofOrderingSet(ImmutableSetMultimap.of(resultValue, Ordering.Binding.sorted(OrderingPart.ProvidedSortOrder.ASCENDING)), PartiallyOrderedSet.of(ImmutableSet.of(resultValue), ImmutableSetMultimap.of()), true);
        }

        @Override
        @Nonnull
        public Ordering visitTempTableScanPlan(@Nonnull TempTableScanPlan element) {
            return Ordering.empty();
        }

        @Override
        @Nonnull
        public Ordering visitExplodePlan(@Nonnull RecordQueryExplodePlan element) {
            return Ordering.empty();
        }

        @Override
        @Nonnull
        public Ordering visitInsertPlan(@Nonnull RecordQueryInsertPlan insertPlan) {
            return Ordering.empty();
        }

        @Override
        @Nonnull
        public Ordering visitTableFunctionPlan(@Nonnull RecordQueryTableFunctionPlan element) {
            return Ordering.empty();
        }

        @Override
        @Nonnull
        public Ordering visitTempTableInsertPlan(@Nonnull TempTableInsertPlan tempTableInsertPlan) {
            return this.orderingFromSingleChild(tempTableInsertPlan);
        }

        @Override
        @Nonnull
        public Ordering visitIntersectionOnValuesPlan(@Nonnull RecordQueryIntersectionOnValuesPlan intersectionOnValuePlan) {
            List<Ordering> orderings = this.orderingsFromChildren(intersectionOnValuePlan);
            return OrderingVisitor.deriveForDistinctSetOperationFromOrderings(orderings, intersectionOnValuePlan.getComparisonKeyOrderingParts(), Ordering.INTERSECTION);
        }

        @Override
        @Nonnull
        public Ordering visitScoreForRankPlan(@Nonnull RecordQueryScoreForRankPlan element) {
            return Ordering.empty();
        }

        @Override
        @Nonnull
        public Ordering visitIndexPlan(@Nonnull RecordQueryIndexPlan indexPlan) {
            ScanComparisons scanComparisons = indexPlan.getScanComparisons();
            return indexPlan.getMatchCandidateMaybe().map(matchCandidate -> matchCandidate.computeOrderingFromScanComparisons(scanComparisons, indexPlan.isReverse(), indexPlan.isStrictlySorted())).orElse(Ordering.empty());
        }

        @Override
        @Nonnull
        public Ordering visitRecursiveLevelUnionPlan(@Nonnull RecordQueryRecursiveLevelUnionPlan element) {
            return Ordering.empty();
        }

        @Override
        @Nonnull
        public Ordering visitFirstOrDefaultPlan(@Nonnull RecordQueryFirstOrDefaultPlan element) {
            return Ordering.empty();
        }

        @Override
        @Nonnull
        public Ordering visitDefaultOnEmptyPlan(@Nonnull RecordQueryDefaultOnEmptyPlan element) {
            return this.orderingFromSingleChild(element);
        }

        @Nonnull
        public Ordering visitInJoinPlan(@Nonnull RecordQueryInJoinPlan inJoinPlan) {
            ImmutableMultimap resultBindingMap;
            Value value2;
            ImmutableSetMultimap.Builder resultBindingMapBuilder;
            Ordering innerOrdering = this.orderingFromSingleChild(inJoinPlan);
            SetMultimap<Value, Ordering.Binding> bindingMap = innerOrdering.getBindingMap();
            InSource inSource = inJoinPlan.getInSource();
            CorrelationIdentifier inAlias = inJoinPlan.getInAlias();
            Value inValue = OrderingVisitor.findValueForIn(bindingMap, inAlias);
            if (inValue != null && inSource.isSorted()) {
                resultBindingMapBuilder = ImmutableSetMultimap.builder();
                for (Map.Entry entry : bindingMap.entries()) {
                    value2 = (Value)entry.getKey();
                    Ordering.Binding binding = (Ordering.Binding)entry.getValue();
                    if (!binding.isFixed() || !value2.equals(inValue)) {
                        resultBindingMapBuilder.put(value2, binding);
                        continue;
                    }
                    resultBindingMapBuilder.put(value2, Ordering.Binding.sorted(inSource.isReverse()));
                }
                resultBindingMap = resultBindingMapBuilder.build();
            } else {
                resultBindingMapBuilder = ImmutableSetMultimap.builder();
                for (Map.Entry entry : bindingMap.entries()) {
                    value2 = (Value)entry.getKey();
                    Ordering.Binding binding = (Ordering.Binding)entry.getValue();
                    if (!binding.isFixed() || value2.equals(inValue)) continue;
                    resultBindingMapBuilder.put(value2, binding);
                }
                resultBindingMap = resultBindingMapBuilder.build();
            }
            if (inValue == null || !inSource.isSorted()) {
                return Ordering.ofOrderingSet((SetMultimap<Value, Ordering.Binding>)((Object)resultBindingMap), PartiallyOrderedSet.of(resultBindingMap.keySet(), ImmutableSetMultimap.of()), false);
            }
            PartiallyOrderedSet<Value> outerOrderingSet = PartiallyOrderedSet.builder().add(inValue).build();
            Ordering outerOrdering = Ordering.ofOrderingSet(ImmutableSetMultimap.of(inValue, Ordering.Binding.sorted(inSource.isReverse())), outerOrderingSet, true);
            PartiallyOrderedSet<Value> filteredInnerOrderingSet = innerOrdering.getOrderingSet().filterElements(value -> innerOrdering.isSingularNonFixedValue((Value)value) || !inValue.equals(value));
            Ordering filteredInnerOrdering = Ordering.ofOrderingSet((SetMultimap<Value, Ordering.Binding>)((Object)resultBindingMap), filteredInnerOrderingSet, innerOrdering.isDistinct());
            return Ordering.concatOrderings(outerOrdering, filteredInnerOrdering);
        }

        @Nullable
        private static Value findValueForIn(SetMultimap<Value, Ordering.Binding> bindingMap, CorrelationIdentifier inAlias) {
            Value inValue = null;
            for (Map.Entry entry : bindingMap.entries()) {
                Comparisons.Comparison comparison;
                Set<CorrelationIdentifier> correlatedTo;
                Ordering.Binding binding = (Ordering.Binding)entry.getValue();
                if (!binding.isFixed() || (correlatedTo = (comparison = binding.getComparison()).getCorrelatedTo()).size() != 1 || !inAlias.equals(Iterables.getOnlyElement(correlatedTo))) continue;
                inValue = (Value)entry.getKey();
                break;
            }
            return inValue;
        }

        @Override
        @Nonnull
        public Ordering visitFilterPlan(@Nonnull RecordQueryFilterPlan filterPlan) {
            return this.orderingFromSingleChild(filterPlan);
        }

        @Override
        @Nonnull
        public Ordering visitUnorderedPrimaryKeyDistinctPlan(@Nonnull RecordQueryUnorderedPrimaryKeyDistinctPlan unorderedPrimaryKeyDistinctPlan) {
            return this.orderingFromSingleChild(unorderedPrimaryKeyDistinctPlan);
        }

        @Override
        @Nonnull
        public Ordering visitUnionOnKeyExpressionPlan(@Nonnull RecordQueryUnionOnKeyExpressionPlan unionOnKeyExpressionPlan) {
            return Ordering.empty();
        }

        @Override
        @Nonnull
        public Ordering visitTextIndexPlan(@Nonnull RecordQueryTextIndexPlan element) {
            return Ordering.empty();
        }

        @Override
        @Nonnull
        public Ordering visitFetchFromPartialRecordPlan(@Nonnull RecordQueryFetchFromPartialRecordPlan element) {
            return this.orderingFromSingleChild(element);
        }

        @Override
        @Nonnull
        public Ordering visitTypeFilterPlan(@Nonnull RecordQueryTypeFilterPlan typeFilterPlan) {
            return this.orderingFromSingleChild(typeFilterPlan);
        }

        @Override
        @Nonnull
        public Ordering visitInUnionOnKeyExpressionPlan(@Nonnull RecordQueryInUnionOnKeyExpressionPlan inUnionOnKeyExpressionPlan) {
            return Ordering.empty();
        }

        @Override
        @Nonnull
        public Ordering visitMultiIntersectionOnValuesPlan(@Nonnull RecordQueryMultiIntersectionOnValuesPlan multiIntersectionOnValuesPlan) {
            List<Ordering> orderings = this.orderingsFromChildren(multiIntersectionOnValuesPlan);
            return OrderingVisitor.deriveForDistinctSetOperationFromOrderings(orderings, multiIntersectionOnValuesPlan.getComparisonKeyOrderingParts(), Ordering.INTERSECTION);
        }

        @Override
        @Nonnull
        public Ordering visitInParameterJoinPlan(@Nonnull RecordQueryInParameterJoinPlan inParameterJoinPlan) {
            return this.visitInJoinPlan(inParameterJoinPlan);
        }

        @Override
        @Nonnull
        public Ordering visitFlatMapPlan(@Nonnull RecordQueryFlatMapPlan flatMapPlan) {
            List<Ordering> orderingsFromChildren = this.orderingsFromChildren(flatMapPlan);
            Ordering outerOrdering = orderingsFromChildren.get(0);
            Ordering innerOrdering = orderingsFromChildren.get(1);
            Set<CorrelationIdentifier> correlatedTo = flatMapPlan.getCorrelatedTo();
            Value resultValue = flatMapPlan.getResultValue();
            CardinalitiesProperty.Cardinalities outerCardinalities = CardinalitiesProperty.cardinalities().evaluate(flatMapPlan.getOuterQuantifier().getRangesOver());
            CardinalitiesProperty.Cardinality outerMaxCardinality = outerCardinalities.getMaxCardinality();
            if (!outerMaxCardinality.isUnknown() && outerMaxCardinality.getCardinality() == 1L) {
                return innerOrdering.pullUp(resultValue, EvaluationContext.empty(), AliasMap.ofAliases(flatMapPlan.getInnerQuantifier().getAlias(), Quantifier.current()), correlatedTo);
            }
            if (!outerOrdering.isDistinct()) {
                return outerOrdering.pullUp(resultValue, EvaluationContext.empty(), AliasMap.ofAliases(flatMapPlan.getInnerQuantifier().getAlias(), Quantifier.current()), correlatedTo);
            }
            return Ordering.concatOrderings(outerOrdering, innerOrdering);
        }

        @Override
        @Nonnull
        public Ordering visitStreamingAggregationPlan(@Nonnull RecordQueryStreamingAggregationPlan streamingAggregationPlan) {
            Ordering childOrdering = this.orderingFromSingleChild(streamingAggregationPlan);
            Value groupingValue = streamingAggregationPlan.getGroupingValue();
            if (groupingValue == null) {
                return Ordering.empty();
            }
            CorrelationIdentifier groupingKeyAlias = streamingAggregationPlan.getGroupingKeyAlias();
            Value completeResultValue = streamingAggregationPlan.getCompleteResultValue();
            Optional composedCompleteResultValueOptional = completeResultValue.replaceLeavesMaybe(value -> {
                if (value instanceof ObjectValue && ((ObjectValue)value).getAlias().equals(groupingKeyAlias)) {
                    return groupingValue;
                }
                return value;
            });
            if (composedCompleteResultValueOptional.isEmpty()) {
                return Ordering.empty();
            }
            Value composedCompleteResultValue = (Value)composedCompleteResultValueOptional.get();
            return childOrdering.pullUp(composedCompleteResultValue, EvaluationContext.empty(), AliasMap.ofAliases(streamingAggregationPlan.getInner().getAlias(), Quantifier.current()), streamingAggregationPlan.getCorrelatedTo());
        }

        @Override
        @Nonnull
        public Ordering visitUnionOnValuesPlan(@Nonnull RecordQueryUnionOnValuesPlan unionOnValuesPlan) {
            return OrderingVisitor.deriveForDistinctSetOperationFromOrderings(this.orderingsFromChildren(unionOnValuesPlan), unionOnValuesPlan.getComparisonKeyOrderingParts(), Ordering.UNION);
        }

        @Override
        @Nonnull
        public Ordering visitUnorderedUnionPlan(@Nonnull RecordQueryUnorderedUnionPlan unorderedUnionPlan) {
            return Ordering.empty();
        }

        @Override
        @Nonnull
        public Ordering visitScanPlan(@Nonnull RecordQueryScanPlan scanPlan) {
            Optional<? extends WithPrimaryKeyMatchCandidate> primaryMatchCandidate = scanPlan.getMatchCandidateMaybe();
            return primaryMatchCandidate.map(withPrimaryKeyMatchCandidate -> withPrimaryKeyMatchCandidate.computeOrderingFromScanComparisons(scanPlan.getScanComparisons(), scanPlan.isReverse(), false)).orElseGet(Ordering::empty);
        }

        @Override
        @Nonnull
        public Ordering visitInUnionOnValuesPlan(@Nonnull RecordQueryInUnionOnValuesPlan inUnionOnValuePlan) {
            Ordering childOrdering = this.orderingFromSingleChild(inUnionOnValuePlan);
            SetMultimap<Value, Ordering.Binding> bindingMap = childOrdering.getBindingMap();
            List<OrderingPart.ProvidedOrderingPart> comparisonKeyOrderingParts = inUnionOnValuePlan.getComparisonKeyOrderingParts();
            Map<Value, OrderingPart.ProvidedOrderingPart> comparisonKeyOrderingPartMap = OrderingPart.toOrderingPartMap(comparisonKeyOrderingParts);
            List<Value> comparisonKeyValues = OrderingPart.toValues(comparisonKeyOrderingParts);
            ImmutableSetMultimap.Builder resultBindingMapBuilder = ImmutableSetMultimap.builder();
            ImmutableSet sourceAliases = inUnionOnValuePlan.getInSources().stream().map(inSource -> CorrelationIdentifier.of(Bindings.Internal.CORRELATION.identifier(inSource.getBindingName()))).collect(ImmutableSet.toImmutableSet());
            for (Map.Entry entry : bindingMap.entries()) {
                Value value = (Value)entry.getKey();
                Ordering.Binding binding = (Ordering.Binding)entry.getValue();
                if (binding.isFixed()) {
                    Set<CorrelationIdentifier> correlatedTo = value.getCorrelatedTo();
                    if (correlatedTo.stream().anyMatch(sourceAliases::contains)) {
                        resultBindingMapBuilder.putAll((Object)value, new Ordering.Binding[]{Ordering.Binding.sorted((OrderingPart.ProvidedSortOrder)Objects.requireNonNull(comparisonKeyOrderingPartMap.get(value)).getSortOrder())});
                        continue;
                    }
                    resultBindingMapBuilder.putAll((Object)value, new Ordering.Binding[]{binding});
                    continue;
                }
                resultBindingMapBuilder.putAll((Object)value, new Ordering.Binding[]{binding});
            }
            return Ordering.ofOrderingSequence((SetMultimap<Value, Ordering.Binding>)((Object)resultBindingMapBuilder.build()), comparisonKeyValues, childOrdering.isDistinct());
        }

        @Override
        @Nonnull
        public Ordering visitComposedBitmapIndexQueryPlan(@Nonnull ComposedBitmapIndexQueryPlan element) {
            return Ordering.empty();
        }

        @Override
        @Nonnull
        public Ordering visitDamPlan(@Nonnull RecordQueryDamPlan damPlan) {
            return this.orderingFromSingleChild(damPlan);
        }

        @Override
        @Nonnull
        public Ordering visitSortPlan(@Nonnull RecordQuerySortPlan element) {
            return Ordering.empty();
        }

        @Override
        @Nonnull
        public Ordering visitRecursiveDfsJoinPlan(@Nonnull RecordQueryRecursiveDfsJoinPlan recursiveDfsJoinPlan) {
            return Ordering.empty();
        }

        @Override
        @Nonnull
        public Ordering visitDefault(@Nonnull RecordQueryPlan element) {
            return Ordering.empty();
        }

        @Nonnull
        private Ordering orderingFromSingleChild(@Nonnull RelationalExpression expression) {
            List<? extends Quantifier> quantifiers = expression.getQuantifiers();
            if (quantifiers.size() == 1) {
                return this.evaluateForReference(Iterables.getOnlyElement(quantifiers).getRangesOver());
            }
            return Ordering.empty();
        }

        @Nonnull
        private List<Ordering> orderingsFromChildren(@Nonnull RelationalExpression expression) {
            return expression.getQuantifiers().stream().map(quantifier -> {
                if (quantifier instanceof Quantifier.Existential) {
                    return Ordering.empty();
                }
                return this.evaluateForReference(quantifier.getRangesOver());
            }).collect(ImmutableList.toImmutableList());
        }

        @Nonnull
        private Ordering evaluateForReference(@Nonnull Reference reference) {
            Collection<Ordering> memberOrderings = reference.getPropertyForPlans(ORDERING).values();
            boolean allAreDistinct = memberOrderings.stream().allMatch(Ordering::isDistinct);
            return Ordering.merge(memberOrderings, Ordering.UNION, (left, right) -> allAreDistinct);
        }

        public static <O extends Ordering.SetOperationsOrdering> Ordering deriveForDistinctSetOperationFromOrderings(@Nonnull List<Ordering> orderings, @Nonnull List<OrderingPart.ProvidedOrderingPart> comparisonKeyOrderingParts, @Nonnull Ordering.MergeOperator<O> mergeOperator) {
            Ordering.SetOperationsOrdering mergedOrdering = Ordering.merge(orderings, mergeOperator, (left, right) -> true);
            return mergedOrdering.applyComparisonKey(comparisonKeyOrderingParts);
        }
    }
}

