/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.properties;

import com.apple.foundationdb.record.query.plan.cascades.ExpressionProperty;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.TreeLike;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionVisitorWithDefaults;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionWithPredicates;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class PredicateComplexityProperty
implements ExpressionProperty<Integer> {
    @Nonnull
    private static final PredicateComplexityProperty PREDICATE_COMPLEXITY = PredicateComplexityProperty.newInstance();
    private final boolean isTracked;
    private final Function<? super RelationalExpression, Integer> scoringFunction;

    private PredicateComplexityProperty(@Nonnull Function<? super RelationalExpression, Integer> scoringFunction, boolean isTracked) {
        this.scoringFunction = scoringFunction;
        this.isTracked = isTracked;
    }

    @Nonnull
    public PredicateComplexityVisitor createVisitor() {
        return new PredicateComplexityVisitor(this.scoringFunction, this);
    }

    public int evaluate(@Nonnull Reference reference) {
        return this.evaluate(reference.get());
    }

    public int evaluate(@Nonnull RelationalExpression expression) {
        return Objects.requireNonNull((Integer)this.createVisitor().visit(expression));
    }

    @Nonnull
    public static PredicateComplexityProperty predicateComplexity() {
        return PREDICATE_COMPLEXITY;
    }

    @Nonnull
    private static PredicateComplexityProperty newInstance() {
        return new PredicateComplexityProperty(expr -> expr instanceof RelationalExpressionWithPredicates ? ((RelationalExpressionWithPredicates)expr).getPredicates().stream().map(TreeLike::diameterWithLevelCounting).max(Integer::compareTo).orElse(0) : 0, true);
    }

    public static class PredicateComplexityVisitor
    implements RelationalExpressionVisitorWithDefaults<Integer> {
        @Nonnull
        private final Function<? super RelationalExpression, Integer> filter;
        @Nonnull
        private final PredicateComplexityProperty property;

        private PredicateComplexityVisitor(@Nonnull Function<? super RelationalExpression, Integer> filter, @Nonnull PredicateComplexityProperty property) {
            this.filter = filter;
            this.property = property;
        }

        @Override
        @Nonnull
        public Integer visitDefault(@Nonnull RelationalExpression expression) {
            Integer nodeMax = this.filter.apply(expression);
            int nodeChildrenMax = this.fromChildren(expression).stream().mapToInt(Integer::intValue).max().orElse(0);
            return Math.max(nodeMax, nodeChildrenMax);
        }

        @Nonnull
        private List<Integer> fromChildren(@Nonnull RelationalExpression expression) {
            return expression.getQuantifiers().stream().map(quantifier -> this.forReference(quantifier.getRangesOver())).collect(ImmutableList.toImmutableList());
        }

        private int forReference(@Nonnull Reference reference) {
            Set<RelationalExpression> finalExpressions = reference.getFinalExpressions();
            Verify.verify(finalExpressions.size() == 1);
            if (this.property.isTracked) {
                Collection<Integer> memberResults = reference.getPropertyForExpressions(this.property).values();
                return Iterables.getOnlyElement(memberResults);
            }
            return (Integer)this.visit(Iterables.getOnlyElement(finalExpressions));
        }
    }
}

