/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.properties;

import com.apple.foundationdb.record.query.plan.cascades.ExpressionProperty;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.SimpleExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionWithPredicates;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

public class PredicateHeightProperty
implements ExpressionProperty<PredicateHeightInfo> {
    private static final PredicateHeightProperty PREDICATE_HEIGHT = new PredicateHeightProperty();

    private PredicateHeightProperty() {
    }

    @Override
    @Nonnull
    public RelationalExpressionVisitor<PredicateHeightInfo> createVisitor() {
        return PredicateHeightVisitor.VISITOR;
    }

    public int evaluate(RelationalExpression expression) {
        return this.createVisitor().visit(expression).getPredicateHeight();
    }

    @Nonnull
    public static PredicateHeightProperty predicateHeight() {
        return PREDICATE_HEIGHT;
    }

    private static final class PredicateHeightVisitor
    implements SimpleExpressionVisitor<PredicateHeightInfo> {
        private static final PredicateHeightVisitor VISITOR = new PredicateHeightVisitor();

        private PredicateHeightVisitor() {
        }

        @Override
        @Nonnull
        public PredicateHeightInfo evaluateAtExpression(@Nonnull RelationalExpression expression, @Nonnull List<PredicateHeightInfo> childResults) {
            RelationalExpressionWithPredicates predicateExpression;
            int newHeight = childResults.stream().mapToInt(PredicateHeightInfo::getHeight).max().orElse(0) + 1;
            if (expression instanceof RelationalExpressionWithPredicates && !(predicateExpression = (RelationalExpressionWithPredicates)expression).getPredicates().isEmpty()) {
                return new PredicateHeightInfo(newHeight, newHeight);
            }
            int newPredicateHeight = childResults.stream().mapToInt(PredicateHeightInfo::getPredicateHeight).max().orElse(0);
            return new PredicateHeightInfo(newHeight, newPredicateHeight);
        }

        @Override
        @Nonnull
        public PredicateHeightInfo evaluateAtRef(@Nonnull Reference ref, @Nonnull List<PredicateHeightInfo> memberResults) {
            if (memberResults.size() == 1) {
                return Iterables.getOnlyElement(memberResults);
            }
            return PredicateHeightInfo.combine(memberResults);
        }
    }

    public static final class PredicateHeightInfo {
        private final int height;
        private final int predicateHeight;

        private PredicateHeightInfo(int height, int predicateHeight) {
            this.height = height;
            this.predicateHeight = predicateHeight;
        }

        public static PredicateHeightInfo combine(Collection<? extends PredicateHeightInfo> heightInfos) {
            int newHeight = 0;
            int newPredicateHeight = 0;
            for (PredicateHeightInfo predicateHeightInfo : heightInfos) {
                newHeight = Math.max(newHeight, predicateHeightInfo.height);
                newPredicateHeight = Math.max(newPredicateHeight, predicateHeightInfo.predicateHeight);
            }
            return new PredicateHeightInfo(newHeight, newPredicateHeight);
        }

        public int getHeight() {
            return this.height;
        }

        public int getPredicateHeight() {
            return this.predicateHeight;
        }
    }
}

