/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.properties;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.plan.bitmap.ComposedBitmapIndexQueryPlan;
import com.apple.foundationdb.record.query.plan.cascades.ExpressionProperty;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.ScalarTranslationVisitor;
import com.apple.foundationdb.record.query.plan.cascades.WithPrimaryKeyMatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryAggregateIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryComparatorPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryCoveringIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryDefaultOnEmptyPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryDeletePlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryExplodePlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFirstOrDefaultPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFlatMapPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInComparandJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInParameterJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInUnionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInUnionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInValuesJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInsertPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryLoadByKeysPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryMapPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryMultiIntersectionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanVisitor;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithIndex;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPredicatesFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryRangePlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryRecursiveDfsJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryRecursiveLevelUnionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryScanPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryScoreForRankPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQuerySelectorPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryStreamingAggregationPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTableFunctionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTextIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTypeFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedDistinctPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedPrimaryKeyDistinctPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedUnionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUpdatePlan;
import com.apple.foundationdb.record.query.plan.plans.TempTableInsertPlan;
import com.apple.foundationdb.record.query.plan.plans.TempTableScanPlan;
import com.apple.foundationdb.record.query.plan.sorting.RecordQueryDamPlan;
import com.apple.foundationdb.record.query.plan.sorting.RecordQuerySortPlan;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class PrimaryKeyProperty
implements ExpressionProperty<Optional<List<Value>>> {
    private static final PrimaryKeyProperty PRIMARY_KEY = new PrimaryKeyProperty();

    private PrimaryKeyProperty() {
    }

    @Override
    @Nonnull
    public RelationalExpressionVisitor<Optional<List<Value>>> createVisitor() {
        return ExpressionProperty.toExpressionVisitor(new PrimaryKeyVisitor());
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Nonnull
    public Optional<List<Value>> evaluate(@Nonnull Reference reference) {
        return this.evaluate(reference.getOnlyElementAsPlan());
    }

    @Nonnull
    public Optional<List<Value>> evaluate(@Nonnull RecordQueryPlan recordQueryPlan) {
        return this.createVisitor().visit(recordQueryPlan);
    }

    @Nonnull
    public static PrimaryKeyProperty primaryKey() {
        return PRIMARY_KEY;
    }

    @Nonnull
    public static Optional<List<Value>> commonPrimaryKeyValuesMaybeFromOptionals(@Nonnull Iterable<Optional<List<Value>>> primaryKeyOptionals) {
        if (Streams.stream(primaryKeyOptionals).anyMatch(Optional::isEmpty)) {
            return Optional.empty();
        }
        return PrimaryKeyProperty.commonPrimaryKeyMaybe(Streams.stream(primaryKeyOptionals).map(Optional::get).collect(ImmutableList.toImmutableList()));
    }

    @Nonnull
    private static Optional<List<Value>> commonPrimaryKeyMaybe(@Nonnull Iterable<List<Value>> primaryKeys) {
        List<Value> common = null;
        boolean first = true;
        for (List<Value> primaryKey : primaryKeys) {
            if (first) {
                common = primaryKey;
                first = false;
                continue;
            }
            if (common.equals(primaryKey)) continue;
            return Optional.empty();
        }
        return Optional.ofNullable(common);
    }

    public static class PrimaryKeyVisitor
    implements RecordQueryPlanVisitor<Optional<List<Value>>> {
        @Override
        @Nonnull
        public Optional<List<Value>> visitUpdatePlan(@Nonnull RecordQueryUpdatePlan updatePlan) {
            return Optional.empty();
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitPredicatesFilterPlan(@Nonnull RecordQueryPredicatesFilterPlan predicatesFilterPlan) {
            return this.primaryKeyFromSingleChild(predicatesFilterPlan);
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitLoadByKeysPlan(@Nonnull RecordQueryLoadByKeysPlan element) {
            return Optional.empty();
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitInValuesJoinPlan(@Nonnull RecordQueryInValuesJoinPlan inValuesJoinPlan) {
            return this.visitInJoinPlan(inValuesJoinPlan);
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitInComparandJoinPlan(@Nonnull RecordQueryInComparandJoinPlan inComparandJoinPlan) {
            return this.visitInJoinPlan(inComparandJoinPlan);
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitAggregateIndexPlan(@Nonnull RecordQueryAggregateIndexPlan aggregateIndexPlan) {
            return Optional.empty();
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitCoveringIndexPlan(@Nonnull RecordQueryCoveringIndexPlan coveringIndexPlan) {
            RecordQueryPlanWithIndex indexPlan = coveringIndexPlan.getIndexPlan();
            if (indexPlan instanceof RecordQueryIndexPlan) {
                return this.visitIndexPlan((RecordQueryIndexPlan)indexPlan);
            }
            return Optional.empty();
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitDeletePlan(@Nonnull RecordQueryDeletePlan deletePlan) {
            return this.primaryKeyFromSingleChild(deletePlan);
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitIntersectionOnKeyExpressionPlan(@Nonnull RecordQueryIntersectionOnKeyExpressionPlan intersectionOnKeyExpressionPlan) {
            return this.commonPrimaryKeyFromChildren(intersectionOnKeyExpressionPlan);
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitMapPlan(@Nonnull RecordQueryMapPlan mapPlan) {
            return this.primaryKeyFromSingleChild(mapPlan);
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitComparatorPlan(@Nonnull RecordQueryComparatorPlan comparatorPlan) {
            return this.commonPrimaryKeyFromChildren(comparatorPlan);
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitUnorderedDistinctPlan(@Nonnull RecordQueryUnorderedDistinctPlan unorderedDistinctPlan) {
            return this.primaryKeyFromSingleChild(unorderedDistinctPlan);
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitSelectorPlan(@Nonnull RecordQuerySelectorPlan selectorPlan) {
            return this.commonPrimaryKeyFromChildren(selectorPlan);
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitRangePlan(@Nonnull RecordQueryRangePlan element) {
            return Optional.empty();
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitTempTableScanPlan(@Nonnull TempTableScanPlan element) {
            return Optional.empty();
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitExplodePlan(@Nonnull RecordQueryExplodePlan element) {
            return Optional.empty();
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitInsertPlan(@Nonnull RecordQueryInsertPlan insertPlan) {
            return Optional.empty();
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitTableFunctionPlan(@Nonnull RecordQueryTableFunctionPlan element) {
            return Optional.empty();
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitTempTableInsertPlan(@Nonnull TempTableInsertPlan tempTableInsertPlan) {
            return Optional.empty();
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitIntersectionOnValuesPlan(@Nonnull RecordQueryIntersectionOnValuesPlan intersectionOnValuesPlan) {
            return this.commonPrimaryKeyFromChildren(intersectionOnValuesPlan);
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitScoreForRankPlan(@Nonnull RecordQueryScoreForRankPlan scoreForRankPlan) {
            return this.primaryKeyFromSingleChild(scoreForRankPlan);
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitIndexPlan(@Nonnull RecordQueryIndexPlan indexPlan) {
            return Optional.of(ScalarTranslationVisitor.translateKeyExpression(indexPlan.getCommonPrimaryKey(), Objects.requireNonNull(indexPlan.getResultType().getInnerType())));
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitRecursiveLevelUnionPlan(@Nonnull RecordQueryRecursiveLevelUnionPlan recursiveUnionPlan) {
            return this.commonPrimaryKeyFromChildren(recursiveUnionPlan);
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitFirstOrDefaultPlan(@Nonnull RecordQueryFirstOrDefaultPlan firstOrDefaultPlan) {
            return this.primaryKeyFromSingleChild(firstOrDefaultPlan);
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitDefaultOnEmptyPlan(@Nonnull RecordQueryDefaultOnEmptyPlan defaultOnEmptyPlan) {
            return Optional.empty();
        }

        @Nonnull
        public Optional<List<Value>> visitInJoinPlan(@Nonnull RecordQueryInJoinPlan inJoinPlan) {
            return this.primaryKeyFromSingleChild(inJoinPlan);
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitFilterPlan(@Nonnull RecordQueryFilterPlan filterPlan) {
            return this.primaryKeyFromSingleChild(filterPlan);
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitUnorderedPrimaryKeyDistinctPlan(@Nonnull RecordQueryUnorderedPrimaryKeyDistinctPlan unorderedPrimaryKeyDistinctPlan) {
            return this.primaryKeyFromSingleChild(unorderedPrimaryKeyDistinctPlan);
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitUnionOnKeyExpressionPlan(@Nonnull RecordQueryUnionOnKeyExpressionPlan unionOnKeyExpressionPlan) {
            return this.commonPrimaryKeyFromChildren(unionOnKeyExpressionPlan);
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitTextIndexPlan(@Nonnull RecordQueryTextIndexPlan element) {
            return Optional.empty();
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitFetchFromPartialRecordPlan(@Nonnull RecordQueryFetchFromPartialRecordPlan fetchFromPartialRecordPlan) {
            return this.primaryKeyFromSingleChild(fetchFromPartialRecordPlan);
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitTypeFilterPlan(@Nonnull RecordQueryTypeFilterPlan typeFilterPlan) {
            return this.primaryKeyFromSingleChild(typeFilterPlan);
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitInUnionOnKeyExpressionPlan(@Nonnull RecordQueryInUnionOnKeyExpressionPlan inUnionOnKeyExpressionPlan) {
            return this.primaryKeyFromSingleChild(inUnionOnKeyExpressionPlan);
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitMultiIntersectionOnValuesPlan(@Nonnull RecordQueryMultiIntersectionOnValuesPlan element) {
            return Optional.empty();
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitInParameterJoinPlan(@Nonnull RecordQueryInParameterJoinPlan inParameterJoinPlan) {
            return this.visitInJoinPlan(inParameterJoinPlan);
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitFlatMapPlan(@Nonnull RecordQueryFlatMapPlan flatMapPlan) {
            if (flatMapPlan.isInheritOuterRecordProperties()) {
                return this.primaryKeyFromSingleQuantifier(flatMapPlan.getOuterQuantifier());
            }
            return Optional.empty();
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitStreamingAggregationPlan(@Nonnull RecordQueryStreamingAggregationPlan element) {
            return Optional.empty();
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitUnionOnValuesPlan(@Nonnull RecordQueryUnionOnValuesPlan unionOnValuesPlan) {
            return this.commonPrimaryKeyFromChildren(unionOnValuesPlan);
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitUnorderedUnionPlan(@Nonnull RecordQueryUnorderedUnionPlan unorderedUnionPlan) {
            return this.commonPrimaryKeyFromChildren(unorderedUnionPlan);
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitScanPlan(@Nonnull RecordQueryScanPlan scanPlan) {
            return scanPlan.getMatchCandidateMaybe().flatMap(WithPrimaryKeyMatchCandidate::getPrimaryKeyValuesMaybe);
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitInUnionOnValuesPlan(@Nonnull RecordQueryInUnionOnValuesPlan inUnionOnValuesPlan) {
            return this.primaryKeyFromSingleChild(inUnionOnValuesPlan);
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitComposedBitmapIndexQueryPlan(@Nonnull ComposedBitmapIndexQueryPlan element) {
            return Optional.empty();
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitDamPlan(@Nonnull RecordQueryDamPlan damPlan) {
            return this.primaryKeyFromSingleChild(damPlan);
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitSortPlan(@Nonnull RecordQuerySortPlan sortPlan) {
            return this.primaryKeyFromSingleChild(sortPlan);
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitRecursiveDfsJoinPlan(@Nonnull RecordQueryRecursiveDfsJoinPlan recursiveDfsJoinPlan) {
            return this.commonPrimaryKeyFromChildren(recursiveDfsJoinPlan);
        }

        @Override
        @Nonnull
        public Optional<List<Value>> visitDefault(@Nonnull RecordQueryPlan element) {
            return Optional.empty();
        }

        private Optional<List<Value>> primaryKeyFromSingleChild(@Nonnull RelationalExpression expression) {
            List<? extends Quantifier> quantifiers = expression.getQuantifiers();
            if (quantifiers.size() == 1) {
                return this.primaryKeyFromSingleQuantifier(Iterables.getOnlyElement(quantifiers));
            }
            throw new RecordCoreException("cannot compute property for expression", new Object[0]);
        }

        private Optional<List<Value>> primaryKeyFromSingleQuantifier(@Nonnull Quantifier quantifier) {
            return this.evaluateForReference(quantifier.getRangesOver());
        }

        @Nonnull
        private List<Optional<List<Value>>> primaryKeysFromChildren(@Nonnull RecordQueryPlan recordQueryPlan) {
            return recordQueryPlan.getQuantifiers().stream().filter(quantifier -> quantifier instanceof Quantifier.ForEach || quantifier instanceof Quantifier.Physical).map(quantifier -> this.evaluateForReference(quantifier.getRangesOver())).collect(ImmutableList.toImmutableList());
        }

        @Nonnull
        private Optional<List<Value>> commonPrimaryKeyFromChildren(@Nonnull RecordQueryPlan recordQueryPlan) {
            List<Optional<List<Value>>> primaryKeysFromChildren = this.primaryKeysFromChildren(recordQueryPlan);
            return PrimaryKeyProperty.commonPrimaryKeyValuesMaybeFromOptionals(primaryKeysFromChildren);
        }

        private Optional<List<Value>> evaluateForReference(@Nonnull Reference reference) {
            Collection<Optional<List<Value>>> memberPrimaryKeysCollection = reference.getPropertyForPlans(PRIMARY_KEY).values();
            return PrimaryKeyProperty.commonPrimaryKeyValuesMaybeFromOptionals(memberPrimaryKeysCollection);
        }
    }
}

