/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.properties;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.ExpressionProperty;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.SimpleExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.expressions.FullUnorderedScanExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalUnionExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RecursiveUnionExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.TypeFilterExpression;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFlatMapPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryScanPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedUnionPlan;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class RecordTypesProperty
implements ExpressionProperty<Set<String>> {
    private static final RecordTypesProperty RECORD_TYPES = new RecordTypesProperty();

    private RecordTypesProperty() {
    }

    @Nonnull
    public RecordTypesVisitor createVisitor() {
        return new RecordTypesVisitor(Optional.empty());
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Nonnull
    public Set<String> evaluate(@Nonnull Reference reference) {
        return Objects.requireNonNull(reference.acceptVisitor(this.createVisitor()));
    }

    @Nonnull
    public Set<String> evaluate(@Nonnull RelationalExpression expression) {
        return Objects.requireNonNull(expression.acceptVisitor(this.createVisitor()));
    }

    @Nonnull
    public static RecordTypesProperty recordTypes() {
        return RECORD_TYPES;
    }

    public static class RecordTypesVisitor
    implements SimpleExpressionVisitor<Set<String>> {
        @Nonnull
        private final Optional<Quantifiers.AliasResolver> aliasResolverOptional;

        public RecordTypesVisitor(@Nonnull Quantifiers.AliasResolver aliasResolver) {
            this(Optional.of(aliasResolver));
        }

        public RecordTypesVisitor(@Nonnull Optional<Quantifiers.AliasResolver> aliasResolverOptional) {
            this.aliasResolverOptional = aliasResolverOptional;
        }

        @Override
        @Nonnull
        public Set<String> evaluateAtExpression(@Nonnull RelationalExpression expression, @Nonnull List<Set<String>> childResults) {
            if (expression instanceof RecordQueryScanPlan) {
                Set<String> recordTypesFromExpression = ((RecordQueryScanPlan)expression).getRecordTypes();
                return recordTypesFromExpression == null ? ImmutableSet.of() : recordTypesFromExpression;
            }
            if (expression instanceof FullUnorderedScanExpression) {
                return ((FullUnorderedScanExpression)expression).getRecordTypes();
            }
            if (expression instanceof RecordQueryIndexPlan) {
                return ((RecordQueryIndexPlan)expression).getMatchCandidateMaybe().map(MatchCandidate::getQueriedRecordTypeNames).orElse(ImmutableSet.of());
            }
            if (expression instanceof TypeFilterExpression) {
                return Sets.filter(childResults.get(0), ((TypeFilterExpression)expression).getRecordTypes()::contains);
            }
            if (childResults.isEmpty()) {
                HashSet<String> recordTypes = Sets.newHashSet();
                for (CorrelationIdentifier alias : expression.getCorrelatedTo()) {
                    Set quantifiers = this.aliasResolverOptional.map(aliasResolver -> aliasResolver.resolveCorrelationAlias(expression, alias)).orElse(ImmutableSet.of());
                    for (Quantifier quantifier : quantifiers) {
                        recordTypes.addAll((Collection<String>)Objects.requireNonNull(quantifier.getRangesOver().acceptVisitor(this)));
                    }
                }
                if (this.aliasResolverOptional.isPresent() && recordTypes.isEmpty()) {
                    throw new RecordCoreException("tried to find record types for a relational expression with no children but case wasn't handled", new Object[0]);
                }
                return recordTypes;
            }
            int nonNullChildResult = 0;
            Set<String> firstChildResult = null;
            for (Set<String> result : childResults) {
                if (result == null) continue;
                ++nonNullChildResult;
                if (firstChildResult != null) continue;
                firstChildResult = result;
            }
            if (nonNullChildResult == 1) {
                return firstChildResult;
            }
            if (expression instanceof RecordQueryUnionPlan || expression instanceof RecordQueryUnorderedUnionPlan || expression instanceof RecordQueryIntersectionPlan || expression instanceof LogicalUnionExpression || expression instanceof RecursiveUnionExpression || expression instanceof SelectExpression || expression instanceof RecordQueryFlatMapPlan) {
                HashSet<String> union = new HashSet<String>();
                for (Set<String> childResulSet : childResults) {
                    union.addAll(childResulSet);
                }
                return union;
            }
            throw new RecordCoreException("tried to find record types for a relational expression with multiple relational children, but no combiner was specified", new Object[0]);
        }

        @Override
        @Nonnull
        public Set<String> evaluateAtRef(@Nonnull Reference ref, @Nonnull List<Set<String>> memberResults) {
            HashSet<String> union = new HashSet<String>();
            for (Set<String> resultSet : memberResults) {
                union.addAll(resultSet);
            }
            return union;
        }
    }
}

