/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.properties;

import com.apple.foundationdb.record.query.combinatorics.PartiallyOrderedSet;
import com.apple.foundationdb.record.query.plan.cascades.ExpressionProperty;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.SimpleExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ReferencesAndDependenciesProperty
implements ExpressionProperty<PartiallyOrderedSet<Reference>> {
    private static final ReferencesAndDependenciesProperty REFERENCES_AND_DEPENDENCIES = new ReferencesAndDependenciesProperty();

    private ReferencesAndDependenciesProperty() {
    }

    @Nonnull
    public ReferencesAndDependenciesVisitor createVisitor() {
        return new ReferencesAndDependenciesVisitor();
    }

    @Nonnull
    public PartiallyOrderedSet<Reference> evaluate(@Nonnull Iterable<? extends Reference> references) {
        ImmutableList<PartiallyOrderedSet<Reference>> refResults = Streams.stream(references).map(this::evaluate).collect(ImmutableList.toImmutableList());
        return ReferencesAndDependenciesProperty.mergePartialOrders(refResults);
    }

    @Nonnull
    public PartiallyOrderedSet<Reference> evaluate(@Nonnull Reference reference) {
        return Objects.requireNonNull(reference.acceptVisitor(this.createVisitor()));
    }

    @Nonnull
    public PartiallyOrderedSet<Reference> evaluate(@Nonnull RelationalExpression expression) {
        return Objects.requireNonNull(expression.acceptVisitor(this.createVisitor()));
    }

    @Nonnull
    public static ReferencesAndDependenciesProperty referencesAndDependencies() {
        return REFERENCES_AND_DEPENDENCIES;
    }

    @Nonnull
    private static PartiallyOrderedSet<Reference> mergePartialOrders(@Nonnull Iterable<PartiallyOrderedSet<Reference>> partialOrders) {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        ImmutableSetMultimap.Builder dependencyMapBuilder = ImmutableSetMultimap.builder();
        for (PartiallyOrderedSet<Reference> partialOrder : partialOrders) {
            setBuilder.addAll(partialOrder.getSet());
            dependencyMapBuilder.putAll((Iterable)partialOrder.getDependencyMap().entries());
        }
        return PartiallyOrderedSet.of(setBuilder.build(), dependencyMapBuilder.build());
    }

    public static class ReferencesAndDependenciesVisitor
    implements SimpleExpressionVisitor<PartiallyOrderedSet<Reference>> {
        @Override
        @Nonnull
        public PartiallyOrderedSet<Reference> evaluateAtExpression(@Nonnull RelationalExpression expression, @Nonnull List<PartiallyOrderedSet<Reference>> childResults) {
            return ReferencesAndDependenciesProperty.mergePartialOrders(childResults);
        }

        @Override
        @Nonnull
        public PartiallyOrderedSet<Reference> evaluateAtRef(@Nonnull Reference ref, @Nonnull List<PartiallyOrderedSet<Reference>> memberResults) {
            PartiallyOrderedSet<Reference> membersPartialOrder = ReferencesAndDependenciesProperty.mergePartialOrders(memberResults);
            ImmutableSet<Reference> membersSet = membersPartialOrder.getSet();
            ImmutableSetMultimap<Reference, Reference> membersDependencyMap = membersPartialOrder.getDependencyMap();
            ImmutableSet.Builder setBuilder = ImmutableSet.builder();
            ImmutableSetMultimap.Builder dependencyMapBuilder = ImmutableSetMultimap.builder();
            setBuilder.addAll(membersSet);
            setBuilder.add(ref);
            dependencyMapBuilder.putAll((Iterable)membersDependencyMap.entries());
            for (RelationalExpression member : ref.getAllMemberExpressions()) {
                for (Quantifier quantifier : member.getQuantifiers()) {
                    dependencyMapBuilder.put(ref, quantifier.getRangesOver());
                }
            }
            return PartiallyOrderedSet.of(setBuilder.build(), dependencyMapBuilder.build());
        }
    }
}

