/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.properties;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.plan.bitmap.ComposedBitmapIndexQueryPlan;
import com.apple.foundationdb.record.query.plan.cascades.ExpressionProperty;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionVisitor;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryAggregateIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryComparatorPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryCoveringIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryDefaultOnEmptyPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryDeletePlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryExplodePlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFirstOrDefaultPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFlatMapPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInComparandJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInParameterJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInUnionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInUnionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInValuesJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInsertPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryLoadByKeysPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryMapPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryMultiIntersectionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanVisitor;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPredicatesFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryRangePlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryRecursiveDfsJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryRecursiveLevelUnionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryScanPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryScoreForRankPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQuerySelectorPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryStreamingAggregationPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTableFunctionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTextIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTypeFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedDistinctPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedPrimaryKeyDistinctPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedUnionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUpdatePlan;
import com.apple.foundationdb.record.query.plan.plans.TempTableInsertPlan;
import com.apple.foundationdb.record.query.plan.plans.TempTableScanPlan;
import com.apple.foundationdb.record.query.plan.sorting.RecordQueryDamPlan;
import com.apple.foundationdb.record.query.plan.sorting.RecordQuerySortPlan;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

public class StoredRecordProperty
implements ExpressionProperty<Boolean> {
    private static final StoredRecordProperty STORED_RECORD = new StoredRecordProperty();

    private StoredRecordProperty() {
    }

    @Override
    @Nonnull
    public RelationalExpressionVisitor<Boolean> createVisitor() {
        return ExpressionProperty.toExpressionVisitor(new StoredRecordVisitor());
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public boolean evaluate(@Nonnull Reference reference) {
        return this.evaluate(reference.getOnlyElementAsPlan());
    }

    public boolean evaluate(@Nonnull RecordQueryPlan recordQueryPlan) {
        return this.createVisitor().visit(recordQueryPlan);
    }

    @Nonnull
    public static StoredRecordProperty storedRecord() {
        return STORED_RECORD;
    }

    public static class StoredRecordVisitor
    implements RecordQueryPlanVisitor<Boolean> {
        @Override
        @Nonnull
        public Boolean visitUpdatePlan(@Nonnull RecordQueryUpdatePlan element) {
            return true;
        }

        @Override
        @Nonnull
        public Boolean visitPredicatesFilterPlan(@Nonnull RecordQueryPredicatesFilterPlan predicatesFilterPlan) {
            return this.storedRecordsFromSingleChild(predicatesFilterPlan);
        }

        @Override
        @Nonnull
        public Boolean visitLoadByKeysPlan(@Nonnull RecordQueryLoadByKeysPlan element) {
            return true;
        }

        @Override
        @Nonnull
        public Boolean visitInValuesJoinPlan(@Nonnull RecordQueryInValuesJoinPlan inValuesJoinPlan) {
            return this.visitInJoinPlan(inValuesJoinPlan);
        }

        @Override
        @Nonnull
        public Boolean visitInComparandJoinPlan(@Nonnull RecordQueryInComparandJoinPlan inComparandJoinPlan) {
            return this.visitInJoinPlan(inComparandJoinPlan);
        }

        @Override
        @Nonnull
        public Boolean visitAggregateIndexPlan(@Nonnull RecordQueryAggregateIndexPlan element) {
            return false;
        }

        @Override
        @Nonnull
        public Boolean visitCoveringIndexPlan(@Nonnull RecordQueryCoveringIndexPlan element) {
            return true;
        }

        @Override
        @Nonnull
        public Boolean visitDeletePlan(@Nonnull RecordQueryDeletePlan element) {
            return true;
        }

        @Override
        @Nonnull
        public Boolean visitIntersectionOnKeyExpressionPlan(@Nonnull RecordQueryIntersectionOnKeyExpressionPlan element) {
            return true;
        }

        @Override
        @Nonnull
        public Boolean visitMapPlan(@Nonnull RecordQueryMapPlan mapPlan) {
            return this.storedRecordsFromSingleChild(mapPlan);
        }

        @Override
        @Nonnull
        public Boolean visitComparatorPlan(@Nonnull RecordQueryComparatorPlan comparatorPlan) {
            return this.storedRecordsFromChildren(comparatorPlan).stream().allMatch(s2 -> s2);
        }

        @Override
        @Nonnull
        public Boolean visitUnorderedDistinctPlan(@Nonnull RecordQueryUnorderedDistinctPlan element) {
            return true;
        }

        @Override
        @Nonnull
        public Boolean visitSelectorPlan(@Nonnull RecordQuerySelectorPlan selectorPlan) {
            return this.storedRecordsFromChildren(selectorPlan).stream().allMatch(s2 -> s2);
        }

        @Override
        @Nonnull
        public Boolean visitRangePlan(@Nonnull RecordQueryRangePlan element) {
            return false;
        }

        @Override
        @Nonnull
        public Boolean visitTempTableScanPlan(@Nonnull TempTableScanPlan element) {
            return false;
        }

        @Override
        @Nonnull
        public Boolean visitExplodePlan(@Nonnull RecordQueryExplodePlan element) {
            return false;
        }

        @Override
        @Nonnull
        public Boolean visitInsertPlan(@Nonnull RecordQueryInsertPlan element) {
            return true;
        }

        @Override
        @Nonnull
        public Boolean visitTableFunctionPlan(@Nonnull RecordQueryTableFunctionPlan element) {
            return false;
        }

        @Override
        @Nonnull
        public Boolean visitTempTableInsertPlan(@Nonnull TempTableInsertPlan element) {
            return false;
        }

        @Override
        @Nonnull
        public Boolean visitIntersectionOnValuesPlan(@Nonnull RecordQueryIntersectionOnValuesPlan intersectionOnValuesPlan) {
            return this.storedRecordsFromChildren(intersectionOnValuesPlan).stream().allMatch(s2 -> s2);
        }

        @Override
        @Nonnull
        public Boolean visitScoreForRankPlan(@Nonnull RecordQueryScoreForRankPlan scoreForRankPlan) {
            return this.storedRecordsFromSingleChild(scoreForRankPlan);
        }

        @Override
        @Nonnull
        public Boolean visitIndexPlan(@Nonnull RecordQueryIndexPlan element) {
            return true;
        }

        @Override
        @Nonnull
        public Boolean visitRecursiveLevelUnionPlan(@Nonnull RecordQueryRecursiveLevelUnionPlan recursiveUnionPlan) {
            return this.storedRecordsFromChildren(recursiveUnionPlan).stream().allMatch(s2 -> s2);
        }

        @Override
        @Nonnull
        public Boolean visitFirstOrDefaultPlan(@Nonnull RecordQueryFirstOrDefaultPlan element) {
            return false;
        }

        @Override
        @Nonnull
        public Boolean visitDefaultOnEmptyPlan(@Nonnull RecordQueryDefaultOnEmptyPlan element) {
            return false;
        }

        @Nonnull
        public Boolean visitInJoinPlan(@Nonnull RecordQueryInJoinPlan inJoinPlan) {
            return this.storedRecordsFromSingleChild(inJoinPlan);
        }

        @Override
        @Nonnull
        public Boolean visitFilterPlan(@Nonnull RecordQueryFilterPlan filterPlan) {
            return this.storedRecordsFromSingleChild(filterPlan);
        }

        @Override
        @Nonnull
        public Boolean visitUnorderedPrimaryKeyDistinctPlan(@Nonnull RecordQueryUnorderedPrimaryKeyDistinctPlan element) {
            return true;
        }

        @Override
        @Nonnull
        public Boolean visitUnionOnKeyExpressionPlan(@Nonnull RecordQueryUnionOnKeyExpressionPlan element) {
            return true;
        }

        @Override
        @Nonnull
        public Boolean visitTextIndexPlan(@Nonnull RecordQueryTextIndexPlan element) {
            return true;
        }

        @Override
        @Nonnull
        public Boolean visitFetchFromPartialRecordPlan(@Nonnull RecordQueryFetchFromPartialRecordPlan element) {
            return true;
        }

        @Override
        @Nonnull
        public Boolean visitTypeFilterPlan(@Nonnull RecordQueryTypeFilterPlan typeFilterPlan) {
            return this.storedRecordsFromSingleChild(typeFilterPlan);
        }

        @Override
        @Nonnull
        public Boolean visitInUnionOnKeyExpressionPlan(@Nonnull RecordQueryInUnionOnKeyExpressionPlan element) {
            return true;
        }

        @Override
        @Nonnull
        public Boolean visitMultiIntersectionOnValuesPlan(@Nonnull RecordQueryMultiIntersectionOnValuesPlan element) {
            return false;
        }

        @Override
        @Nonnull
        public Boolean visitInParameterJoinPlan(@Nonnull RecordQueryInParameterJoinPlan inParameterJoinPlan) {
            return this.visitInJoinPlan(inParameterJoinPlan);
        }

        @Override
        @Nonnull
        public Boolean visitFlatMapPlan(@Nonnull RecordQueryFlatMapPlan flatMapPlan) {
            if (flatMapPlan.isInheritOuterRecordProperties()) {
                return this.storedRecordsFromSingleQuantifier(flatMapPlan.getOuterQuantifier());
            }
            return false;
        }

        @Override
        @Nonnull
        public Boolean visitStreamingAggregationPlan(@Nonnull RecordQueryStreamingAggregationPlan element) {
            return false;
        }

        @Override
        @Nonnull
        public Boolean visitUnionOnValuesPlan(@Nonnull RecordQueryUnionOnValuesPlan unionOnValuesPlan) {
            return this.storedRecordsFromChildren(unionOnValuesPlan).stream().allMatch(s2 -> s2);
        }

        @Override
        @Nonnull
        public Boolean visitUnorderedUnionPlan(@Nonnull RecordQueryUnorderedUnionPlan unorderedUnionPlan) {
            return this.storedRecordsFromChildren(unorderedUnionPlan).stream().allMatch(s2 -> s2);
        }

        @Override
        @Nonnull
        public Boolean visitScanPlan(@Nonnull RecordQueryScanPlan element) {
            return true;
        }

        @Override
        @Nonnull
        public Boolean visitInUnionOnValuesPlan(@Nonnull RecordQueryInUnionOnValuesPlan inUnionOnValuesPlan) {
            return this.storedRecordsFromSingleChild(inUnionOnValuesPlan);
        }

        @Override
        @Nonnull
        public Boolean visitComposedBitmapIndexQueryPlan(@Nonnull ComposedBitmapIndexQueryPlan element) {
            return true;
        }

        @Override
        @Nonnull
        public Boolean visitDamPlan(@Nonnull RecordQueryDamPlan damPlan) {
            return this.storedRecordsFromSingleChild(damPlan);
        }

        @Override
        @Nonnull
        public Boolean visitSortPlan(@Nonnull RecordQuerySortPlan sortPlan) {
            return this.storedRecordsFromSingleChild(sortPlan);
        }

        @Override
        @Nonnull
        public Boolean visitRecursiveDfsJoinPlan(@Nonnull RecordQueryRecursiveDfsJoinPlan recursiveDfsJoinPlan) {
            return this.storedRecordsFromChildren(recursiveDfsJoinPlan).stream().allMatch(s2 -> s2);
        }

        @Override
        @Nonnull
        public Boolean visitDefault(@Nonnull RecordQueryPlan element) {
            return true;
        }

        private boolean storedRecordsFromSingleChild(@Nonnull RelationalExpression expression) {
            List<? extends Quantifier> quantifiers = expression.getQuantifiers();
            if (quantifiers.size() == 1) {
                return this.storedRecordsFromSingleQuantifier(Iterables.getOnlyElement(quantifiers));
            }
            throw new RecordCoreException("cannot compute property for expression", new Object[0]);
        }

        private boolean storedRecordsFromSingleQuantifier(@Nonnull Quantifier quantifier) {
            return this.evaluateForReference(quantifier.getRangesOver());
        }

        @Nonnull
        private List<Boolean> storedRecordsFromChildren(@Nonnull RelationalExpression expression) {
            return expression.getQuantifiers().stream().map(quantifier -> {
                if (quantifier instanceof Quantifier.Existential) {
                    return true;
                }
                return this.evaluateForReference(quantifier.getRangesOver());
            }).collect(ImmutableList.toImmutableList());
        }

        private boolean evaluateForReference(@Nonnull Reference reference) {
            Collection<Boolean> memberStoredRecordsCollection = reference.getPropertyForPlans(STORED_RECORD).values();
            return memberStoredRecordsCollection.stream().allMatch(d -> d);
        }
    }
}

