/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.properties;

import com.apple.foundationdb.record.query.plan.cascades.ExpressionProperty;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.SimpleExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.TypeFilterExpression;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class TypeFilterCountProperty
implements ExpressionProperty<Integer> {
    private static final TypeFilterCountProperty TYPE_FILTER_COUNT = new TypeFilterCountProperty();

    private TypeFilterCountProperty() {
    }

    @Nonnull
    public TypeFilterCountVisitor createVisitor() {
        return new TypeFilterCountVisitor();
    }

    public int evaluate(@Nonnull Reference reference) {
        return Objects.requireNonNull(reference.acceptVisitor(this.createVisitor()));
    }

    public int evaluate(@Nonnull RelationalExpression expression) {
        return Objects.requireNonNull(expression.acceptVisitor(this.createVisitor()));
    }

    @Nonnull
    public static TypeFilterCountProperty typeFilterCount() {
        return TYPE_FILTER_COUNT;
    }

    public static class TypeFilterCountVisitor
    implements SimpleExpressionVisitor<Integer> {
        @Override
        @Nonnull
        public Integer evaluateAtExpression(@Nonnull RelationalExpression expression, @Nonnull List<Integer> childResults) {
            int total = expression instanceof TypeFilterExpression ? ((TypeFilterExpression)expression).getRecordTypes().size() : 0;
            for (Integer childCount : childResults) {
                if (childCount == null) continue;
                total += childCount.intValue();
            }
            return total;
        }

        @Override
        @Nonnull
        public Integer evaluateAtRef(@Nonnull Reference ref, @Nonnull List<Integer> memberResults) {
            int min2 = Integer.MAX_VALUE;
            for (int memberResult : memberResults) {
                if (memberResult >= min2) continue;
                min2 = memberResult;
            }
            return min2;
        }
    }
}

