/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.properties;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.cascades.ExpressionProperty;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.SimpleExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryAggregateIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryCoveringIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithComparisons;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithIndex;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryScanPlan;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class UnmatchedFieldsCountProperty
implements ExpressionProperty<Integer> {
    private static final UnmatchedFieldsCountProperty UNMATCHED_FIELDS_COUNT = new UnmatchedFieldsCountProperty();

    private UnmatchedFieldsCountProperty() {
    }

    @Nonnull
    public UnmatchedFieldsCountVisitor createVisitor() {
        return new UnmatchedFieldsCountVisitor();
    }

    public int evaluate(@Nonnull Reference reference) {
        return Objects.requireNonNull(reference.acceptVisitor(this.createVisitor()));
    }

    public int evaluate(@Nonnull RelationalExpression expression) {
        return Objects.requireNonNull(expression.acceptVisitor(this.createVisitor()));
    }

    @Nonnull
    public static UnmatchedFieldsCountProperty unmatchedFieldsCount() {
        return UNMATCHED_FIELDS_COUNT;
    }

    public static class UnmatchedFieldsCountVisitor
    implements SimpleExpressionVisitor<Integer> {
        @Override
        @Nonnull
        public Integer evaluateAtExpression(@Nonnull RelationalExpression expression, @Nonnull List<Integer> childResults) {
            int total = 0;
            for (Integer result : childResults) {
                if (result == null) continue;
                total += result.intValue();
            }
            if (expression instanceof RecordQueryCoveringIndexPlan) {
                expression = ((RecordQueryCoveringIndexPlan)expression).getIndexPlan();
            }
            if (expression instanceof RecordQueryAggregateIndexPlan) {
                expression = ((RecordQueryAggregateIndexPlan)expression).getIndexPlan();
            }
            if (expression instanceof RecordQueryPlanWithComparisons) {
                int columnSize;
                ScanComparisons comparisons = ((RecordQueryPlanWithComparisons)expression).getScanComparisons();
                int numComparisons = comparisons.getEqualitySize() + (comparisons.isEquality() ? 0 : 1);
                if (expression instanceof RecordQueryPlanWithIndex) {
                    Optional<? extends MatchCandidate> matchCandidateOptional = ((RecordQueryPlanWithIndex)expression).getMatchCandidateMaybe();
                    MatchCandidate matchCandidate = matchCandidateOptional.orElseThrow(() -> new RecordCoreException("expected match candidate to be present", new Object[0]));
                    columnSize = matchCandidate.getSargableAliases().size();
                } else if (expression instanceof RecordQueryScanPlan) {
                    RecordQueryScanPlan scanPlan = (RecordQueryScanPlan)expression;
                    KeyExpression primaryKey = Objects.requireNonNull(scanPlan.getCommonPrimaryKey());
                    columnSize = primaryKey.getColumnSize();
                } else {
                    throw new RecordCoreException("unhandled plan with comparisons: can't find key expression", new Object[0]);
                }
                return total + columnSize - numComparisons;
            }
            return total;
        }

        @Override
        @Nonnull
        public Integer evaluateAtRef(@Nonnull Reference ref, @Nonnull List<Integer> memberResults) {
            int min2 = Integer.MAX_VALUE;
            for (Integer memberResult : memberResults) {
                if (memberResult == null || memberResult >= min2) continue;
                min2 = memberResult;
            }
            return min2;
        }
    }
}

