/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.properties;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.ExpressionProperty;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.SimpleExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class UsedTypesProperty
implements ExpressionProperty<Set<Type>> {
    private static final UsedTypesProperty USED_TYPES = new UsedTypesProperty();

    private UsedTypesProperty() {
    }

    @Nonnull
    public UsedTypesVisitor createVisitor() {
        return new UsedTypesVisitor();
    }

    public Set<Type> evaluate(@Nonnull Reference ref) {
        return Objects.requireNonNull(ref.acceptVisitor(this.createVisitor()));
    }

    public Set<Type> evaluate(@Nonnull RelationalExpression expression) {
        return Objects.requireNonNull(expression.acceptVisitor(this.createVisitor()));
    }

    @Nonnull
    public static UsedTypesProperty usedTypes() {
        return USED_TYPES;
    }

    public static class UsedTypesVisitor
    implements SimpleExpressionVisitor<Set<Type>> {
        @Override
        @Nonnull
        public Set<Type> evaluateAtExpression(@Nonnull RelationalExpression expression, @Nonnull List<Set<Type>> childResults) {
            ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
            for (Set<Type> childResult : childResults) {
                resultBuilder.addAll(childResult);
            }
            resultBuilder.addAll(expression.getDynamicTypes());
            return resultBuilder.build();
        }

        @Override
        @Nonnull
        public Set<Type> evaluateAtRef(@Nonnull Reference ref, @Nonnull List<Set<Type>> memberResults) {
            return UsedTypesVisitor.unionTypes(memberResults);
        }

        @Nonnull
        private static Set<Type> unionTypes(@Nonnull Collection<Set<Type>> types) {
            ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
            for (Set<Type> childResult : types) {
                resultBuilder.addAll(childResult);
            }
            return resultBuilder.build();
        }
    }
}

