/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.combinatorics.ChooseK;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRange;
import com.apple.foundationdb.record.query.plan.cascades.Compensation;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.GroupByMappings;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentitySet;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.MatchInfo;
import com.apple.foundationdb.record.query.plan.cascades.MatchPartition;
import com.apple.foundationdb.record.query.plan.cascades.Memoizer;
import com.apple.foundationdb.record.query.plan.cascades.Ordering;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.PlanContext;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.ReferencedFieldsConstraint;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrdering;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrderingConstraint;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.predicates.Placeholder;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.properties.CardinalitiesProperty;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.MaxMatchMap;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.PullUp;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.RegularTranslationMap;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedPrimaryKeyDistinctPlan;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.apple.foundationdb.record.util.pair.Pair;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.EXPERIMENTAL)
public abstract class AbstractDataAccessRule
extends CascadesRule<MatchPartition> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDataAccessRule.class);
    private final BindingMatcher<PartialMatch> completeMatchMatcher;
    private final BindingMatcher<? extends RelationalExpression> expressionMatcher;

    protected AbstractDataAccessRule(@Nonnull BindingMatcher<MatchPartition> rootMatcher, @Nonnull BindingMatcher<PartialMatch> completeMatchMatcher, @Nonnull BindingMatcher<? extends RelationalExpression> expressionMatcher) {
        super(rootMatcher, ImmutableSet.of(ReferencedFieldsConstraint.REFERENCED_FIELDS, RequestedOrderingConstraint.REQUESTED_ORDERING));
        this.completeMatchMatcher = completeMatchMatcher;
        this.expressionMatcher = expressionMatcher;
    }

    @Nonnull
    protected BindingMatcher<PartialMatch> getCompleteMatchMatcher() {
        return this.completeMatchMatcher;
    }

    @Nonnull
    protected BindingMatcher<? extends RelationalExpression> getExpressionMatcher() {
        return this.expressionMatcher;
    }

    @Override
    public void onMatch(@Nonnull CascadesRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        List<PartialMatch> completeMatches = bindings.getAll(this.getCompleteMatchMatcher());
        if (completeMatches.isEmpty()) {
            return;
        }
        RelationalExpression expression = bindings.get(this.getExpressionMatcher());
        Optional<Set<RequestedOrdering>> requestedOrderingsOptional = call.getPlannerConstraintMaybe(RequestedOrderingConstraint.REQUESTED_ORDERING);
        if (requestedOrderingsOptional.isEmpty()) {
            return;
        }
        Set<RequestedOrdering> requestedOrderings = requestedOrderingsOptional.get();
        Map<CorrelationIdentifier, Quantifier> aliasToQuantifierMap = Quantifiers.aliasToQuantifierMap(expression.getQuantifiers());
        Set<CorrelationIdentifier> aliases = aliasToQuantifierMap.keySet();
        LinkedHashMap matchPartitionByMatchAliasMap = completeMatches.stream().flatMap(match -> {
            Set<CorrelationIdentifier> compensatedAliases = match.getCompensatedAliases();
            if (!compensatedAliases.containsAll(aliases)) {
                return Stream.empty();
            }
            Set matchedForEachAliases = compensatedAliases.stream().filter(matchedAlias -> Objects.requireNonNull((Quantifier)aliasToQuantifierMap.get(matchedAlias)) instanceof Quantifier.ForEach).collect(ImmutableSet.toImmutableSet());
            if (matchedForEachAliases.size() == 1) {
                return Stream.of(NonnullPair.of((CorrelationIdentifier)Iterables.getOnlyElement(matchedForEachAliases), match));
            }
            return Stream.empty();
        }).collect(Collectors.groupingBy(Pair::getLeft, LinkedHashMap::new, Collectors.mapping(Pair::getRight, ImmutableList.toImmutableList())));
        for (Map.Entry matchPartitionByMatchAliasEntry : matchPartitionByMatchAliasMap.entrySet()) {
            ImmutableList matchPartitionForMatchedAlias = (ImmutableList)matchPartitionByMatchAliasEntry.getValue();
            HashMap matchPartitionsForAliasesByPredicates = matchPartitionForMatchedAlias.stream().collect(Collectors.groupingBy(match -> new LinkedIdentitySet<QueryPredicate>(match.getRegularMatchInfo().getPredicateMap().keySet()), HashMap::new, ImmutableList.toImmutableList()));
            for (Map.Entry matchPartitionEntry : matchPartitionsForAliasesByPredicates.entrySet()) {
                ImmutableList matchPartition = (ImmutableList)matchPartitionEntry.getValue();
                Set<? extends RelationalExpression> dataAccessExpressions = this.dataAccessForMatchPartition(call, requestedOrderings, matchPartition);
                call.yieldMixedUnknownExpressions(dataAccessExpressions);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Set<? extends RelationalExpression> dataAccessForMatchPartition(@Nonnull CascadesRuleCall call, @Nonnull Set<RequestedOrdering> requestedOrderings, @Nonnull Collection<? extends PartialMatch> matchPartition) {
        Verify.verify(!matchPartition.isEmpty());
        List<Vectored<SingleMatchedAccess>> bestMaximumCoverageMatches = AbstractDataAccessRule.maximumCoverageMatches(matchPartition, requestedOrderings);
        if (bestMaximumCoverageMatches.isEmpty()) {
            return LinkedIdentitySet.of(new RelationalExpression[0]);
        }
        if (logger.isTraceEnabled()) {
            for (Vectored<SingleMatchedAccess> bestMaximumCoverageMatch : bestMaximumCoverageMatches) {
                logger.trace("single access = {}", (Object)bestMaximumCoverageMatch.getElement());
            }
        }
        Map<PartialMatch, RecordQueryPlan> bestMatchToPlanMap = AbstractDataAccessRule.createScansForMatches(call.getContext(), call, bestMaximumCoverageMatches);
        LinkedHashMap<BitSet, IntersectionInfo> intersectionInfoMap = Maps.newLinkedHashMap();
        for (Vectored<SingleMatchedAccess> bestMatchWithIndex : bestMaximumCoverageMatches) {
            SingleMatchedAccess bestMatch = bestMatchWithIndex.getElement();
            Optional<RelationalExpression> optional = AbstractDataAccessRule.applyCompensationForSingleDataAccessMaybe(call, bestMatch, bestMatchToPlanMap.get(bestMatch.getPartialMatch()));
            AbstractDataAccessRule.addToIntersectionInfoMap(intersectionInfoMap, bestMatchWithIndex, optional);
        }
        if (bestMaximumCoverageMatches.size() == 1) {
            return AbstractDataAccessRule.intersectionInfoMapToExpressions(intersectionInfoMap);
        }
        Map<PartialMatch, RecordQueryPlan> bestMatchToDistinctPlanMap = AbstractDataAccessRule.distinctMatchToScanMap(call, bestMatchToPlanMap);
        BitSet[] sieveBitMatrix = bestMaximumCoverageMatches.size() > 2 ? AbstractDataAccessRule.newSquareBitMatrix(bestMaximumCoverageMatches.size()) : null;
        for (List list : ChooseK.chooseK(bestMaximumCoverageMatches, 2)) {
            Verify.verify(list.size() == 2);
            IntersectionResult binaryIntersections = this.createIntersectionAndCompensation(call, intersectionInfoMap, bestMatchToDistinctPlanMap, list, requestedOrderings);
            if (logger.isTraceEnabled()) {
                logger.trace("binary intersection result = {}", (Object)binaryIntersections);
            }
            if (binaryIntersections.hasViableIntersection()) {
                AbstractDataAccessRule.updateIntersectionInfoMap(intersectionInfoMap, list, binaryIntersections);
                continue;
            }
            if (sieveBitMatrix == null) continue;
            int i = ((Vectored)list.get(0)).getPosition();
            int j = ((Vectored)list.get(1)).getPosition();
            sieveBitMatrix[i].set(j);
            sieveBitMatrix[j].set(i);
        }
        if (bestMaximumCoverageMatches.size() > 2) {
            void var10_14;
            Objects.requireNonNull(sieveBitMatrix);
            BitSet[] checkBitMatrix = AbstractDataAccessRule.newSquareBitMatrix(bestMaximumCoverageMatches.size());
            boolean bl = false;
            int numDiscardedCombinations = 0;
            for (int k = 3; k < bestMaximumCoverageMatches.size() + 1; ++k) {
                boolean hasCommonOrderingForK = false;
                for (List list : ChooseK.chooseK(bestMaximumCoverageMatches, k)) {
                    ++var10_14;
                    call.emitEvent(Debugger.Location.ALL_INTERSECTION_COMBINATIONS);
                    AbstractDataAccessRule.setAll(checkBitMatrix);
                    BitSet membership = new BitSet(bestMaximumCoverageMatches.size());
                    for (Vectored singleMatchedAccessVectored : list) {
                        membership.set(singleMatchedAccessVectored.getPosition());
                    }
                    int position = membership.nextClearBit(0);
                    while (position >= 0 && position < bestMaximumCoverageMatches.size()) {
                        AbstractDataAccessRule.clearRowAndColumnAtPosition(checkBitMatrix, position);
                        position = membership.nextClearBit(position + 1);
                    }
                    if (!AbstractDataAccessRule.hasCommonOrdering(sieveBitMatrix, checkBitMatrix)) {
                        ++numDiscardedCombinations;
                        call.emitEvent(Debugger.Location.DISCARDED_INTERSECTION_COMBINATIONS);
                        continue;
                    }
                    IntersectionResult intersectionResult = this.createIntersectionAndCompensation(call, intersectionInfoMap, bestMatchToDistinctPlanMap, list, requestedOrderings);
                    if (logger.isTraceEnabled()) {
                        logger.trace("intersection result = {}", (Object)intersectionResult);
                    }
                    if (!intersectionResult.hasViableIntersection()) continue;
                    hasCommonOrderingForK = true;
                    AbstractDataAccessRule.updateIntersectionInfoMap(intersectionInfoMap, list, intersectionResult);
                }
                if (!hasCommonOrderingForK) break;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("bit matrix sieve discarded {}/{} combinations", (Object)numDiscardedCombinations, (Object)((int)var10_14));
            }
        }
        return AbstractDataAccessRule.intersectionInfoMapToExpressions(intersectionInfoMap);
    }

    @Nonnull
    private static BitSet[] newSquareBitMatrix(int size) {
        BitSet[] matrix = new BitSet[size];
        for (int row = 0; row < size; ++row) {
            matrix[row] = new BitSet(size);
        }
        return matrix;
    }

    private static void setAll(@Nonnull BitSet[] matrix) {
        for (BitSet bitSet : matrix) {
            bitSet.set(0, matrix.length);
        }
    }

    private static void clearRowAndColumnAtPosition(@Nonnull BitSet[] matrix, int position) {
        for (int i = 0; i < matrix.length; ++i) {
            BitSet bitSet = matrix[i];
            if (i == position) {
                bitSet.clear();
                continue;
            }
            bitSet.clear(position);
        }
    }

    private static boolean hasCommonOrdering(@Nonnull BitSet[] sieveBitMatrix, @Nonnull BitSet[] checkMatrix) {
        Verify.verify(sieveBitMatrix.length == checkMatrix.length);
        for (int i = 0; i < sieveBitMatrix.length; ++i) {
            checkMatrix[i].and(sieveBitMatrix[i]);
            if (checkMatrix[i].cardinality() <= 0) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    private static List<Vectored<SingleMatchedAccess>> maximumCoverageMatches(@Nonnull Collection<? extends PartialMatch> matches, @Nonnull Set<RequestedOrdering> requestedOrderings) {
        List<SingleMatchedAccess> singleMatchedAccesses = AbstractDataAccessRule.prepareMatchesAndCompensations(matches, requestedOrderings);
        int index = 0;
        ImmutableList.Builder maximumCoverageMatchesBuilder = ImmutableList.builder();
        for (int i = 0; i < singleMatchedAccesses.size(); ++i) {
            SingleMatchedAccess outerAccess = singleMatchedAccesses.get(i);
            boolean isContained = AbstractDataAccessRule.findContainingAccess(singleMatchedAccesses, outerAccess);
            if (isContained) continue;
            maximumCoverageMatchesBuilder.add(Vectored.of(outerAccess, index));
            ++index;
        }
        return maximumCoverageMatchesBuilder.build();
    }

    private static boolean findContainingAccess(@Nonnull List<SingleMatchedAccess> sortedSingleMatches, @Nonnull SingleMatchedAccess probeSingleMatchedAccess) {
        PartialMatch probeMatch = probeSingleMatchedAccess.getPartialMatch();
        Set<Placeholder> probeBoundPlaceholders = probeMatch.getBoundPlaceholders();
        for (SingleMatchedAccess singleMatchedAccess : sortedSingleMatches) {
            if (probeSingleMatchedAccess.getPartialMatch().getMatchCandidate() != singleMatchedAccess.getPartialMatch().getMatchCandidate()) continue;
            Set<Placeholder> bindingPredicates = singleMatchedAccess.getPartialMatch().getBoundPlaceholders();
            if (probeBoundPlaceholders.size() >= bindingPredicates.size()) break;
            if (probeSingleMatchedAccess.equals(singleMatchedAccess) || !bindingPredicates.containsAll(probeBoundPlaceholders)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    private static List<SingleMatchedAccess> prepareMatchesAndCompensations(@Nonnull Collection<? extends PartialMatch> partialMatches, @Nonnull Set<RequestedOrdering> requestedOrderings) {
        ArrayList<SingleMatchedAccess> partialMatchesWithCompensation = new ArrayList<SingleMatchedAccess>();
        for (PartialMatch partialMatch : partialMatches) {
            RegularTranslationMap topToTopTranslationMap;
            Optional<NonnullPair<ScanDirection, Set<RequestedOrdering>>> satisfyingOrderingsPairOptional;
            Optional<RegularTranslationMap> topToTopTranslationMapOptional = AbstractDataAccessRule.computeTopToTopTranslationMapMaybe(partialMatch);
            if (topToTopTranslationMapOptional.isEmpty() || (satisfyingOrderingsPairOptional = AbstractDataAccessRule.satisfiesAnyRequestedOrderings(partialMatch, topToTopTranslationMap = topToTopTranslationMapOptional.get(), requestedOrderings)).isEmpty()) continue;
            NonnullPair<ScanDirection, Set<RequestedOrdering>> satisfyingOrderingsPair = satisfyingOrderingsPairOptional.get();
            ScanDirection scanDirection = satisfyingOrderingsPair.getLeft();
            Verify.verify(scanDirection == ScanDirection.FORWARD || scanDirection == ScanDirection.REVERSE || scanDirection == ScanDirection.BOTH);
            CorrelationIdentifier topAlias = Quantifier.uniqueId();
            CorrelationIdentifier candidateTopAlias = Quantifier.uniqueId();
            PullUp.UnificationPullUp unificationPullUp = partialMatch.prepareForUnification(topAlias, candidateTopAlias);
            Compensation compensation = partialMatch.compensateCompleteMatch(unificationPullUp, unificationPullUp == null ? topAlias : candidateTopAlias);
            if (scanDirection == ScanDirection.FORWARD || scanDirection == ScanDirection.BOTH) {
                partialMatchesWithCompensation.add(new SingleMatchedAccess(partialMatch, compensation, topAlias, false, topToTopTranslationMap, satisfyingOrderingsPair.getRight()));
            }
            if (scanDirection != ScanDirection.REVERSE) continue;
            partialMatchesWithCompensation.add(new SingleMatchedAccess(partialMatch, compensation, topAlias, true, topToTopTranslationMap, satisfyingOrderingsPair.getRight()));
        }
        partialMatchesWithCompensation.sort(Comparator.comparing(p -> p.getPartialMatch().getBoundPlaceholders().size()).reversed());
        return partialMatchesWithCompensation;
    }

    @Nonnull
    private static Optional<RegularTranslationMap> computeTopToTopTranslationMapMaybe(PartialMatch partialMatch) {
        MaxMatchMap maxMatchMap = partialMatch.getMatchInfo().getMaxMatchMap();
        return maxMatchMap.pullUpMaybe(Quantifier.current(), Quantifier.current());
    }

    @Nonnull
    private static Optional<NonnullPair<ScanDirection, Set<RequestedOrdering>>> satisfiesAnyRequestedOrderings(@Nonnull PartialMatch partialMatch, @Nonnull TranslationMap topToTopTranslationMap, @Nonnull Set<RequestedOrdering> requestedOrderings) {
        boolean seenForward = false;
        boolean seenReverse = false;
        ImmutableSet.Builder satisfyingRequestedOrderings = ImmutableSet.builder();
        block5: for (RequestedOrdering requestedOrdering : requestedOrderings) {
            RequestedOrdering translatedRequestedOrdering = requestedOrdering.translateCorrelations(topToTopTranslationMap, true);
            Optional<ScanDirection> scanDirectionForRequestedOrderingOptional = AbstractDataAccessRule.satisfiesRequestedOrdering(partialMatch, translatedRequestedOrdering);
            if (!scanDirectionForRequestedOrderingOptional.isPresent()) continue;
            satisfyingRequestedOrderings.add(translatedRequestedOrdering);
            ScanDirection scanDirectionForRequestedOrdering = scanDirectionForRequestedOrderingOptional.get();
            switch (scanDirectionForRequestedOrdering) {
                case FORWARD: {
                    seenForward = true;
                    continue block5;
                }
                case REVERSE: {
                    seenReverse = true;
                    continue block5;
                }
                case BOTH: {
                    seenForward = true;
                    seenReverse = true;
                    continue block5;
                }
            }
            throw new RecordCoreException("unknown scan direction", new Object[0]);
        }
        if (!seenForward && !seenReverse) {
            return Optional.empty();
        }
        if (seenForward && seenReverse) {
            return Optional.of(NonnullPair.of(ScanDirection.BOTH, satisfyingRequestedOrderings.build()));
        }
        return Optional.of(NonnullPair.of(seenForward ? ScanDirection.FORWARD : ScanDirection.REVERSE, satisfyingRequestedOrderings.build()));
    }

    private static Optional<ScanDirection> satisfiesRequestedOrdering(@Nonnull PartialMatch partialMatch, @Nonnull RequestedOrdering requestedOrdering) {
        if (requestedOrdering.isPreserve()) {
            return Optional.of(ScanDirection.BOTH);
        }
        ScanDirection resolvedScanDirection = ScanDirection.BOTH;
        MatchInfo matchInfo = partialMatch.getMatchInfo();
        List<OrderingPart.MatchedOrderingPart> orderingParts = matchInfo.getMatchedOrderingParts();
        ImmutableSet equalityBoundKeys = orderingParts.stream().filter(orderingPart -> orderingPart.getComparisonRangeType() == ComparisonRange.Type.EQUALITY).map(OrderingPart::getValue).collect(ImmutableSet.toImmutableSet());
        Iterator<OrderingPart.MatchedOrderingPart> orderingPartIterator = orderingParts.iterator();
        for (OrderingPart.RequestedOrderingPart requestedOrderingPart : requestedOrdering.getOrderingParts()) {
            Value requestedOrderingValue = requestedOrderingPart.getValue();
            if (equalityBoundKeys.contains(requestedOrderingValue)) continue;
            boolean found = false;
            while (orderingPartIterator.hasNext()) {
                OrderingPart.MatchedOrderingPart orderingPart2 = orderingPartIterator.next();
                if (orderingPart2.getComparisonRangeType() == ComparisonRange.Type.EQUALITY) continue;
                Value orderingValue = orderingPart2.getValue();
                if (requestedOrderingValue.equals(orderingValue)) {
                    OrderingPart.RequestedSortOrder requestedSortOrder = (OrderingPart.RequestedSortOrder)requestedOrderingPart.getSortOrder();
                    if (requestedSortOrder != OrderingPart.RequestedSortOrder.ANY) {
                        OrderingPart.MatchedSortOrder matchedSortOrder = (OrderingPart.MatchedSortOrder)orderingPart2.getSortOrder();
                        if (matchedSortOrder.isCounterflowNulls() != requestedSortOrder.isCounterflowNulls()) {
                            return Optional.empty();
                        }
                        ScanDirection scanDirectionForPart = matchedSortOrder.isAnyDescending() == requestedSortOrder.isAnyDescending() ? ScanDirection.FORWARD : ScanDirection.REVERSE;
                        if (resolvedScanDirection == ScanDirection.BOTH) {
                            resolvedScanDirection = scanDirectionForPart;
                        } else if (resolvedScanDirection != scanDirectionForPart) {
                            return Optional.empty();
                        }
                    }
                    found = true;
                    break;
                }
                return Optional.empty();
            }
            if (found) continue;
            return Optional.empty();
        }
        return Optional.of(resolvedScanDirection);
    }

    @Nonnull
    private static Map<PartialMatch, RecordQueryPlan> createScansForMatches(@Nonnull PlanContext planContext, @Nonnull Memoizer memoizer, @Nonnull Collection<Vectored<SingleMatchedAccess>> matches) {
        return matches.stream().collect(ImmutableMap.toImmutableMap(singleMatchedAccessVectored -> ((SingleMatchedAccess)singleMatchedAccessVectored.getElement()).getPartialMatch(), singleMatchedAccessVectored -> {
            SingleMatchedAccess singleMatchedAccess = (SingleMatchedAccess)singleMatchedAccessVectored.getElement();
            PartialMatch partialMatch = singleMatchedAccess.getPartialMatch();
            return partialMatch.getMatchCandidate().toEquivalentPlan(partialMatch, planContext, memoizer, singleMatchedAccess.isReverseScanOrder());
        }));
    }

    @Nonnull
    private static Map<PartialMatch, RecordQueryPlan> distinctMatchToScanMap(@Nonnull Memoizer memoizer, @Nonnull Map<PartialMatch, RecordQueryPlan> matchToExpressionMap) {
        return matchToExpressionMap.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> {
            PartialMatch partialMatch = (PartialMatch)entry.getKey();
            MatchCandidate matchCandidate = partialMatch.getMatchCandidate();
            RecordQueryPlan dataAccessPlan = (RecordQueryPlan)entry.getValue();
            if (matchCandidate.createsDuplicates()) {
                return new RecordQueryUnorderedPrimaryKeyDistinctPlan(Quantifier.physical(memoizer.memoizePlan(dataAccessPlan)));
            }
            return dataAccessPlan;
        }));
    }

    @Nonnull
    private static Optional<RelationalExpression> applyCompensationForSingleDataAccessMaybe(@Nonnull Memoizer memoizer, @Nonnull SingleMatchedAccess singleMatchedAccess, @Nonnull RecordQueryPlan plan) {
        Compensation compensation = singleMatchedAccess.getCompensation();
        if (compensation.isImpossible()) {
            return Optional.empty();
        }
        return Optional.of(compensation.applyAllNeededCompensations(memoizer, plan, realizedAlias -> TranslationMap.ofAliases(singleMatchedAccess.getCandidateTopAlias(), realizedAlias)));
    }

    @Nonnull
    protected abstract IntersectionResult createIntersectionAndCompensation(@Nonnull Memoizer var1, @Nonnull Map<BitSet, IntersectionInfo> var2, @Nonnull Map<PartialMatch, RecordQueryPlan> var3, @Nonnull List<Vectored<SingleMatchedAccess>> var4, @Nonnull Set<RequestedOrdering> var5);

    protected static boolean isPartitionRedundant(@Nonnull Map<BitSet, IntersectionInfo> intersectionInfoMap, @Nonnull List<Vectored<SingleMatchedAccess>> partition, @Nonnull ImmutableSet<Value> equalityBoundKeyValues) {
        for (Vectored<SingleMatchedAccess> singleMatchedAccessWithIndex : partition) {
            BitSet infoKey = AbstractDataAccessRule.intersectionInfoKey(singleMatchedAccessWithIndex);
            IntersectionInfo intersectionInfo = Objects.requireNonNull(intersectionInfoMap.get(infoKey));
            if (intersectionInfo.getMaxCardinality().isUnknown() || intersectionInfo.getMaxCardinality().getCardinality() > 1L) continue;
            return true;
        }
        Optional<Set<CorrelationIdentifier>> partitionUnmatchedIdsForPartitionOptional = AbstractDataAccessRule.unmatchedIdsMaybe(intersectionInfoMap, partition);
        if (partitionUnmatchedIdsForPartitionOptional.isEmpty()) {
            return false;
        }
        Set<CorrelationIdentifier> partitionUnmatchedIds = partitionUnmatchedIdsForPartitionOptional.get();
        for (List list : ChooseK.chooseK(partition, partition.size() - 1)) {
            BitSet checkCacheKey = AbstractDataAccessRule.intersectionInfoKey(list);
            IntersectionInfo subIntersectionInfo = Objects.requireNonNull(intersectionInfoMap.get(checkCacheKey));
            Ordering subIntersectionOrdering = subIntersectionInfo.getIntersectionOrdering();
            if (!subIntersectionOrdering.getEqualityBoundValues().containsAll(equalityBoundKeyValues)) continue;
            Optional<Set<CorrelationIdentifier>> subIntersectionUnmatchedIdsOptional = AbstractDataAccessRule.unmatchedIdsMaybe(subIntersectionInfo);
            if (subIntersectionUnmatchedIdsOptional.isEmpty()) {
                return false;
            }
            Set<CorrelationIdentifier> subIntersectionUnmatchedIds = subIntersectionUnmatchedIdsOptional.get();
            if (!subIntersectionUnmatchedIds.equals(partitionUnmatchedIds)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    private static Optional<Set<CorrelationIdentifier>> unmatchedIdsMaybe(@Nonnull Map<BitSet, IntersectionInfo> intersectionInfoMap, @Nonnull List<Vectored<SingleMatchedAccess>> partition) {
        Verify.verify(!partition.isEmpty());
        Iterator<Vectored<SingleMatchedAccess>> iterator = partition.iterator();
        Optional<Set<CorrelationIdentifier>> unmatchedIdsOptional = AbstractDataAccessRule.unmatchedIdsMaybe(Objects.requireNonNull(intersectionInfoMap.get(AbstractDataAccessRule.intersectionInfoKey(iterator.next()))));
        if (unmatchedIdsOptional.isEmpty()) {
            return Optional.empty();
        }
        LinkedHashSet intersectedUniqueIds = new LinkedHashSet(unmatchedIdsOptional.get());
        while (iterator.hasNext()) {
            unmatchedIdsOptional = AbstractDataAccessRule.unmatchedIdsMaybe(Objects.requireNonNull(intersectionInfoMap.get(AbstractDataAccessRule.intersectionInfoKey(iterator.next()))));
            if (unmatchedIdsOptional.isEmpty()) {
                return Optional.empty();
            }
            intersectedUniqueIds.retainAll((Collection)unmatchedIdsOptional.get());
        }
        return Optional.of(intersectedUniqueIds);
    }

    @Nonnull
    private static Optional<Compensation.WithSelectCompensation> compensationMaybe(@Nonnull IntersectionInfo intersectionInfo) {
        Compensation compensation = intersectionInfo.getCompensation();
        if (!(compensation instanceof Compensation.WithSelectCompensation)) {
            return Optional.empty();
        }
        return Optional.of((Compensation.WithSelectCompensation)compensation);
    }

    @Nonnull
    private static Optional<Set<CorrelationIdentifier>> unmatchedIdsMaybe(@Nonnull IntersectionInfo intersectionInfo) {
        if (!intersectionInfo.getCompensation().isNeeded()) {
            return Optional.of(ImmutableSet.of());
        }
        Optional<Compensation.WithSelectCompensation> compensationOptional = AbstractDataAccessRule.compensationMaybe(intersectionInfo);
        return compensationOptional.map(compensation -> compensation.getGroupByMappings().getUnmatchedAggregatesMap().keySet());
    }

    @Nonnull
    private static Ordering orderingFromSingleMatchedAccess(@Nonnull SingleMatchedAccess singleMatchedAccess) {
        NonnullPair<List<OrderingPart.MatchedOrderingPart>, Boolean> singlePartitionOrderingPartsPair = AbstractDataAccessRule.adjustMatchedOrderingParts(singleMatchedAccess);
        return AbstractDataAccessRule.orderingFromOrderingParts(singlePartitionOrderingPartsPair.getLeft(), singlePartitionOrderingPartsPair.getRight());
    }

    @Nonnull
    protected static NonnullPair<List<OrderingPart.MatchedOrderingPart>, Boolean> adjustMatchedOrderingParts(@Nonnull SingleMatchedAccess singleMatchedAccess) {
        PartialMatch partialMatch = singleMatchedAccess.getPartialMatch();
        Map<CorrelationIdentifier, ComparisonRange> boundParametersPrefixMap = partialMatch.getBoundParameterPrefixMap();
        List adjustedMatchOrderingParts = partialMatch.getMatchInfo().getMatchedOrderingParts().stream().map(matchedOrderingPart -> matchedOrderingPart.getComparisonRange().isEquality() && !boundParametersPrefixMap.containsKey(matchedOrderingPart.getParameterId()) ? matchedOrderingPart.demote() : matchedOrderingPart).collect(ImmutableList.toImmutableList());
        return NonnullPair.of(adjustedMatchOrderingParts, singleMatchedAccess.isReverseScanOrder());
    }

    @Nonnull
    protected static Ordering.Intersection intersectOrderings(@Nonnull List<NonnullPair<List<OrderingPart.MatchedOrderingPart>, Boolean>> partitionOrderingPairs) {
        ImmutableList<Ordering> orderings = partitionOrderingPairs.stream().map(pair -> AbstractDataAccessRule.orderingFromOrderingParts((List)pair.getLeft(), (Boolean)pair.getRight())).collect(ImmutableList.toImmutableList());
        return Ordering.merge(orderings, Ordering.INTERSECTION, (left, right) -> true);
    }

    @Nonnull
    private static Ordering orderingFromOrderingParts(@Nonnull List<OrderingPart.MatchedOrderingPart> matchedOrderingParts, boolean isReverse) {
        ImmutableSetMultimap.Builder bindingMapBuilder = ImmutableSetMultimap.builder();
        ImmutableList.Builder orderingSequenceBuilder = ImmutableList.builder();
        for (OrderingPart.MatchedOrderingPart matchedOrderingPart : matchedOrderingParts) {
            ComparisonRange comparisonRange = matchedOrderingPart.getComparisonRange();
            if (comparisonRange.getRangeType() == ComparisonRange.Type.EQUALITY) {
                bindingMapBuilder.put(matchedOrderingPart.getValue(), Ordering.Binding.fixed(comparisonRange.getEqualityComparison()));
                continue;
            }
            Value orderingValue = matchedOrderingPart.getValue();
            orderingSequenceBuilder.add(orderingValue);
            bindingMapBuilder.put(orderingValue, Ordering.Binding.sorted(((OrderingPart.MatchedSortOrder)matchedOrderingPart.getSortOrder()).toProvidedSortOrder(isReverse)));
        }
        return Ordering.ofOrderingSequence((SetMultimap<Value, Ordering.Binding>)((Object)bindingMapBuilder.build()), (List<? extends Value>)((Object)orderingSequenceBuilder.build()), false);
    }

    protected static boolean isCompatibleComparisonKey(@Nonnull Collection<Value> comparisonKeyValues, @Nonnull List<Value> commonRecordKeyValues, @Nonnull ImmutableSet<Value> equalityBoundKeyValues) {
        return commonRecordKeyValues.stream().filter(commonPrimaryKeyValue -> !equalityBoundKeyValues.contains(commonPrimaryKeyValue)).allMatch(comparisonKeyValues::contains);
    }

    private static void addToIntersectionInfoMap(@Nonnull Map<BitSet, IntersectionInfo> intersectionInfoMap, @Nonnull Vectored<SingleMatchedAccess> singleAccessWithIndex, @Nonnull Optional<RelationalExpression> compensatedExpressionOptional) {
        BitSet cacheKey = new BitSet();
        cacheKey.set(singleAccessWithIndex.getPosition());
        SingleMatchedAccess singleMatchedAccess = singleAccessWithIndex.getElement();
        Compensation compensation = singleMatchedAccess.getCompensation();
        Ordering orderingFromSingleMatchedAccess = AbstractDataAccessRule.orderingFromSingleMatchedAccess(singleMatchedAccess);
        if (compensatedExpressionOptional.isEmpty()) {
            intersectionInfoMap.put(cacheKey, IntersectionInfo.ofImpossibleAccess(orderingFromSingleMatchedAccess, compensation));
        } else {
            RelationalExpression compensatedExpression = compensatedExpressionOptional.get();
            CardinalitiesProperty.Cardinalities cardinalities = CardinalitiesProperty.cardinalities().evaluate(compensatedExpression);
            intersectionInfoMap.put(cacheKey, IntersectionInfo.ofSingleAccess(orderingFromSingleMatchedAccess, compensation, compensatedExpression, cardinalities.getMaxCardinality()));
        }
    }

    private static void updateIntersectionInfoMap(@Nonnull Map<BitSet, IntersectionInfo> intersectionInfoMap, @Nonnull Collection<Vectored<SingleMatchedAccess>> partition, @Nonnull IntersectionResult intersectionResult) {
        Verify.verify(partition.size() >= 2);
        BitSet cacheKey = AbstractDataAccessRule.intersectionInfoKey(partition);
        if (intersectionResult.hasViableIntersection()) {
            if (!intersectionResult.getExpressions().isEmpty()) {
                for (List list : ChooseK.chooseK(partition, partition.size() - 1)) {
                    BitSet subCacheKey = AbstractDataAccessRule.intersectionInfoKey(list);
                    IntersectionInfo subIntersectionInfo = Objects.requireNonNull(intersectionInfoMap.get(subCacheKey));
                    subIntersectionInfo.evictExpressions();
                }
            }
            intersectionInfoMap.put(cacheKey, IntersectionInfo.ofIntersection(intersectionResult.getCommonIntersectionOrdering(), intersectionResult.getCompensation(), intersectionResult.getExpressions()));
        }
    }

    @Nonnull
    private static Set<RelationalExpression> intersectionInfoMapToExpressions(@Nonnull Map<BitSet, IntersectionInfo> intersectionInfoMap) {
        return intersectionInfoMap.entrySet().stream().flatMap(entry -> ((IntersectionInfo)entry.getValue()).getExpressions().stream()).collect(LinkedIdentitySet.toLinkedIdentitySet());
    }

    @Nonnull
    private static BitSet intersectionInfoKey(@Nonnull Vectored<SingleMatchedAccess> access) {
        BitSet intersectionInfoKey = new BitSet();
        intersectionInfoKey.set(access.getPosition());
        return intersectionInfoKey;
    }

    @Nonnull
    private static BitSet intersectionInfoKey(@Nonnull Collection<Vectored<SingleMatchedAccess>> accesses) {
        BitSet intersectionInfoKey = new BitSet();
        accesses.forEach(vectored -> intersectionInfoKey.set(vectored.getPosition()));
        return intersectionInfoKey;
    }

    protected static class Vectored<T> {
        @Nonnull
        private final T element;
        final int position;

        private Vectored(@Nonnull T element, int position) {
            this.element = element;
            this.position = position;
        }

        @Nonnull
        public T getElement() {
            return this.element;
        }

        public int getPosition() {
            return this.position;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Vectored)) {
                return false;
            }
            Vectored vectored = (Vectored)o;
            return this.position == vectored.position && Objects.equals(this.element, vectored.element);
        }

        public int hashCode() {
            return Objects.hash(this.element, this.position);
        }

        public String toString() {
            return "[" + String.valueOf(this.element) + ":" + this.position + "]";
        }

        public static <T> Vectored<T> of(@Nonnull T element, int position) {
            return new Vectored<T>(element, position);
        }
    }

    protected static class SingleMatchedAccess {
        @Nonnull
        private final PartialMatch partialMatch;
        @Nonnull
        private final Compensation compensation;
        @Nonnull
        private final CorrelationIdentifier candidateTopAlias;
        private final boolean reverseScanOrder;
        @Nonnull
        private final TranslationMap topToTopTranslationMap;
        @Nonnull
        private final Set<RequestedOrdering> satisfyingRequestedOrderings;
        @Nonnull
        private final Supplier<GroupByMappings> pulledUpGroupByMappingsSupplier;

        public SingleMatchedAccess(@Nonnull PartialMatch partialMatch, @Nonnull Compensation compensation, @Nonnull CorrelationIdentifier candidateTopAlias, boolean reverseScanOrder, @Nonnull TranslationMap topToTopTranslationMap, @Nonnull Set<RequestedOrdering> satisfyingRequestedOrderings) {
            this.partialMatch = partialMatch;
            this.compensation = compensation;
            this.candidateTopAlias = candidateTopAlias;
            this.reverseScanOrder = reverseScanOrder;
            this.satisfyingRequestedOrderings = ImmutableSet.copyOf(satisfyingRequestedOrderings);
            this.topToTopTranslationMap = topToTopTranslationMap;
            this.pulledUpGroupByMappingsSupplier = Suppliers.memoize(() -> partialMatch.getMatchInfo().adjustGroupByMappings(Quantifier.current(), partialMatch.getCandidateRef().get()));
        }

        @Nonnull
        public PartialMatch getPartialMatch() {
            return this.partialMatch;
        }

        @Nonnull
        public Compensation getCompensation() {
            return this.compensation;
        }

        @Nonnull
        public CorrelationIdentifier getCandidateTopAlias() {
            return this.candidateTopAlias;
        }

        public boolean isReverseScanOrder() {
            return this.reverseScanOrder;
        }

        @Nonnull
        public TranslationMap getTopToTopTranslationMap() {
            return this.topToTopTranslationMap;
        }

        @Nonnull
        public Set<RequestedOrdering> getSatisfyingRequestedOrderings() {
            return this.satisfyingRequestedOrderings;
        }

        @Nonnull
        public GroupByMappings getPulledUpGroupByMappingsForOrdering() {
            return this.pulledUpGroupByMappingsSupplier.get();
        }

        public String toString() {
            return "[" + String.valueOf(this.partialMatch) + ", " + String.valueOf(this.compensation) + ", " + String.valueOf(this.candidateTopAlias) + ", " + (this.reverseScanOrder ? "forward" : "reverse") + ", " + String.valueOf(this.satisfyingRequestedOrderings) + "]";
        }
    }

    protected static class IntersectionResult {
        @Nullable
        private final Ordering.Intersection commonIntersectionOrdering;
        @Nonnull
        private final Compensation compensation;
        @Nonnull
        private final List<RelationalExpression> expressions;

        private IntersectionResult(@Nullable Ordering.Intersection commonIntersectionOrdering, @Nonnull Compensation compensation, @Nonnull List<RelationalExpression> expressions) {
            Verify.verify(commonIntersectionOrdering != null || expressions.isEmpty());
            this.expressions = ImmutableList.copyOf(expressions);
            this.commonIntersectionOrdering = commonIntersectionOrdering;
            this.compensation = compensation;
        }

        @Nonnull
        public List<RelationalExpression> getExpressions() {
            return Objects.requireNonNull(this.expressions);
        }

        public boolean hasViableIntersection() {
            return this.commonIntersectionOrdering != null;
        }

        @Nonnull
        public Ordering.Intersection getCommonIntersectionOrdering() {
            return Objects.requireNonNull(this.commonIntersectionOrdering);
        }

        @Nonnull
        public Compensation getCompensation() {
            return this.compensation;
        }

        @Nonnull
        public static IntersectionResult noViableIntersection() {
            return new IntersectionResult(null, Compensation.noCompensation(), ImmutableList.of());
        }

        @Nonnull
        public static IntersectionResult of(@Nullable Ordering.Intersection commonIntersectionOrdering, @Nonnull Compensation compensation, @Nonnull List<RelationalExpression> expressions) {
            return new IntersectionResult(commonIntersectionOrdering, compensation, expressions);
        }

        public String toString() {
            return "[ordering=" + String.valueOf(this.commonIntersectionOrdering == null ? "no common ordering" : this.commonIntersectionOrdering) + ", " + String.valueOf(this.compensation) + "]";
        }
    }

    protected static enum ScanDirection {
        FORWARD,
        REVERSE,
        BOTH;

    }

    protected static class IntersectionInfo {
        @Nonnull
        private final Ordering intersectionOrdering;
        @Nonnull
        private final Compensation compensation;
        @Nonnull
        private final List<RelationalExpression> expressions;
        @Nonnull
        private final CardinalitiesProperty.Cardinality maxCardinality;

        private IntersectionInfo(@Nonnull Ordering intersectionOrdering, @Nonnull Compensation compensation, @Nonnull List<RelationalExpression> expressions, @Nonnull CardinalitiesProperty.Cardinality maxCardinality) {
            this.intersectionOrdering = intersectionOrdering;
            this.compensation = compensation;
            this.expressions = expressions;
            this.maxCardinality = maxCardinality;
        }

        @Nonnull
        public Ordering getIntersectionOrdering() {
            return this.intersectionOrdering;
        }

        @Nonnull
        public Compensation getCompensation() {
            return this.compensation;
        }

        @Nonnull
        public List<RelationalExpression> getExpressions() {
            return this.expressions;
        }

        @Nonnull
        public CardinalitiesProperty.Cardinality getMaxCardinality() {
            return this.maxCardinality;
        }

        public void evictExpressions() {
            this.expressions.clear();
        }

        @Nonnull
        public static IntersectionInfo ofSingleAccess(@Nonnull Ordering ordering, @Nonnull Compensation compensation, @Nonnull RelationalExpression expression, @Nonnull CardinalitiesProperty.Cardinality maxCardinality) {
            return new IntersectionInfo(ordering, compensation, Lists.newArrayList(expression), maxCardinality);
        }

        @Nonnull
        public static IntersectionInfo ofImpossibleAccess(@Nonnull Ordering ordering, @Nonnull Compensation compensation) {
            return new IntersectionInfo(ordering, compensation, Lists.newArrayList(), CardinalitiesProperty.Cardinality.unknownCardinality());
        }

        @Nonnull
        public static IntersectionInfo ofIntersection(@Nonnull Ordering ordering, @Nonnull Compensation compensation, @Nonnull List<RelationalExpression> expressions) {
            return new IntersectionInfo(ordering, compensation, Lists.newArrayList(expressions), CardinalitiesProperty.Cardinality.unknownCardinality());
        }
    }
}

