/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.MatchInfo;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PartialMatchMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class AdjustMatchRule
extends CascadesRule<PartialMatch> {
    private static final BindingMatcher<PartialMatch> rootMatcher = PartialMatchMatchers.incompleteMatch();

    public AdjustMatchRule() {
        super(rootMatcher);
    }

    @Override
    public void onMatch(@Nonnull CascadesRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        PartialMatch incompleteMatch = bindings.get(rootMatcher);
        Reference queryReference = incompleteMatch.getQueryRef();
        MatchCandidate matchCandidate = incompleteMatch.getMatchCandidate();
        SetMultimap<Reference, RelationalExpression> refToExpressionMap = matchCandidate.findReferencingExpressions(ImmutableList.of(queryReference));
        for (Map.Entry entry : refToExpressionMap.entries()) {
            Reference candidateReference = (Reference)entry.getKey();
            RelationalExpression candidateExpression = (RelationalExpression)entry.getValue();
            this.matchWithCandidate(incompleteMatch, candidateExpression).ifPresent(matchInfo -> call.yieldPartialMatch(incompleteMatch.getBoundAliasMap(), matchCandidate, incompleteMatch.getQueryExpression(), candidateReference, (MatchInfo)matchInfo));
        }
    }

    @Nonnull
    private Optional<MatchInfo> matchWithCandidate(@Nonnull PartialMatch partialMatch, @Nonnull RelationalExpression candidateExpression) {
        Verify.verify(!candidateExpression.getQuantifiers().isEmpty());
        if (candidateExpression.getQuantifiers().size() > 1) {
            return Optional.empty();
        }
        Quantifier candidateQuantifier = Iterables.getOnlyElement(candidateExpression.getQuantifiers());
        Reference otherRangesOver = candidateQuantifier.getRangesOver();
        if (!candidateExpression.getCorrelatedTo().equals(otherRangesOver.getCorrelatedTo())) {
            return Optional.empty();
        }
        if (partialMatch.getCandidateRef() != otherRangesOver) {
            return Optional.empty();
        }
        return candidateExpression.adjustMatch(partialMatch);
    }
}

