/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.AggregateIndexMatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.Column;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRange;
import com.apple.foundationdb.record.query.plan.cascades.Compensation;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.GroupByMappings;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.MatchInfo;
import com.apple.foundationdb.record.query.plan.cascades.MatchPartition;
import com.apple.foundationdb.record.query.plan.cascades.Memoizer;
import com.apple.foundationdb.record.query.plan.cascades.Ordering;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrdering;
import com.apple.foundationdb.record.query.plan.cascades.ValueEquivalence;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MatchPartitionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PartialMatchMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.rules.AbstractDataAccessRule;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RecordConstructorValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.Values;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.RegularTranslationMap;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryMultiIntersectionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQuerySetPlan;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.google.common.base.Verify;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class AggregateDataAccessRule
extends AbstractDataAccessRule {
    private static final BindingMatcher<PartialMatch> completeMatchMatcher = PartialMatchMatchers.completeMatch().and(PartialMatchMatchers.matchingAggregateIndexMatchCandidate());
    private static final BindingMatcher<RelationalExpression> expressionMatcher = RelationalExpressionMatchers.anyExpression();
    private static final BindingMatcher<MatchPartition> rootMatcher = MatchPartitionMatchers.ofExpressionAndMatches(expressionMatcher, MultiMatcher.some(completeMatchMatcher));

    public AggregateDataAccessRule() {
        super(rootMatcher, completeMatchMatcher, expressionMatcher);
    }

    @Override
    @Nonnull
    protected AbstractDataAccessRule.IntersectionResult createIntersectionAndCompensation(@Nonnull Memoizer memoizer, @Nonnull Map<BitSet, AbstractDataAccessRule.IntersectionInfo> intersectionInfoMap, @Nonnull Map<PartialMatch, RecordQueryPlan> matchToPlanMap, @Nonnull List<AbstractDataAccessRule.Vectored<AbstractDataAccessRule.SingleMatchedAccess>> partition, @Nonnull Set<RequestedOrdering> requestedOrderings) {
        Verify.verify(partition.size() > 1);
        ImmutableList partitionAccesses = partition.stream().map(AbstractDataAccessRule.Vectored::getElement).collect(ImmutableList.toImmutableList());
        Optional<List<Value>> commonGroupingKeyValuesOptional = AggregateDataAccessRule.commonGroupingKeyValuesMaybe(partitionAccesses.stream().map(AbstractDataAccessRule.SingleMatchedAccess::getPartialMatch).collect(ImmutableList.toImmutableList()));
        if (commonGroupingKeyValuesOptional.isEmpty()) {
            return AbstractDataAccessRule.IntersectionResult.noViableIntersection();
        }
        List<Value> commonGroupingKeyValues = commonGroupingKeyValuesOptional.get();
        ImmutableList<NonnullPair<List<OrderingPart.MatchedOrderingPart>, Boolean>> partitionOrderings = partitionAccesses.stream().map(AbstractDataAccessRule::adjustMatchedOrderingParts).collect(ImmutableList.toImmutableList());
        Ordering.Intersection intersectionOrdering = AggregateDataAccessRule.intersectOrderings(partitionOrderings);
        ImmutableSet<Value> equalityBoundKeyValues = partitionOrderings.stream().flatMap(orderingPartsPair -> ((List)orderingPartsPair.getKey()).stream().filter(boundOrderingKey -> boundOrderingKey.getComparisonRangeType() == ComparisonRange.Type.EQUALITY).map(OrderingPart::getValue)).collect(ImmutableSet.toImmutableSet());
        boolean isPartitionRedundant = AggregateDataAccessRule.isPartitionRedundant(intersectionInfoMap, partition, equalityBoundKeyValues);
        if (isPartitionRedundant) {
            return AbstractDataAccessRule.IntersectionResult.noViableIntersection();
        }
        Compensation compensation = partitionAccesses.stream().map(AbstractDataAccessRule.SingleMatchedAccess::getCompensation).reduce(Compensation.impossibleCompensation(), Compensation::intersect);
        AbstractDataAccessRule.SingleMatchedAccess firstMatchedAccess = partition.get(0).getElement();
        TranslationMap topToTopTranslationMap = firstMatchedAccess.getTopToTopTranslationMap();
        boolean hasCommonOrdering = false;
        ImmutableList.Builder expressionsBuilder = ImmutableList.builder();
        HashSet<List<OrderingPart.ProvidedOrderingPart>> seenComparisonOrderingParts = new HashSet<List<OrderingPart.ProvidedOrderingPart>>();
        for (RequestedOrdering requestedOrdering : requestedOrderings) {
            RequestedOrdering translatedRequestedOrdering = requestedOrdering.translateCorrelations(topToTopTranslationMap, true);
            Iterable<List<Value>> comparisonKeyValuesIterable = intersectionOrdering.enumerateSatisfyingComparisonKeyValues(translatedRequestedOrdering);
            for (List<Value> comparisonKeyValues : comparisonKeyValuesIterable) {
                if (!AggregateDataAccessRule.isCompatibleComparisonKey(comparisonKeyValues, commonGroupingKeyValues, equalityBoundKeyValues) || !AggregateDataAccessRule.isConsistentComparisonKeyDerivations(partition, comparisonKeyValues)) continue;
                hasCommonOrdering = true;
                if (compensation.isImpossible()) continue;
                List<OrderingPart.ProvidedOrderingPart> comparisonOrderingParts = intersectionOrdering.directionalOrderingParts(comparisonKeyValues, translatedRequestedOrdering, OrderingPart.ProvidedSortOrder.FIXED);
                boolean comparisonIsReverse = RecordQuerySetPlan.resolveComparisonDirection(comparisonOrderingParts);
                if (seenComparisonOrderingParts.contains(comparisonOrderingParts = RecordQuerySetPlan.adjustFixedBindings(comparisonOrderingParts, comparisonIsReverse))) continue;
                seenComparisonOrderingParts.add(comparisonOrderingParts);
                ImmutableList.Builder newQuantifiersBuilder = ImmutableList.builder();
                ImmutableList.Builder candidateTopAliasesBuilder = ImmutableList.builder();
                for (AbstractDataAccessRule.Vectored<AbstractDataAccessRule.SingleMatchedAccess> singleMatchedAccessWithIndex : partition) {
                    AbstractDataAccessRule.SingleMatchedAccess singleMatchedAccess = singleMatchedAccessWithIndex.getElement();
                    RecordQueryPlan plan = Objects.requireNonNull(matchToPlanMap.get(singleMatchedAccess.getPartialMatch()));
                    Reference reference = memoizer.memoizePlan(plan);
                    newQuantifiersBuilder.add(Quantifier.physical(reference));
                    candidateTopAliasesBuilder.add(singleMatchedAccess.getCandidateTopAlias());
                }
                ImmutableCollection newQuantifiers = newQuantifiersBuilder.build();
                NonnullPair<List<Value>, List<Value>> commonAndPickUpValues = AggregateDataAccessRule.computeCommonAndPickUpValues(partition, commonGroupingKeyValues.size());
                Value intersectionResultValue = AggregateDataAccessRule.computeIntersectionResultValue((List<? extends Quantifier>)((Object)newQuantifiers), commonAndPickUpValues.getLeft(), commonAndPickUpValues.getRight());
                RecordQueryMultiIntersectionOnValuesPlan intersectionPlan = RecordQueryMultiIntersectionOnValuesPlan.intersection((List<Quantifier.Physical>)((Object)newQuantifiers), comparisonOrderingParts, intersectionResultValue, comparisonIsReverse);
                RelationalExpression compensatedIntersection = compensation.applyAllNeededCompensations(memoizer, intersectionPlan, arg_0 -> AggregateDataAccessRule.lambda$createIntersectionAndCompensation$2((ImmutableList)newQuantifiers, candidateTopAliasesBuilder, intersectionResultValue, commonGroupingKeyValues, arg_0));
                expressionsBuilder.add(compensatedIntersection);
            }
        }
        return AbstractDataAccessRule.IntersectionResult.of(hasCommonOrdering ? intersectionOrdering : null, compensation, (List<RelationalExpression>)((Object)expressionsBuilder.build()));
    }

    @Nonnull
    protected static Optional<List<Value>> commonGroupingKeyValuesMaybe(@Nonnull Iterable<? extends PartialMatch> partialMatches) {
        List<Value> common = null;
        boolean first = true;
        for (PartialMatch partialMatch : partialMatches) {
            List<Value> key;
            MatchCandidate matchCandidate = partialMatch.getMatchCandidate();
            MatchInfo.RegularMatchInfo regularMatchInfo = partialMatch.getRegularMatchInfo();
            if (matchCandidate instanceof AggregateIndexMatchCandidate) {
                AggregateIndexMatchCandidate aggregateIndexMatchCandidate = (AggregateIndexMatchCandidate)matchCandidate;
                List<Value> rollUpToGroupingValues = regularMatchInfo.getRollUpToGroupingValues();
                key = rollUpToGroupingValues == null ? aggregateIndexMatchCandidate.getGroupingAndAggregateAccessors(Quantifier.current()).getLeft() : aggregateIndexMatchCandidate.getGroupingAndAggregateAccessors(rollUpToGroupingValues.size(), Quantifier.current()).getLeft();
            } else {
                return Optional.empty();
            }
            if (first) {
                common = key;
                first = false;
                continue;
            }
            if (common.equals(key)) continue;
            return Optional.empty();
        }
        return Optional.ofNullable(common);
    }

    private static boolean isConsistentComparisonKeyDerivations(@Nonnull List<AbstractDataAccessRule.Vectored<AbstractDataAccessRule.SingleMatchedAccess>> partition, @Nonnull List<Value> comparisonKeyValues) {
        for (Value comparisonKeyValue : comparisonKeyValues) {
            if (!AggregateDataAccessRule.consistentQueryValueForGroupingValueMaybe(partition, comparisonKeyValue).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    private static Optional<Value> consistentQueryValueForGroupingValueMaybe(@Nonnull List<AbstractDataAccessRule.Vectored<AbstractDataAccessRule.SingleMatchedAccess>> partition, @Nonnull Value comparisonKeyValue) {
        Value queryComparisonKeyValue = null;
        for (AbstractDataAccessRule.Vectored<AbstractDataAccessRule.SingleMatchedAccess> singleMatchedAccessWithIndex : partition) {
            AbstractDataAccessRule.SingleMatchedAccess singledMatchedAccess = singleMatchedAccessWithIndex.getElement();
            GroupByMappings groupByMappings = singledMatchedAccess.getPulledUpGroupByMappingsForOrdering();
            BiMap<Value, Value> inverseMatchedGroupingsMap = groupByMappings.getMatchedGroupingsMap().inverse();
            Value currentQueryComparisonKeyValue = (Value)inverseMatchedGroupingsMap.get(comparisonKeyValue);
            if (currentQueryComparisonKeyValue == null) {
                return Optional.empty();
            }
            if (queryComparisonKeyValue == null) {
                queryComparisonKeyValue = currentQueryComparisonKeyValue;
                continue;
            }
            ConstrainedBoolean semanticEquals = queryComparisonKeyValue.semanticEquals((Object)currentQueryComparisonKeyValue, ValueEquivalence.empty());
            if (semanticEquals.isFalse()) {
                return Optional.empty();
            }
            if (semanticEquals.getConstraint().isTautology()) continue;
            return Optional.empty();
        }
        return Optional.of(Objects.requireNonNull(queryComparisonKeyValue));
    }

    @Nonnull
    private static NonnullPair<List<Value>, List<Value>> computeCommonAndPickUpValues(@Nonnull List<AbstractDataAccessRule.Vectored<AbstractDataAccessRule.SingleMatchedAccess>> partition, int numGroupings) {
        ImmutableList commonValuesAndPickUpValueByAccess = partition.stream().map(singleMatchedAccessWithIndex -> ((AbstractDataAccessRule.SingleMatchedAccess)singleMatchedAccessWithIndex.getElement()).getPartialMatch().getMatchCandidate()).map(matchCandidate -> (AggregateIndexMatchCandidate)matchCandidate).map(aggregateIndexMatchCandidate -> aggregateIndexMatchCandidate.getGroupingAndAggregateAccessors(numGroupings, Quantifier.current())).collect(ImmutableList.toImmutableList());
        ImmutableList.Builder pickUpValuesBuilder = ImmutableList.builder();
        for (int i = 0; i < commonValuesAndPickUpValueByAccess.size(); ++i) {
            NonnullPair commonAndPickUpValuePair = (NonnullPair)commonValuesAndPickUpValueByAccess.get(i);
            Value pickUpValue = (Value)commonAndPickUpValuePair.getRight();
            pickUpValuesBuilder.add(pickUpValue);
        }
        return NonnullPair.of((List)((NonnullPair)commonValuesAndPickUpValueByAccess.get(0)).getLeft(), pickUpValuesBuilder.build());
    }

    @Nonnull
    private static Value computeIntersectionResultValue(@Nonnull List<? extends Quantifier> quantifiers, @Nonnull List<Value> commonValues, @Nonnull List<Value> pickUpValues) {
        ImmutableList.Builder columnBuilder = ImmutableList.builder();
        RegularTranslationMap commonTranslationMap = TranslationMap.ofAliases(Quantifier.current(), quantifiers.get(0).getAlias());
        for (Value commonValue : commonValues) {
            columnBuilder.add(Column.unnamedOf(commonValue.translateCorrelations(commonTranslationMap)));
        }
        for (int i = 0; i < quantifiers.size(); ++i) {
            Quantifier quantifier = quantifiers.get(i);
            RegularTranslationMap pickUpTranslationMap = TranslationMap.ofAliases(Quantifier.current(), quantifier.getAlias());
            columnBuilder.add(Column.unnamedOf(pickUpValues.get(i).translateCorrelations(pickUpTranslationMap)));
        }
        return RecordConstructorValue.ofColumns(columnBuilder.build());
    }

    @Nonnull
    private static TranslationMap computeTranslationMap(@Nonnull CorrelationIdentifier intersectionAlias, @Nonnull List<? extends Quantifier> quantifiers, @Nonnull List<CorrelationIdentifier> candidateTopAliases, @Nonnull Type.Record intersectionResultType, int numGrouped) {
        RegularTranslationMap.Builder builder = RegularTranslationMap.builder();
        List<Value> deconstructedIntersectionValues = Values.deconstructRecord(QuantifiedObjectValue.of(intersectionAlias, intersectionResultType));
        for (int quantifierIndex = 0; quantifierIndex < quantifiers.size(); ++quantifierIndex) {
            Quantifier quantifier = quantifiers.get(quantifierIndex);
            Type.Record quantifierFlowedObjectType = (Type.Record)quantifier.getFlowedObjectType();
            List<Type.Record.Field> quantifierFields = quantifierFlowedObjectType.getFields();
            Verify.verify(quantifierFields.size() == numGrouped + 1);
            ImmutableList.Builder columnBuilder = ImmutableList.builder();
            for (int columnIndex = 0; columnIndex < numGrouped; ++columnIndex) {
                columnBuilder.add(Column.of(quantifierFields.get(columnIndex), deconstructedIntersectionValues.get(columnIndex)));
            }
            columnBuilder.add(Column.of(quantifierFields.get(numGrouped), deconstructedIntersectionValues.get(numGrouped + quantifierIndex)));
            builder.when(candidateTopAliases.get(quantifierIndex)).then((alias, leaf) -> RecordConstructorValue.ofColumns(columnBuilder.build()));
        }
        return builder.build();
    }

    private static /* synthetic */ TranslationMap lambda$createIntersectionAndCompensation$2(ImmutableList newQuantifiers, ImmutableList.Builder candidateTopAliasesBuilder, Value intersectionResultValue, List commonGroupingKeyValues, CorrelationIdentifier baseAlias) {
        return AggregateDataAccessRule.computeTranslationMap(baseAlias, newQuantifiers, (List<CorrelationIdentifier>)((Object)candidateTopAliasesBuilder.build()), (Type.Record)intersectionResultValue.getResultType(), commonGroupingKeyValues.size());
    }
}

