/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.ExplorationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ExplorationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.ExploratoryMemoizer;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentitySet;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalFilterExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionVisitorWithDefaults;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.TableFunctionExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ListMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ReferenceMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.TypedMatcherWithPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.properties.CardinalitiesProperty;
import com.apple.foundationdb.record.query.plan.cascades.values.LiteralValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RangeValue;
import com.apple.foundationdb.record.query.plan.cascades.values.StreamingValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.RegularTranslationMap;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class DecorrelateValuesRule
extends ExplorationCascadesRule<SelectExpression> {
    @Nonnull
    private static final BindingMatcher<Quantifier.ForEach> rangeOneMatcher = QuantifierMatchers.forEachQuantifierWithoutDefaultOnEmptyOverRef(TypedMatcherWithPredicate.typedMatcherWithPredicate(Reference.class, ref -> ref.getAllMemberExpressions().stream().anyMatch(expr -> expr instanceof TableFunctionExpression && CardinalitiesProperty.Cardinalities.exactlyOne().equals(CardinalitiesProperty.cardinalities().evaluate((RelationalExpression)expr)))));
    @Nonnull
    private static final BindingMatcher<SelectExpression> valuesExpressionMatcher = RelationalExpressionMatchers.selectExpression(CollectionMatcher.empty(), ListMatcher.only(rangeOneMatcher)).where((BindingMatcher<SelectExpression>)TypedMatcherWithPredicate.typedMatcherWithPredicate(SelectExpression.class, expr -> {
        Quantifier childQun = Iterables.getOnlyElement(expr.getQuantifiers());
        Value resultValue = expr.getResultValue();
        return !resultValue.isCorrelatedTo(childQun.getAlias());
    }));
    @Nonnull
    private static final BindingMatcher<Quantifier.ForEach> valuesQunMatcher = QuantifierMatchers.forEachQuantifierWithoutDefaultOnEmptyOverRef(ReferenceMatchers.exploratoryMember(valuesExpressionMatcher));
    @Nonnull
    private static final BindingMatcher<SelectExpression> root = RelationalExpressionMatchers.selectExpression(MultiMatcher.some(valuesQunMatcher)).where(RelationalExpressionMatchers.isExploratoryExpression());

    public DecorrelateValuesRule() {
        super(root);
    }

    private static <T> boolean emptyIntersection(@Nonnull Set<? extends T> set1, @Nonnull Set<? super T> set2) {
        return set1.stream().noneMatch(set2::contains);
    }

    private static boolean correlatedToNone(@Nonnull RelationalExpression expression, @Nonnull Set<CorrelationIdentifier> aliases) {
        return DecorrelateValuesRule.emptyIntersection(expression.getCorrelatedTo(), aliases);
    }

    private static boolean correlatedToNone(@Nonnull Quantifier qun, @Nonnull Set<CorrelationIdentifier> aliases) {
        return DecorrelateValuesRule.emptyIntersection(qun.getCorrelatedTo(), aliases);
    }

    @Override
    public void onMatch(@Nonnull ExplorationCascadesRuleCall call) {
        List<Quantifier.ForEach> valueQunCandidates = call.getBindings().getAll(valuesQunMatcher);
        if (valueQunCandidates.isEmpty()) {
            return;
        }
        SelectExpression selectExpression = call.get(root);
        Set<CorrelationIdentifier> childAliases = Quantifiers.aliases(selectExpression.getQuantifiers());
        List<SelectExpression> valuesExpressions = call.getBindings().getAll(valuesExpressionMatcher);
        ImmutableMap.Builder valuesByAlias = ImmutableMap.builderWithExpectedSize(valuesExpressions.size());
        ImmutableMap.Builder qunsToPushDownBuilder = ImmutableMap.builderWithExpectedSize(valueQunCandidates.size());
        Streams.zip(valueQunCandidates.stream(), valuesExpressions.stream(), NonnullPair::of).filter(pair -> DecorrelateValuesRule.correlatedToNone((RelationalExpression)pair.getRight(), childAliases)).forEach(pair -> {
            Quantifier qun = (Quantifier)pair.getLeft();
            SelectExpression valueExpression = (SelectExpression)pair.getRight();
            CorrelationIdentifier alias = qun.getAlias();
            Verify.verify(qun.getRangesOver().containsExactly(valueExpression), "matched value box should be aligned with matched quantifier", new Object[0]);
            valuesByAlias.put(alias, valueExpression);
            if (DecorrelateValuesRule.correlatedToNone(qun, childAliases)) {
                qunsToPushDownBuilder.put(alias, qun);
            } else {
                Set uncorrelatedExpressions = qun.getRangesOver().getExploratoryExpressions().stream().filter(expr -> DecorrelateValuesRule.correlatedToNone(expr, childAliases)).collect(LinkedIdentitySet.toLinkedIdentitySet());
                Verify.verify(uncorrelatedExpressions.contains(valueExpression), "target value expression should be in the uncorrelated subset of quantifier expressions", new Object[0]);
                Quantifier newQun = qun.overNewReference(call.memoizeExploratoryExpressions(uncorrelatedExpressions));
                qunsToPushDownBuilder.put(alias, newQun);
            }
        });
        ImmutableMap<CorrelationIdentifier, Quantifier> qunsToPushDownByAlias = qunsToPushDownBuilder.build();
        if (qunsToPushDownByAlias.isEmpty()) {
            return;
        }
        TranslationMap translationMap = this.createTranslationMapFromSelects(valuesByAlias.build());
        Value newResultValue = selectExpression.getResultValue().translateCorrelations(translationMap, true);
        List newPredicates = selectExpression.getPredicates().stream().map(predicate -> predicate.translateCorrelations(translationMap, true)).collect(ImmutableList.toImmutableList());
        PushValuesIntoVisitor visitor = new PushValuesIntoVisitor(qunsToPushDownByAlias, translationMap, call);
        ImmutableList.Builder newQuantifiersBuilder = ImmutableList.builderWithExpectedSize(Math.max(1, selectExpression.getQuantifiers().size() - qunsToPushDownByAlias.size()));
        if (selectExpression.getQuantifiers().size() == qunsToPushDownByAlias.size()) {
            TableFunctionExpression rangeOneExpr = new TableFunctionExpression((StreamingValue)new RangeValue.RangeFn().encapsulate(ImmutableList.of(LiteralValue.ofScalar(1L))));
            Quantifier.ForEach forEach = Quantifier.forEach(call.memoizeExploratoryExpression(rangeOneExpr));
            newQuantifiersBuilder.add(forEach);
        }
        for (Quantifier quantifier : selectExpression.getQuantifiers()) {
            if (qunsToPushDownByAlias.containsKey(quantifier.getAlias())) continue;
            boolean anyChanged = false;
            ImmutableList.Builder newExpressionsBuilder = ImmutableList.builderWithExpectedSize(quantifier.getRangesOver().getExploratoryExpressions().size());
            for (RelationalExpression lowerExpression : quantifier.getRangesOver().getExploratoryExpressions()) {
                Set lowerCorrelatedTo = qunsToPushDownByAlias.keySet().stream().filter(lowerExpression::isCorrelatedTo).collect(ImmutableSet.toImmutableSet());
                if (lowerCorrelatedTo.isEmpty()) {
                    newExpressionsBuilder.add(lowerExpression);
                    continue;
                }
                newExpressionsBuilder.add((RelationalExpression)visitor.visit(lowerExpression));
                anyChanged = true;
            }
            if (anyChanged) {
                Reference newRef = call.memoizeExploratoryExpressions(newExpressionsBuilder.build());
                Quantifier newQun = quantifier.overNewReference(newRef);
                newQuantifiersBuilder.add(newQun);
                continue;
            }
            newQuantifiersBuilder.add(quantifier);
        }
        SelectExpression exprToYield = new SelectExpression(newResultValue, (List<? extends Quantifier>)((Object)newQuantifiersBuilder.build()), newPredicates);
        call.yieldExploratoryExpression(exprToYield);
    }

    @Nonnull
    private TranslationMap createTranslationMapFromSelects(@Nonnull Map<CorrelationIdentifier, SelectExpression> valuesById) {
        RegularTranslationMap.Builder translationBuilder = TranslationMap.regularBuilder();
        valuesById.forEach((id, childSelect) -> translationBuilder.when((CorrelationIdentifier)id).then((source, leaf) -> childSelect.getResultValue()));
        return translationBuilder.build();
    }

    private static final class PushValuesIntoVisitor
    implements RelationalExpressionVisitorWithDefaults<RelationalExpression> {
        @Nonnull
        private final Map<CorrelationIdentifier, Quantifier> qunsToPushDown;
        @Nonnull
        private final TranslationMap translationMap;
        @Nonnull
        private final ExploratoryMemoizer memoizer;

        public PushValuesIntoVisitor(@Nonnull Map<CorrelationIdentifier, Quantifier> qunsToPushDown, @Nonnull TranslationMap translationMap, @Nonnull ExploratoryMemoizer memoizer) {
            this.qunsToPushDown = qunsToPushDown;
            this.translationMap = translationMap;
            this.memoizer = memoizer;
        }

        @Nonnull
        private SelectExpression selectWithQuantifiersPushed(@Nonnull Set<CorrelationIdentifier> correlatedTo, @Nonnull Value resultValue, @Nonnull Collection<? extends Quantifier> quantifierBase, @Nonnull List<? extends QueryPredicate> predicates) {
            ImmutableList.Builder newQuantifiers = ImmutableList.builderWithExpectedSize(quantifierBase.size() + this.qunsToPushDown.size());
            for (Quantifier qun : this.qunsToPushDown.values()) {
                if (!correlatedTo.contains(qun.getAlias())) continue;
                newQuantifiers.add(qun);
            }
            newQuantifiers.addAll(quantifierBase);
            return new SelectExpression(resultValue, (List<? extends Quantifier>)((Object)newQuantifiers.build()), predicates);
        }

        @Override
        @Nonnull
        public SelectExpression visitSelectExpression(@Nonnull SelectExpression select) {
            return this.selectWithQuantifiersPushed(select.getCorrelatedTo(), select.getResultValue(), select.getQuantifiers(), select.getPredicates());
        }

        @Override
        @Nonnull
        public SelectExpression visitLogicalFilterExpression(@Nonnull LogicalFilterExpression filter) {
            return this.selectWithQuantifiersPushed(filter.getCorrelatedTo(), filter.getResultValue(), filter.getQuantifiers(), filter.getPredicates());
        }

        @Nonnull
        private Quantifier pushOnTopOfQuantifier(@Nonnull Quantifier childQun) {
            if (DecorrelateValuesRule.correlatedToNone(childQun, this.qunsToPushDown.keySet())) {
                return childQun;
            }
            Quantifier.ForEach newChild = Quantifier.forEach(childQun.getRangesOver());
            SelectExpression newSelect = this.selectWithQuantifiersPushed(newChild.getCorrelatedTo(), newChild.getFlowedObjectValue(), ImmutableList.of(newChild), ImmutableList.of());
            Reference ref = this.memoizer.memoizeExploratoryExpression(newSelect);
            return childQun.overNewReference(ref);
        }

        @Override
        @Nonnull
        public RelationalExpression visitDefault(@Nonnull RelationalExpression expression) {
            ImmutableList.Builder newQuantifiers = ImmutableList.builderWithExpectedSize(expression.getQuantifiers().size());
            for (Quantifier quantifier : expression.getQuantifiers()) {
                Quantifier newQun = this.pushOnTopOfQuantifier(quantifier);
                newQuantifiers.add(newQun);
            }
            return expression.translateCorrelations(this.translationMap, true, (List<? extends Quantifier>)((Object)newQuantifiers.build()));
        }
    }
}

