/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.ExpressionPartition;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.AnyMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ExpressionsPartitionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class FinalizeExpressionsRule
extends ImplementationCascadesRule<RelationalExpression> {
    @Nonnull
    private static final BindingMatcher<ExpressionPartition<RelationalExpression>> childPartitionsMatcher = ExpressionsPartitionMatchers.anyExpressionPartition();
    @Nonnull
    private static final BindingMatcher<Reference> childReferenceMatcher = ExpressionsPartitionMatchers.expressionPartitions(ExpressionsPartitionMatchers.rollUpPartitions(AnyMatcher.any(childPartitionsMatcher)));
    @Nonnull
    private static final CollectionMatcher<Quantifier> allQuantifiersMatcher = MultiMatcher.all(QuantifierMatchers.anyQuantifierOverRef(childReferenceMatcher));
    @Nonnull
    private static final BindingMatcher<RelationalExpression> root = RelationalExpressionMatchers.anyExploratoryExpression(allQuantifiersMatcher);

    public FinalizeExpressionsRule() {
        super(root);
    }

    @Override
    @Nonnull
    public Optional<Class<?>> getRootOperator() {
        return Optional.empty();
    }

    @Override
    public void onMatch(@Nonnull ImplementationCascadesRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        RelationalExpression exploratoryExpression = bindings.get(root);
        List<ExpressionPartition<RelationalExpression>> partitions = bindings.getAll(childPartitionsMatcher);
        Collection allQuantifiers = (Collection)((Object)bindings.get(allQuantifiersMatcher));
        ImmutableList newQuantifiers = Streams.zip(partitions.stream(), allQuantifiers.stream(), (partition, quantifier) -> {
            Reference reference = call.memoizeFinalExpressionsFromOther(quantifier.getRangesOver(), partition.getExpressions());
            return quantifier.toBuilder().build(reference);
        }).collect(ImmutableList.toImmutableList());
        call.yieldFinalExpression(exploratoryExpression.withQuantifiers(newQuantifiers));
    }
}

