/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.PlanPartition;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalDistinctExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.AnyMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ListMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlanPartitionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.properties.DistinctRecordsProperty;
import com.apple.foundationdb.record.query.plan.cascades.properties.StoredRecordProperty;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedPrimaryKeyDistinctPlan;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class ImplementDistinctRule
extends ImplementationCascadesRule<LogicalDistinctExpression> {
    @Nonnull
    private static final BindingMatcher<PlanPartition> innerPlanPartitionMatcher = PlanPartitionMatchers.anyPlanPartition();
    @Nonnull
    private static final BindingMatcher<Reference> innerReferenceMatcher = PlanPartitionMatchers.planPartitions(PlanPartitionMatchers.filterPlanPartitions(planPartition -> planPartition.getPartitionPropertyValue(StoredRecordProperty.storedRecord()), AnyMatcher.any(innerPlanPartitionMatcher)));
    @Nonnull
    private static final BindingMatcher<LogicalDistinctExpression> root = RelationalExpressionMatchers.logicalDistinctExpression(ListMatcher.only(QuantifierMatchers.forEachQuantifierOverRef(innerReferenceMatcher)));

    public ImplementDistinctRule() {
        super(root);
    }

    @Override
    public void onMatch(@Nonnull ImplementationCascadesRuleCall call) {
        PlanPartition innerPlanPartition = call.get(innerPlanPartitionMatcher);
        Reference innerReference = call.get(innerReferenceMatcher);
        if (innerPlanPartition.getPartitionPropertyValue(DistinctRecordsProperty.distinctRecords()).booleanValue()) {
            call.yieldPlans(innerPlanPartition.getPlans());
        } else {
            call.yieldPlan(new RecordQueryUnorderedPrimaryKeyDistinctPlan(Quantifier.physical(call.memoizeMemberPlansFromOther(innerReference, innerPlanPartition.getPlans()))));
        }
    }
}

