/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.combinatorics.CrossProduct;
import com.apple.foundationdb.record.query.combinatorics.EnumeratingIterable;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.Ordering;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.PlanPartition;
import com.apple.foundationdb.record.query.plan.cascades.PlanPropertiesMap;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrdering;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrderingConstraint;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalDistinctExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalUnionExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ListMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlanPartitionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.properties.DistinctRecordsProperty;
import com.apple.foundationdb.record.query.plan.cascades.properties.OrderingProperty;
import com.apple.foundationdb.record.query.plan.cascades.properties.PrimaryKeyProperty;
import com.apple.foundationdb.record.query.plan.cascades.properties.StoredRecordProperty;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.plans.RecordQuerySetPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnionPlan;
import com.apple.foundationdb.record.util.pair.Pair;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class ImplementDistinctUnionRule
extends ImplementationCascadesRule<LogicalDistinctExpression> {
    @Nonnull
    private static final CollectionMatcher<PlanPartition> unionLegPlanPartitionsMatcher = MultiMatcher.all(PlanPartitionMatchers.anyPlanPartition());
    @Nonnull
    private static final BindingMatcher<Reference> unionLegReferenceMatcher = PlanPartitionMatchers.planPartitions(PlanPartitionMatchers.filterPlanPartitions(planPartition -> planPartition.getPartitionPropertyValue(StoredRecordProperty.storedRecord()) != false && planPartition.getPartitionPropertyValue(PrimaryKeyProperty.primaryKey()).isPresent(), PlanPartitionMatchers.rollUpPartitionsTo(unionLegPlanPartitionsMatcher, PlanPropertiesMap.allAttributesExcept(DistinctRecordsProperty.distinctRecords()))));
    private static final CollectionMatcher<Quantifier.ForEach> allForEachQuantifiersMatcher = MultiMatcher.all(QuantifierMatchers.forEachQuantifierOverRef(unionLegReferenceMatcher));
    @Nonnull
    private static final BindingMatcher<LogicalUnionExpression> unionExpressionMatcher = RelationalExpressionMatchers.logicalUnionExpression(allForEachQuantifiersMatcher);
    @Nonnull
    private static final BindingMatcher<Quantifier.ForEach> unionForEachQuantifierMatcher = QuantifierMatchers.forEachQuantifier(unionExpressionMatcher);
    @Nonnull
    private static final BindingMatcher<LogicalDistinctExpression> root = RelationalExpressionMatchers.logicalDistinctExpression(ListMatcher.exactly(unionForEachQuantifierMatcher));

    public ImplementDistinctUnionRule() {
        super(root, ImmutableSet.of(RequestedOrderingConstraint.REQUESTED_ORDERING));
    }

    @Override
    public void onMatch(@Nonnull ImplementationCascadesRuleCall call) {
        Optional<Set<RequestedOrdering>> requestedOrderingsOptional = call.getPlannerConstraintMaybe(RequestedOrderingConstraint.REQUESTED_ORDERING);
        if (requestedOrderingsOptional.isEmpty()) {
            return;
        }
        Set<RequestedOrdering> requestedOrderings = requestedOrderingsOptional.get();
        PlannerBindings bindings = call.getBindings();
        Quantifier.ForEach unionForEachQuantifier = bindings.get(unionForEachQuantifierMatcher);
        Collection allForEachQuantifiers = (Collection)((Object)bindings.get(allForEachQuantifiersMatcher));
        List<PlanPartition> planPartitionsByQuantifier = bindings.getAll(unionLegPlanPartitionsMatcher);
        EnumeratingIterable partitionsCrossProduct = CrossProduct.crossProduct(planPartitionsByQuantifier);
        for (RequestedOrdering requestedOrdering : requestedOrderings) {
            Iterator partitionsCrossProductIterator = partitionsCrossProduct.iterator();
            ArrayList<Pair<Ordering.Union, Ordering>> merge = Lists.newArrayList();
            while (partitionsCrossProductIterator.hasNext()) {
                List partitions = (List)partitionsCrossProductIterator.next();
                Optional<List<Value>> commonPrimaryKeyValuesMaybe = PrimaryKeyProperty.commonPrimaryKeyValuesMaybeFromOptionals(partitions.stream().map(partition -> partition.getPartitionPropertyValue(PrimaryKeyProperty.primaryKey())).collect(ImmutableList.toImmutableList()));
                if (commonPrimaryKeyValuesMaybe.isEmpty()) continue;
                List<Value> commonPrimaryKeyValues = commonPrimaryKeyValuesMaybe.get();
                ImmutableList<Ordering> orderings = partitions.stream().map(planPartition -> planPartition.getPartitionPropertyValue(OrderingProperty.ordering())).collect(ImmutableList.toImmutableList());
                this.pushInterestingOrders(call, unionForEachQuantifier, orderings, requestedOrdering);
                for (int i = 0; i < merge.size(); ++i) {
                    if (((Ordering)orderings.get(i)).equals(((Pair)merge.get(i)).getValue())) continue;
                    merge.subList(i, merge.size()).clear();
                    break;
                }
                while (merge.size() < orderings.size()) {
                    if (merge.isEmpty()) {
                        merge.add(Pair.of(Ordering.UNION.createFromOrdering((Ordering)orderings.get(0)), (Ordering)orderings.get(0)));
                        continue;
                    }
                    int lastMerged = merge.size() - 1;
                    Ordering.Union mergedOrdering = Ordering.merge(ImmutableList.of((Ordering)((Pair)merge.get(lastMerged)).getKey(), (Ordering)orderings.get(merge.size())), Ordering.UNION, (left, right) -> true);
                    if (this.isPrimaryKeyCompatibleWithOrdering(commonPrimaryKeyValues, mergedOrdering)) {
                        merge.add(Pair.of(mergedOrdering, (Ordering)orderings.get(merge.size())));
                        continue;
                    }
                    partitionsCrossProductIterator.skip(merge.size());
                    break;
                }
                if (merge.size() != orderings.size()) continue;
                Ordering.Union unionOrdering = (Ordering.Union)((Pair)merge.get(merge.size() - 1)).getKey();
                ImmutableList<Quantifier.Physical> newQuantifiers = Streams.zip(partitions.stream(), allForEachQuantifiers.stream(), (partition, quantifier) -> call.memoizeMemberPlansFromOther(quantifier.getRangesOver(), partition.getPlans())).map(Quantifier::physical).collect(ImmutableList.toImmutableList());
                Iterable<List<Value>> enumeratedSatisfyingComparisonKeyValues = unionOrdering.enumerateSatisfyingComparisonKeyValues(requestedOrdering);
                for (List<Value> comparisonKeyValues : enumeratedSatisfyingComparisonKeyValues) {
                    List<OrderingPart.ProvidedOrderingPart> comparisonOrderingParts = unionOrdering.directionalOrderingParts(comparisonKeyValues, requestedOrdering, OrderingPart.ProvidedSortOrder.FIXED);
                    boolean comparisonIsReverse = RecordQuerySetPlan.resolveComparisonDirection(comparisonOrderingParts);
                    comparisonOrderingParts = RecordQuerySetPlan.adjustFixedBindings(comparisonOrderingParts, comparisonIsReverse);
                    RecordQueryUnionOnValuesPlan unionPlan = RecordQueryUnionPlan.fromQuantifiers(newQuantifiers, comparisonOrderingParts, comparisonIsReverse, true);
                    call.yieldPlan(unionPlan);
                }
            }
        }
    }

    private void pushInterestingOrders(@Nonnull ImplementationCascadesRuleCall call, @Nonnull Quantifier unionForEachQuantifier, @Nonnull ImmutableList<Ordering> providedOrderings, @Nonnull RequestedOrdering requestedOrdering) {
        Reference unionRef = unionForEachQuantifier.getRangesOver();
        for (Ordering providedOrdering : providedOrderings) {
            Set<RequestedOrdering> requestedOrderings = providedOrdering.deriveRequestedOrderings(requestedOrdering, false);
            call.pushConstraint(unionRef, RequestedOrderingConstraint.REQUESTED_ORDERING, requestedOrderings);
        }
    }

    private boolean isPrimaryKeyCompatibleWithOrdering(@Nonnull List<Value> primaryKeyValues, @Nonnull Ordering ordering) {
        ImmutableSet<Value> orderingValues = ordering.getOrderingSet().getSet();
        for (Value primaryKeyValue : primaryKeyValues) {
            if (orderingValues.contains(primaryKeyValue)) continue;
            return false;
        }
        return true;
    }
}

