/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.PlanPartition;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalFilterExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.AnyMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ListMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlanPartitionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QueryPredicateMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPredicatesFilterPlan;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class ImplementFilterRule
extends ImplementationCascadesRule<LogicalFilterExpression> {
    @Nonnull
    private static final BindingMatcher<PlanPartition> innerPlanPartitionMatcher = PlanPartitionMatchers.anyPlanPartition();
    @Nonnull
    private static final BindingMatcher<Reference> innerReferenceMatcher = PlanPartitionMatchers.planPartitions(AnyMatcher.any(innerPlanPartitionMatcher));
    @Nonnull
    private static final BindingMatcher<QueryPredicate> predicateMatcher = QueryPredicateMatchers.anyPredicate();
    @Nonnull
    private static final BindingMatcher<Quantifier.ForEach> quantifierMatcher = QuantifierMatchers.forEachQuantifierOverRef(innerReferenceMatcher);
    @Nonnull
    private static final BindingMatcher<LogicalFilterExpression> root = RelationalExpressionMatchers.logicalFilterExpression(MultiMatcher.all(predicateMatcher), ListMatcher.only(quantifierMatcher));

    public ImplementFilterRule() {
        super(root);
    }

    @Override
    public void onMatch(@Nonnull ImplementationCascadesRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        PlanPartition innerPlanPartition = call.get(innerPlanPartitionMatcher);
        Reference innerReference = call.get(innerReferenceMatcher);
        List<QueryPredicate> queryPredicates = bindings.getAll(predicateMatcher);
        Quantifier.ForEach innerQuantifier = bindings.get(quantifierMatcher);
        if (queryPredicates.stream().allMatch(QueryPredicate::isTautology)) {
            call.yieldPlans(innerPlanPartition.getPlans());
        } else {
            call.yieldPlan(new RecordQueryPredicatesFilterPlan(Quantifier.physicalBuilder().morphFrom(innerQuantifier).build(call.memoizeMemberPlansFromOther(innerReference, innerPlanPartition.getPlans())), queryPredicates.stream().map(QueryPredicate::toResidualPredicate).collect(ImmutableList.toImmutableList())));
        }
    }
}

