/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.query.combinatorics.CrossProduct;
import com.apple.foundationdb.record.query.combinatorics.PartiallyOrderedSet;
import com.apple.foundationdb.record.query.combinatorics.TopologicalSort;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentityMap;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentitySet;
import com.apple.foundationdb.record.query.plan.cascades.Memoizer;
import com.apple.foundationdb.record.query.plan.cascades.Ordering;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.PlanPartition;
import com.apple.foundationdb.record.query.plan.cascades.PlanPartitions;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrdering;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrderingConstraint;
import com.apple.foundationdb.record.query.plan.cascades.expressions.ExplodeExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.properties.OrderingProperty;
import com.apple.foundationdb.record.query.plan.cascades.rules.PushRequestedOrderingThroughInLikeSelectRule;
import com.apple.foundationdb.record.query.plan.cascades.values.LiteralValue;
import com.apple.foundationdb.record.query.plan.cascades.values.ParameterObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.plans.InComparandSource;
import com.apple.foundationdb.record.query.plan.plans.InParameterSource;
import com.apple.foundationdb.record.query.plan.plans.InSource;
import com.apple.foundationdb.record.query.plan.plans.InValuesSource;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.SortedInComparandSource;
import com.apple.foundationdb.record.query.plan.plans.SortedInParameterSource;
import com.apple.foundationdb.record.query.plan.plans.SortedInValuesSource;
import com.google.common.base.Verify;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class ImplementInJoinRule
extends ImplementationCascadesRule<SelectExpression> {
    private static final BindingMatcher<ExplodeExpression> explodeExpressionMatcher = RelationalExpressionMatchers.explodeExpression();
    private static final CollectionMatcher<Quantifier.ForEach> explodeQuantifiersMatcher = MultiMatcher.some(QuantifierMatchers.forEachQuantifier(explodeExpressionMatcher));
    private static final BindingMatcher<SelectExpression> root = RelationalExpressionMatchers.selectExpression(explodeQuantifiersMatcher);

    public ImplementInJoinRule() {
        super(root, ImmutableSet.of(RequestedOrderingConstraint.REQUESTED_ORDERING));
    }

    @Override
    public void onMatch(@Nonnull ImplementationCascadesRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        Optional<Set<RequestedOrdering>> requestedOrderingsOptional = call.getPlannerConstraintMaybe(RequestedOrderingConstraint.REQUESTED_ORDERING);
        if (requestedOrderingsOptional.isEmpty()) {
            return;
        }
        Set<RequestedOrdering> requestedOrderings = requestedOrderingsOptional.get();
        SelectExpression selectExpression = bindings.get(root);
        if (!selectExpression.getPredicates().isEmpty()) {
            return;
        }
        Collection explodeQuantifiers = (Collection)((Object)bindings.get(explodeQuantifiersMatcher));
        if (explodeQuantifiers.isEmpty()) {
            return;
        }
        Map<CorrelationIdentifier, Quantifier> explodeAliasToQuantifierMap = Quantifiers.aliasToQuantifierMap(explodeQuantifiers);
        Set<CorrelationIdentifier> explodeAliases = explodeAliasToQuantifierMap.keySet();
        Optional<Quantifier.ForEach> innerQuantifierOptional = PushRequestedOrderingThroughInLikeSelectRule.findInnerQuantifier(selectExpression, explodeQuantifiers, explodeAliases);
        if (innerQuantifierOptional.isEmpty()) {
            return;
        }
        Quantifier.ForEach innerQuantifier = innerQuantifierOptional.get();
        Value resultValue = selectExpression.getResultValue();
        if (!(resultValue instanceof QuantifiedObjectValue) || !((QuantifiedObjectValue)resultValue).getAlias().equals(innerQuantifier.getAlias())) {
            return;
        }
        List<ExplodeExpression> explodeExpressions = bindings.getAll(explodeExpressionMatcher);
        Map<Quantifier.ForEach, ExplodeExpression> quantifierToExplodeBiMap = ImplementInJoinRule.computeQuantifierToExplodeMap(explodeQuantifiers, explodeExpressions.stream().collect(LinkedIdentitySet.toLinkedIdentitySet()));
        Reference innerReference = innerQuantifier.getRangesOver();
        List<PlanPartition> planPartitions = PlanPartitions.rollUpTo(innerReference.toPlanPartitions(), OrderingProperty.ordering());
        for (PlanPartition planPartition : planPartitions) {
            Ordering providedOrdering = planPartition.getPartitionPropertyValue(OrderingProperty.ordering());
            for (RequestedOrdering requestedOrdering : requestedOrderings) {
                Stream<List<InSource>> sourcesStream = this.enumerateInSourcesForRequestedOrdering(explodeAliasToQuantifierMap, explodeAliases, quantifierToExplodeBiMap, providedOrdering, requestedOrdering);
                sourcesStream.forEach(sources -> {
                    List<InSource> reverseSources = Lists.reverse(sources);
                    Memoizer.ReferenceOfPlansBuilder newInnerPlanReference = call.memoizeMemberPlansBuilder(innerReference, planPartition.getPlans());
                    for (InSource inSource : reverseSources) {
                        RecordQueryInJoinPlan inJoinPlan = inSource.toInJoinPlan(Quantifier.physical(newInnerPlanReference.reference()));
                        newInnerPlanReference = call.memoizePlanBuilder(inJoinPlan);
                    }
                    call.yieldPlans(newInnerPlanReference.members());
                });
            }
        }
    }

    @Nonnull
    private Stream<List<InSource>> enumerateInSourcesForRequestedOrdering(@Nonnull Map<CorrelationIdentifier, Quantifier> explodeAliasToQuantifierMap, @Nonnull Set<CorrelationIdentifier> explodeAliases, @Nonnull Map<Quantifier.ForEach, ExplodeExpression> quantifierToExplodeMap, @Nonnull Ordering innerOrdering, @Nonnull RequestedOrdering requestedOrdering) {
        Verify.verify(!explodeAliases.isEmpty());
        LinkedHashSet<CorrelationIdentifier> availableExplodeAliases = Sets.newLinkedHashSet(explodeAliases);
        List<OrderingPart.RequestedOrderingPart> requestedOrderingParts = requestedOrdering.getOrderingParts();
        SetMultimap<Value, Ordering.Binding> innerBindingMap = innerOrdering.getBindingMap();
        HashMultimap<Value, Ordering.Binding> resultOrderingBindingMap = HashMultimap.create(innerBindingMap);
        Stream<ImmutableList<Object>> prefixStream = Stream.of(ImmutableList.of());
        for (int i = 0; i < requestedOrderingParts.size() && !availableExplodeAliases.isEmpty(); ++i) {
            OrderingPart.RequestedOrderingPart requestedOrderingPart = requestedOrderingParts.get(i);
            Value requestedOrderingValue = requestedOrderingPart.getValue();
            Collection innerBindings = innerBindingMap.get((Object)requestedOrderingValue);
            if (innerBindings.isEmpty() || Ordering.sortOrder(innerBindings).isDirectional()) {
                return Stream.of(new List[0]);
            }
            ImmutableSet comparisonsCorrelatedTo = innerBindings.stream().flatMap(binding -> binding.getComparison().getCorrelatedTo().stream()).collect(ImmutableSet.toImmutableSet());
            if (comparisonsCorrelatedTo.size() > 1) {
                return Stream.of(new List[0]);
            }
            if (Sets.intersection(comparisonsCorrelatedTo, explodeAliases).isEmpty()) continue;
            CorrelationIdentifier explodeAlias = (CorrelationIdentifier)Iterables.getOnlyElement(comparisonsCorrelatedTo);
            if (!availableExplodeAliases.contains(explodeAlias)) {
                return Stream.empty();
            }
            Quantifier explodeQuantifier = Objects.requireNonNull(explodeAliasToQuantifierMap.get(explodeAlias));
            ExplodeExpression explodeExpression = Objects.requireNonNull(quantifierToExplodeMap.get((Quantifier.ForEach)explodeQuantifier));
            Value explodeValue = explodeExpression.getCollectionValue();
            if (!ImplementInJoinRule.isSupportedExplodeValue(explodeValue)) {
                return Stream.empty();
            }
            OrderingPart.RequestedSortOrder requestedSortOrder = requestedOrderingPart.getDirectionalSortOrderOrDefault(OrderingPart.RequestedSortOrder.ANY);
            List<OrderingPart.ProvidedSortOrder> attemptedSortOrders = requestedSortOrder == OrderingPart.RequestedSortOrder.ANY ? ImplementInJoinRule.attemptedProvidedSortOrdersForAny(requestedOrdering.isExhaustive()) : ImmutableList.of(requestedSortOrder.toProvidedSortOrder());
            prefixStream = prefixStream.flatMap(prefix -> attemptedSortOrders.stream().flatMap(attemptedSortOrder -> {
                InSource inSource = ImplementInJoinRule.computeInSource(explodeValue, explodeQuantifier, attemptedSortOrder);
                return inSource == null ? Stream.empty() : Stream.of(((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll((Iterable)prefix)).add(new OrderingPartWithSource(new OrderingPart.ProvidedOrderingPart(requestedOrderingPart.getValue(), (OrderingPart.ProvidedSortOrder)attemptedSortOrder), inSource))).build());
            }));
            availableExplodeAliases.remove(explodeAlias);
            resultOrderingBindingMap.removeAll(requestedOrderingValue);
        }
        if (availableExplodeAliases.isEmpty()) {
            prefixStream = prefixStream.flatMap(prefix -> {
                PartiallyOrderedSet<Value> filteredInnerOrderingSet;
                Ordering filteredInnerOrdering;
                ImmutableList.Builder outerOrderingValuesBuilder = ImmutableList.builder();
                ImmutableSetMultimap.Builder outerOrderingBindingMapBuilder = ImmutableSetMultimap.builder();
                for (OrderingPartWithSource orderingPartWithSource : prefix) {
                    OrderingPart.ProvidedOrderingPart outerProvidedOrderingPart = orderingPartWithSource.getProvidedOrderingPart();
                    Value outerOrderingValue = outerProvidedOrderingPart.getValue();
                    outerOrderingValuesBuilder.add(outerOrderingValue);
                    OrderingPart.ProvidedSortOrder outerProvidedSortOrder = (OrderingPart.ProvidedSortOrder)outerProvidedOrderingPart.getSortOrder();
                    Verify.verify(outerProvidedSortOrder.isDirectional());
                    outerOrderingBindingMapBuilder.put(outerOrderingValue, Ordering.Binding.sorted(outerProvidedSortOrder));
                }
                ImmutableCollection outerOrderingValues = outerOrderingValuesBuilder.build();
                Ordering outerOrdering = Ordering.ofOrderingSequence((SetMultimap<Value, Ordering.Binding>)((Object)outerOrderingBindingMapBuilder.build()), (List<? extends Value>)((Object)outerOrderingValues), true);
                Ordering concatenatedOrdering = Ordering.concatOrderings(outerOrdering, filteredInnerOrdering = Ordering.ofOrderingSet(resultOrderingBindingMap, filteredInnerOrderingSet = innerOrdering.getOrderingSet().filterElements(arg_0 -> ImplementInJoinRule.lambda$enumerateInSourcesForRequestedOrdering$4(innerOrdering, (ImmutableList)outerOrderingValues, arg_0)), innerOrdering.isDistinct()));
                return concatenatedOrdering.satisfies(requestedOrdering) ? Stream.of(prefix) : Stream.empty();
            });
        } else {
            List<OrderingPart.ProvidedSortOrder> attemptedSortOrders = requestedOrdering.isExhaustive() ? ImplementInJoinRule.attemptedProvidedSortOrdersForAny(requestedOrdering.isExhaustive()) : null;
            Iterable<List<Object>> availableExplodeAliasesPermutations = requestedOrdering.isExhaustive() ? TopologicalSort.permutations(availableExplodeAliases) : ImmutableList.of(ImmutableList.copyOf(availableExplodeAliases));
            prefixStream = prefixStream.flatMap(prefix -> ImplementInJoinRule.suffixForRemainingExplodes(explodeAliasToQuantifierMap, quantifierToExplodeMap, requestedOrdering, availableExplodeAliasesPermutations, attemptedSortOrders).map(suffix -> ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll((Iterable)prefix)).addAll((Iterable)suffix)).build()));
        }
        return prefixStream.map(orderingPartWithSources -> orderingPartWithSources.stream().map(OrderingPartWithSource::getInSource).collect(ImmutableList.toImmutableList()));
    }

    @Nonnull
    private static Stream<List<OrderingPartWithSource>> suffixForRemainingExplodes(@Nonnull Map<CorrelationIdentifier, Quantifier> explodeAliasToQuantifierMap, @Nonnull Map<Quantifier.ForEach, ExplodeExpression> quantifierToExplodeMap, @Nonnull RequestedOrdering requestedOrdering, @Nonnull Iterable<List<CorrelationIdentifier>> availableExplodeAliasesPermutations, @Nullable List<OrderingPart.ProvidedSortOrder> attemptedSortOrders) {
        return Streams.stream(availableExplodeAliasesPermutations).flatMap(availableExplodeAliasesPermutation -> {
            ImmutableList suffix = availableExplodeAliasesPermutation.stream().map(explodeAlias -> {
                Quantifier explodeQuantifier = Objects.requireNonNull((Quantifier)explodeAliasToQuantifierMap.get(explodeAlias));
                ExplodeExpression explodeExpression = Objects.requireNonNull((ExplodeExpression)quantifierToExplodeMap.get((Quantifier.ForEach)explodeQuantifier));
                Value explodeValue = explodeExpression.getCollectionValue();
                ImmutableList.Builder orderingResultsBuilder = ImmutableList.builder();
                if (attemptedSortOrders == null) {
                    Verify.verify(!requestedOrdering.isExhaustive());
                    InSource inSource = ImplementInJoinRule.computeInSource(explodeValue, explodeQuantifier, null);
                    if (inSource != null) {
                        orderingResultsBuilder.add(new OrderingPartWithSource(null, inSource));
                    }
                } else {
                    for (OrderingPart.ProvidedSortOrder attemptedSortOrder : attemptedSortOrders) {
                        InSource inSource = ImplementInJoinRule.computeInSource(explodeValue, explodeQuantifier, attemptedSortOrder);
                        if (inSource == null) continue;
                        orderingResultsBuilder.add(new OrderingPartWithSource(null, inSource));
                    }
                }
                return orderingResultsBuilder.build();
            }).collect(ImmutableList.toImmutableList());
            return Streams.stream(CrossProduct.crossProduct(suffix));
        });
    }

    private static boolean isSupportedExplodeValue(@Nonnull Value explodeValue) {
        return explodeValue instanceof LiteralValue || explodeValue instanceof QuantifiedObjectValue || explodeValue instanceof ParameterObjectValue || explodeValue.isConstant();
    }

    @Nonnull
    private static List<OrderingPart.ProvidedSortOrder> attemptedProvidedSortOrdersForAny(boolean isExhaustive) {
        if (isExhaustive) {
            return ImmutableList.of(OrderingPart.ProvidedSortOrder.ASCENDING, OrderingPart.ProvidedSortOrder.DESCENDING);
        }
        return ImmutableList.of(OrderingPart.ProvidedSortOrder.ASCENDING);
    }

    @Nullable
    private static InSource computeInSource(@Nonnull Value explodeValue, @Nonnull Quantifier explodeQuantifier, @Nullable OrderingPart.ProvidedSortOrder attemptedSortOrder) {
        String bindingName = Bindings.Internal.CORRELATION.bindingName(explodeQuantifier.getAlias().getId());
        if (explodeValue instanceof LiteralValue) {
            Object literalValue = ((LiteralValue)explodeValue).getLiteralValue();
            if (literalValue instanceof List) {
                return attemptedSortOrder == null ? new InValuesSource(bindingName, (List)literalValue) : new SortedInValuesSource(bindingName, (List)literalValue, attemptedSortOrder.isAnyDescending());
            }
            return null;
        }
        if (explodeValue instanceof QuantifiedObjectValue) {
            String alias = ((QuantifiedObjectValue)explodeValue).getAlias().getId();
            return attemptedSortOrder == null ? new InParameterSource(bindingName, alias) : new SortedInParameterSource(bindingName, alias, attemptedSortOrder.isAnyDescending());
        }
        if (explodeValue instanceof ParameterObjectValue) {
            String parameterName = ((ParameterObjectValue)explodeValue).getParameterName();
            return attemptedSortOrder == null ? new InParameterSource(bindingName, parameterName) : new SortedInParameterSource(bindingName, parameterName, attemptedSortOrder.isAnyDescending());
        }
        if (explodeValue.isConstant()) {
            return attemptedSortOrder == null ? new InComparandSource(bindingName, new Comparisons.ValueComparison(Comparisons.Type.IN, explodeValue)) : new SortedInComparandSource(bindingName, new Comparisons.ValueComparison(Comparisons.Type.IN, explodeValue), attemptedSortOrder.isAnyDescending());
        }
        return null;
    }

    @Nonnull
    private static Map<Quantifier.ForEach, ExplodeExpression> computeQuantifierToExplodeMap(@Nonnull Collection<? extends Quantifier.ForEach> quantifiers, @Nonnull Set<ExplodeExpression> explodeExpressions) {
        LinkedIdentityMap<Quantifier.ForEach, ExplodeExpression> resultMap = new LinkedIdentityMap<Quantifier.ForEach, ExplodeExpression>();
        block0: for (Quantifier.ForEach forEach : quantifiers) {
            Reference rangesOver = forEach.getRangesOver();
            for (ExplodeExpression explodeExpression : explodeExpressions) {
                if (!rangesOver.containsExactly(explodeExpression)) continue;
                resultMap.put(forEach, explodeExpression);
                continue block0;
            }
        }
        return resultMap;
    }

    private static /* synthetic */ boolean lambda$enumerateInSourcesForRequestedOrdering$4(Ordering innerOrdering, ImmutableList outerOrderingValues, Value value) {
        return innerOrdering.isSingularNonFixedValue(value) || !outerOrderingValues.contains(value);
    }

    private static class OrderingPartWithSource {
        @Nullable
        private final OrderingPart.ProvidedOrderingPart providedOrderingPart;
        @Nonnull
        private final InSource inSource;

        public OrderingPartWithSource(@Nullable OrderingPart.ProvidedOrderingPart providedOrderingPart, @Nonnull InSource inSource) {
            this.providedOrderingPart = providedOrderingPart;
            this.inSource = inSource;
        }

        @Nonnull
        public OrderingPart.ProvidedOrderingPart getProvidedOrderingPart() {
            return Objects.requireNonNull(this.providedOrderingPart);
        }

        @Nonnull
        public InSource getInSource() {
            return this.inSource;
        }
    }
}

