/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.Ordering;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.PlanPartition;
import com.apple.foundationdb.record.query.plan.cascades.PlanPartitions;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrdering;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrderingConstraint;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.expressions.ExplodeExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.properties.OrderingProperty;
import com.apple.foundationdb.record.query.plan.cascades.rules.PushRequestedOrderingThroughInLikeSelectRule;
import com.apple.foundationdb.record.query.plan.cascades.values.LiteralValue;
import com.apple.foundationdb.record.query.plan.cascades.values.ParameterObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.plans.InComparandSource;
import com.apple.foundationdb.record.query.plan.plans.InParameterSource;
import com.apple.foundationdb.record.query.plan.plans.InSource;
import com.apple.foundationdb.record.query.plan.plans.InValuesSource;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInUnionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQuerySetPlan;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class ImplementInUnionRule
extends ImplementationCascadesRule<SelectExpression> {
    private static final BindingMatcher<ExplodeExpression> explodeExpressionMatcher = RelationalExpressionMatchers.explodeExpression();
    private static final CollectionMatcher<Quantifier.ForEach> explodeQuantifiersMatcher = MultiMatcher.some(QuantifierMatchers.forEachQuantifier(explodeExpressionMatcher));
    private static final BindingMatcher<SelectExpression> root = RelationalExpressionMatchers.selectExpression(explodeQuantifiersMatcher);

    public ImplementInUnionRule() {
        super(root, ImmutableSet.of(RequestedOrderingConstraint.REQUESTED_ORDERING));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onMatch(@Nonnull ImplementationCascadesRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        Optional<Set<RequestedOrdering>> requestedOrderingsOptional = call.getPlannerConstraintMaybe(RequestedOrderingConstraint.REQUESTED_ORDERING);
        if (requestedOrderingsOptional.isEmpty()) {
            return;
        }
        Set<RequestedOrdering> requestedOrderings = requestedOrderingsOptional.get();
        SelectExpression selectExpression = bindings.get(root);
        if (!selectExpression.getPredicates().isEmpty()) {
            return;
        }
        Collection explodeQuantifiers = (Collection)((Object)bindings.get(explodeQuantifiersMatcher));
        if (explodeQuantifiers.isEmpty()) {
            return;
        }
        Set<CorrelationIdentifier> explodeAliases = Quantifiers.aliases(explodeQuantifiers);
        Optional<Quantifier.ForEach> innerQuantifierOptional = PushRequestedOrderingThroughInLikeSelectRule.findInnerQuantifier(selectExpression, explodeQuantifiers, explodeAliases);
        if (innerQuantifierOptional.isEmpty()) {
            return;
        }
        Quantifier.ForEach innerQuantifier = innerQuantifierOptional.get();
        Value resultValue = selectExpression.getResultValue();
        if (!(resultValue instanceof QuantifiedObjectValue) || !((QuantifiedObjectValue)resultValue).getAlias().equals(innerQuantifier.getAlias())) {
            return;
        }
        List<ExplodeExpression> explodeExpressions = bindings.getAll(explodeExpressionMatcher);
        Verify.verify(explodeExpressions.size() == explodeQuantifiers.size());
        ImmutableList.Builder sourcesBuilder = ImmutableList.builder();
        int i = 0;
        for (Quantifier.ForEach explodeQuantifier : explodeQuantifiers) {
            void var18_19;
            ExplodeExpression explodeExpression = explodeExpressions.get(i++);
            Value explodeCollectionValue = explodeExpression.getCollectionValue();
            String bindingName = Bindings.Internal.CORRELATION.bindingName(explodeQuantifier.getAlias().getId());
            if (explodeCollectionValue instanceof LiteralValue) {
                Object literalValue = ((LiteralValue)explodeCollectionValue).getLiteralValue();
                if (!(literalValue instanceof List)) return;
                InValuesSource inValuesSource = new InValuesSource(bindingName, (List)literalValue);
            } else if (explodeCollectionValue instanceof QuantifiedObjectValue) {
                InParameterSource inParameterSource = new InParameterSource(bindingName, ((QuantifiedObjectValue)explodeCollectionValue).getAlias().getId());
            } else if (explodeCollectionValue instanceof ParameterObjectValue) {
                InParameterSource inParameterSource = new InParameterSource(bindingName, ((ParameterObjectValue)explodeCollectionValue).getParameterName());
            } else {
                if (!explodeCollectionValue.isConstant()) return;
                InComparandSource inComparandSource = new InComparandSource(bindingName, new Comparisons.ValueComparison(Comparisons.Type.IN, explodeCollectionValue));
            }
            sourcesBuilder.add((Object)var18_19);
        }
        ImmutableCollection inSources = sourcesBuilder.build();
        Reference innerReference = innerQuantifier.getRangesOver();
        List<PlanPartition> planPartitions = PlanPartitions.rollUpTo(innerReference.toPlanPartitions(), OrderingProperty.ordering());
        int attemptFailedInJoinAsUnionMaxSize = call.getContext().getPlannerConfiguration().getAttemptFailedInJoinAsUnionMaxSize();
        for (PlanPartition planPartition : planPartitions) {
            Ordering providedOrdering = planPartition.getPartitionPropertyValue(OrderingProperty.ordering());
            for (RequestedOrdering requestedOrdering : requestedOrderings) {
                if (requestedOrdering.isPreserve()) continue;
                Map<Value, OrderingPart.RequestedSortOrder> valueRequestedSortOrderMap = requestedOrdering.getValueRequestedSortOrderMap();
                ImmutableSetMultimap.Builder adjustedBindingMapBuilder = ImmutableSetMultimap.builder();
                for (Map.Entry<Value, Collection<Ordering.Binding>> entry : providedOrdering.getBindingMap().asMap().entrySet()) {
                    Value value = entry.getKey();
                    adjustedBindingMapBuilder.putAll((Object)value, ImplementInUnionRule.adjustBindings(entry.getValue(), explodeAliases, valueRequestedSortOrderMap.get(value)));
                }
                ImmutableMultimap adjustedBindingsMap = adjustedBindingMapBuilder.build();
                Ordering.Union inUnionOrdering = Ordering.UNION.createOrdering((SetMultimap<Value, Ordering.Binding>)((Object)adjustedBindingsMap), providedOrdering.getOrderingSet(), providedOrdering.isDistinct());
                for (List<Value> satisfyingComparisonKeyValues : inUnionOrdering.enumerateSatisfyingComparisonKeyValues(requestedOrdering)) {
                    List<OrderingPart.ProvidedOrderingPart> comparisonOrderingParts = inUnionOrdering.directionalOrderingParts(satisfyingComparisonKeyValues, valueRequestedSortOrderMap, OrderingPart.ProvidedSortOrder.FIXED);
                    boolean comparisonIsReverse = RecordQuerySetPlan.resolveComparisonDirection(comparisonOrderingParts);
                    comparisonOrderingParts = RecordQuerySetPlan.adjustFixedBindings(comparisonOrderingParts, comparisonIsReverse);
                    Quantifier.Physical newInnerQuantifier = Quantifier.physical(call.memoizeMemberPlansFromOther(innerReference, planPartition.getPlans()));
                    call.yieldPlan(RecordQueryInUnionPlan.from(newInnerQuantifier, (List<? extends InSource>)((Object)inSources), comparisonOrderingParts, comparisonIsReverse, attemptFailedInJoinAsUnionMaxSize, Bindings.Internal.CORRELATION));
                }
            }
        }
    }

    @Nonnull
    private static Iterable<Ordering.Binding> adjustBindings(@Nonnull Collection<Ordering.Binding> bindings, @Nonnull Set<CorrelationIdentifier> explodeAliases, @Nullable OrderingPart.RequestedSortOrder requestedSortOrder) {
        OrderingPart.ProvidedSortOrder sortOrder = Ordering.sortOrder(bindings);
        if (sortOrder.isDirectional()) {
            return ImmutableList.of(Ordering.Binding.sorted(sortOrder));
        }
        Debugger.sanityCheck(() -> Verify.verify(Ordering.areAllBindingsFixed(bindings)));
        if (Ordering.hasMultipleFixedBindings(bindings)) {
            return bindings;
        }
        Ordering.Binding binding = Ordering.fixedBinding(bindings);
        Comparisons.Comparison comparison = binding.getComparison();
        if (comparison.getType() != Comparisons.Type.EQUALS) {
            return bindings;
        }
        if (comparison instanceof Comparisons.ParameterComparison) {
            Comparisons.ParameterComparison parameterComparison = (Comparisons.ParameterComparison)comparison;
            if (!parameterComparison.isCorrelation() || !explodeAliases.containsAll(parameterComparison.getCorrelatedTo())) {
                return bindings;
            }
        } else if (comparison instanceof Comparisons.ValueComparison) {
            Comparisons.ValueComparison valueComparison = (Comparisons.ValueComparison)comparison;
            if (!explodeAliases.containsAll(valueComparison.getCorrelatedTo())) {
                return bindings;
            }
        } else {
            return bindings;
        }
        if (requestedSortOrder == null || requestedSortOrder == OrderingPart.RequestedSortOrder.ANY) {
            return ImmutableList.of(Ordering.Binding.choose());
        }
        if (!requestedSortOrder.isDirectional()) {
            return bindings;
        }
        return ImmutableList.of(Ordering.Binding.sorted(requestedSortOrder.toProvidedSortOrder()));
    }
}

