/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.PlanPartition;
import com.apple.foundationdb.record.query.plan.cascades.PlanPropertiesMap;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalIntersectionExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.AnyMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlanPartitionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RecordQueryPlanMatchers;
import com.apple.foundationdb.record.query.plan.cascades.properties.DistinctRecordsProperty;
import com.apple.foundationdb.record.query.plan.cascades.properties.OrderingProperty;
import com.apple.foundationdb.record.query.plan.cascades.properties.StoredRecordProperty;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionPlan;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class ImplementIntersectionRule
extends ImplementationCascadesRule<LogicalIntersectionExpression> {
    @Nonnull
    private static final BindingMatcher<PlanPartition> intersectionLegPlanPartitionMatcher = PlanPartitionMatchers.anyPlanPartition();
    @Nonnull
    private static final BindingMatcher<Reference> intersectionLegReferenceMatcher = PlanPartitionMatchers.planPartitions(PlanPartitionMatchers.filterPlanPartitions(planPartition -> planPartition.getPartitionPropertyValue(StoredRecordProperty.storedRecord()), PlanPartitionMatchers.rollUpPartitionsTo(AnyMatcher.any(intersectionLegPlanPartitionMatcher), PlanPropertiesMap.allAttributesExcept(DistinctRecordsProperty.distinctRecords(), OrderingProperty.ordering()))));
    @Nonnull
    private static final CollectionMatcher<Quantifier.ForEach> allForEachQuantifiersMatcher = MultiMatcher.all(QuantifierMatchers.forEachQuantifierOverRef(intersectionLegReferenceMatcher));
    @Nonnull
    private static final BindingMatcher<LogicalIntersectionExpression> root = RecordQueryPlanMatchers.logicalIntersectionExpression(allForEachQuantifiersMatcher);

    public ImplementIntersectionRule() {
        super(root);
    }

    @Override
    public void onMatch(@Nonnull ImplementationCascadesRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        LogicalIntersectionExpression logicalIntersectionExpression = bindings.get(root);
        Collection allQuantifiers = (Collection)((Object)bindings.get(allForEachQuantifiersMatcher));
        List<PlanPartition> planPartitionsByQuantifier = bindings.getAll(intersectionLegPlanPartitionMatcher);
        ImmutableList<Quantifier.Physical> newQuantifiers = Streams.zip(planPartitionsByQuantifier.stream(), allQuantifiers.stream(), (planPartition, quantifier) -> call.memoizeMemberPlansFromOther(quantifier.getRangesOver(), planPartition.getPlans())).map(Quantifier::physical).collect(ImmutableList.toImmutableList());
        call.yieldPlan(RecordQueryIntersectionPlan.fromQuantifiers(newQuantifiers, logicalIntersectionExpression.getComparisonKeyProvidedOrderingParts(), Quantifiers.isReversed(newQuantifiers)));
    }
}

