/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.PlanPartition;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrdering;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrderingConstraint;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlanPartitionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.SetMatcher;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.values.NullValue;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryDefaultOnEmptyPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFirstOrDefaultPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFlatMapPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPredicatesFilterPlan;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.EXPERIMENTAL)
public class ImplementNestedLoopJoinRule
extends ImplementationCascadesRule<SelectExpression> {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger(ImplementNestedLoopJoinRule.class);
    @Nonnull
    private static final BindingMatcher<PlanPartition> outerPlanPartitionsMatcher = PlanPartitionMatchers.anyPlanPartition();
    @Nonnull
    private static final BindingMatcher<Reference> outerReferenceMatcher = PlanPartitionMatchers.planPartitions(PlanPartitionMatchers.rollUpPartitions(MultiMatcher.all(outerPlanPartitionsMatcher)));
    @Nonnull
    private static final BindingMatcher<Quantifier> outerQuantifierMatcher = QuantifierMatchers.anyQuantifierOverRef(outerReferenceMatcher);
    @Nonnull
    private static final BindingMatcher<PlanPartition> innerPlanPartitionsMatcher = PlanPartitionMatchers.anyPlanPartition();
    @Nonnull
    private static final BindingMatcher<Reference> innerReferenceMatcher = PlanPartitionMatchers.planPartitions(PlanPartitionMatchers.rollUpPartitions(MultiMatcher.all(innerPlanPartitionsMatcher)));
    @Nonnull
    private static final BindingMatcher<Quantifier> innerQuantifierMatcher = QuantifierMatchers.anyQuantifierOverRef(innerReferenceMatcher);
    @Nonnull
    private static final BindingMatcher<SelectExpression> root = RelationalExpressionMatchers.selectExpression(SetMatcher.exactlyInAnyOrder(outerQuantifierMatcher, innerQuantifierMatcher)).where(RelationalExpressionMatchers.canBeImplemented());

    public ImplementNestedLoopJoinRule() {
        super(root, ImmutableSet.of(RequestedOrderingConstraint.REQUESTED_ORDERING));
    }

    @Override
    public void onMatch(@Nonnull ImplementationCascadesRuleCall call) {
        Optional<Set<RequestedOrdering>> requestedOrderingsOptional = call.getPlannerConstraintMaybe(RequestedOrderingConstraint.REQUESTED_ORDERING);
        if (requestedOrderingsOptional.isEmpty()) {
            return;
        }
        Set<RequestedOrdering> requestedOrderings = requestedOrderingsOptional.get();
        PlannerBindings bindings = call.getBindings();
        SelectExpression selectExpression = bindings.get(root);
        Debugger.withDebugger(debugger -> logger.debug(KeyValueLogMessage.of("matched SelectExpression", "legs", selectExpression.getQuantifiers().size())));
        Quantifier outerQuantifier = bindings.get(outerQuantifierMatcher);
        Quantifier innerQuantifier = bindings.get(innerQuantifierMatcher);
        Reference outerReference = bindings.get(outerReferenceMatcher);
        Reference innerReference = bindings.get(innerReferenceMatcher);
        PlanPartition outerPartition = bindings.get(outerPlanPartitionsMatcher);
        PlanPartition innerPartition = bindings.get(innerPlanPartitionsMatcher);
        String joinName = Debugger.mapDebugger(debugger -> debugger.nameForObject(call.getRoot()) + "[" + debugger.nameForObject(selectExpression) + "]: " + String.valueOf(outerQuantifier.getAlias()) + " \u2a1d " + String.valueOf(innerQuantifier.getAlias())).orElse("not in debug mode");
        Debugger.withDebugger(debugger -> logger.debug(KeyValueLogMessage.of("attempting join", "joinedTables", joinName, "requestedOrderings", requestedOrderings)));
        ImmutableSetMultimap<CorrelationIdentifier, CorrelationIdentifier> fullCorrelationOrder = selectExpression.getCorrelationOrder().getTransitiveClosure();
        Map<CorrelationIdentifier, ? extends Quantifier> aliasToQuantifierMap = selectExpression.getAliasToQuantifierMap();
        CorrelationIdentifier outerAlias = outerQuantifier.getAlias();
        CorrelationIdentifier innerAlias = innerQuantifier.getAlias();
        ImmutableCollection outerDependencies = fullCorrelationOrder.get((Object)outerAlias);
        if (outerDependencies.contains(innerAlias)) {
            return;
        }
        ImmutableList.Builder outerPredicatesBuilder = ImmutableList.builder();
        ImmutableList.Builder outerInnerPredicatesBuilder = ImmutableList.builder();
        for (QueryPredicate queryPredicate : selectExpression.getPredicates()) {
            Sets.SetView<CorrelationIdentifier> correlatedToInExpression = Sets.intersection(queryPredicate.getCorrelatedTo(), aliasToQuantifierMap.keySet());
            boolean isEligible = correlatedToInExpression.stream().allMatch(alias -> alias.equals(outerAlias) || alias.equals(innerAlias));
            Verify.verify(isEligible);
            QueryPredicate residualPredicate = queryPredicate.toResidualPredicate();
            if (correlatedToInExpression.contains(innerAlias)) {
                outerInnerPredicatesBuilder.add(residualPredicate);
                continue;
            }
            Verify.verify(correlatedToInExpression.contains(outerAlias) || correlatedToInExpression.isEmpty());
            outerPredicatesBuilder.add(residualPredicate);
        }
        ImmutableCollection outerPredicates = outerPredicatesBuilder.build();
        ImmutableCollection immutableCollection = outerInnerPredicatesBuilder.build();
        Reference outerRef = call.memoizeMemberPlansFromOther(outerReference, outerPartition.getPlans());
        if (outerQuantifier instanceof Quantifier.Existential) {
            outerRef = call.memoizePlan(new RecordQueryFirstOrDefaultPlan(((Quantifier.Physical.PhysicalBuilder)Quantifier.physicalBuilder().withAlias(outerAlias)).build(outerRef), new NullValue(outerQuantifier.getFlowedObjectType())));
        } else if (outerQuantifier instanceof Quantifier.ForEach && ((Quantifier.ForEach)outerQuantifier).isNullOnEmpty()) {
            outerRef = call.memoizePlan(new RecordQueryDefaultOnEmptyPlan(((Quantifier.Physical.PhysicalBuilder)Quantifier.physicalBuilder().withAlias(outerAlias)).build(outerRef), new NullValue(outerQuantifier.getFlowedObjectType())));
        }
        if (!outerPredicates.isEmpty()) {
            Quantifier.Physical newOuterLowerQuantifier = ((Quantifier.Physical.PhysicalBuilder)Quantifier.physicalBuilder().withAlias(outerAlias)).build(outerRef);
            outerRef = call.memoizePlan(new RecordQueryPredicatesFilterPlan(newOuterLowerQuantifier, outerPredicates));
        }
        Quantifier.Physical newOuterQuantifier = ((Quantifier.Physical.PhysicalBuilder)Quantifier.physicalBuilder().withAlias(outerAlias)).build(outerRef);
        Reference innerRef = call.memoizeMemberPlansFromOther(innerReference, innerPartition.getPlans());
        if (innerQuantifier instanceof Quantifier.Existential) {
            innerRef = call.memoizePlan(new RecordQueryFirstOrDefaultPlan(((Quantifier.Physical.PhysicalBuilder)Quantifier.physicalBuilder().withAlias(innerAlias)).build(innerRef), new NullValue(innerQuantifier.getFlowedObjectType())));
        }
        if (!immutableCollection.isEmpty()) {
            Quantifier.Physical newInnerLowerQuantifier = ((Quantifier.Physical.PhysicalBuilder)Quantifier.physicalBuilder().withAlias(innerAlias)).build(innerRef);
            innerRef = call.memoizePlan(new RecordQueryPredicatesFilterPlan(newInnerLowerQuantifier, immutableCollection));
        }
        Quantifier.Physical newInnerQuantifier = ((Quantifier.Physical.PhysicalBuilder)Quantifier.physicalBuilder().withAlias(innerAlias)).build(innerRef);
        call.yieldPlan(new RecordQueryFlatMapPlan(newOuterQuantifier, newInnerQuantifier, selectExpression.getResultValue(), innerQuantifier instanceof Quantifier.Existential));
    }
}

