/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.PlanPartition;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RecursiveUnionExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.AnyMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlanPartitionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RecordQueryPlanMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryRecursiveLevelUnionPlan;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class ImplementRecursiveLevelUnionRule
extends ImplementationCascadesRule<RecursiveUnionExpression> {
    @Nonnull
    private static final BindingMatcher<PlanPartition> initialPlanPartitionsMatcher = PlanPartitionMatchers.anyPlanPartition();
    @Nonnull
    private static final BindingMatcher<Quantifier.ForEach> initialQunMatcher = QuantifierMatchers.forEachQuantifierOverRef(PlanPartitionMatchers.planPartitions(PlanPartitionMatchers.rollUpPartitions(AnyMatcher.any(initialPlanPartitionsMatcher))));
    @Nonnull
    private static final BindingMatcher<PlanPartition> recursivePlanPartitionsMatcher = PlanPartitionMatchers.anyPlanPartition();
    @Nonnull
    private static final BindingMatcher<Quantifier.ForEach> recursiveQunMatcher = QuantifierMatchers.forEachQuantifierOverRef(PlanPartitionMatchers.planPartitions(PlanPartitionMatchers.rollUpPartitions(AnyMatcher.any(recursivePlanPartitionsMatcher))));
    @Nonnull
    private static final BindingMatcher<RecursiveUnionExpression> root = RelationalExpressionMatchers.recursiveUnionExpression(initialQunMatcher, recursiveQunMatcher).where(RecordQueryPlanMatchers.levelTraversalIsAllowed());

    public ImplementRecursiveLevelUnionRule() {
        super(root);
    }

    @Override
    public void onMatch(@Nonnull ImplementationCascadesRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        RecursiveUnionExpression recursiveUnionExpression = bindings.get(root);
        PlanPartition initialPlanPartitions = bindings.get(initialPlanPartitionsMatcher);
        Quantifier.ForEach initialQun = bindings.get(initialQunMatcher);
        Quantifier.Physical initialPhysicalQun = Quantifier.physical(call.memoizeMemberPlansFromOther(initialQun.getRangesOver(), initialPlanPartitions.getPlans()));
        PlanPartition recursivePlanPartitions = bindings.get(recursivePlanPartitionsMatcher);
        Quantifier.ForEach recursiveQun = bindings.get(recursiveQunMatcher);
        Quantifier.Physical recursivePhysicalQun = Quantifier.physical(call.memoizeMemberPlansFromOther(recursiveQun.getRangesOver(), recursivePlanPartitions.getPlans()));
        CorrelationIdentifier tempTableScanValueReference = recursiveUnionExpression.getTempTableScanAlias();
        CorrelationIdentifier tempTableInsertValueReference = recursiveUnionExpression.getTempTableInsertAlias();
        RecordQueryRecursiveLevelUnionPlan recursiveUnionPlan = new RecordQueryRecursiveLevelUnionPlan(initialPhysicalQun, recursivePhysicalQun, tempTableScanValueReference, tempTableInsertValueReference);
        call.yieldPlan(recursiveUnionPlan);
    }
}

