/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.Memoizer;
import com.apple.foundationdb.record.query.plan.cascades.PlanPartition;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.AnyMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ListMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlanPartitionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QueryPredicateMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.values.NullValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryDefaultOnEmptyPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFirstOrDefaultPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryMapPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPredicatesFilterPlan;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class ImplementSimpleSelectRule
extends ImplementationCascadesRule<SelectExpression> {
    @Nonnull
    private static final BindingMatcher<PlanPartition> innerPlanPartitionMatcher = PlanPartitionMatchers.anyPlanPartition();
    @Nonnull
    private static final BindingMatcher<Reference> innerReferenceMatcher = PlanPartitionMatchers.planPartitions(AnyMatcher.any(innerPlanPartitionMatcher));
    @Nonnull
    private static final BindingMatcher<Quantifier> innerQuantifierMatcher = QuantifierMatchers.anyQuantifierOverRef(innerReferenceMatcher);
    @Nonnull
    private static final BindingMatcher<QueryPredicate> predicateMatcher = QueryPredicateMatchers.anyPredicate();
    @Nonnull
    private static final BindingMatcher<SelectExpression> root = RelationalExpressionMatchers.selectExpression(MultiMatcher.all(predicateMatcher), ListMatcher.exactly(innerQuantifierMatcher));

    public ImplementSimpleSelectRule() {
        super(root);
    }

    @Override
    public void onMatch(@Nonnull ImplementationCascadesRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        SelectExpression selectExpression = bindings.get(root);
        PlanPartition planPartition = bindings.get(innerPlanPartitionMatcher);
        Reference innerReference = bindings.get(innerReferenceMatcher);
        Quantifier quantifier = bindings.get(innerQuantifierMatcher);
        List<QueryPredicate> predicates = bindings.getAll(predicateMatcher);
        Value resultValue = selectExpression.getResultValue();
        Memoizer.ReferenceOfPlansBuilder referenceBuilder = ImplementSimpleSelectRule.implementSelectExpression(call, resultValue, predicates, innerReference, quantifier, planPartition);
        call.yieldPlans(referenceBuilder.members());
    }

    @Nonnull
    public static Memoizer.ReferenceOfPlansBuilder implementSelectExpression(@Nonnull ImplementationCascadesRuleCall call, @Nonnull Value result, @Nonnull List<? extends QueryPredicate> predicates, @Nonnull Reference innerReference, @Nonnull Quantifier innerQuantifier, @Nonnull PlanPartition innerPlanPartition) {
        boolean isSimpleResultValue;
        Value resultValue = result;
        Memoizer.ReferenceOfPlansBuilder referenceBuilder = call.memoizeMemberPlansBuilder(innerReference, innerPlanPartition.getPlans());
        boolean bl = isSimpleResultValue = resultValue instanceof QuantifiedObjectValue && ((QuantifiedObjectValue)resultValue).getAlias().equals(innerQuantifier.getAlias());
        if (innerQuantifier instanceof Quantifier.Existential) {
            referenceBuilder = call.memoizePlanBuilder(new RecordQueryFirstOrDefaultPlan(((Quantifier.Physical.PhysicalBuilder)Quantifier.physicalBuilder().withAlias(innerQuantifier.getAlias())).build(referenceBuilder.reference()), new NullValue(innerQuantifier.getFlowedObjectType())));
        } else if (innerQuantifier instanceof Quantifier.ForEach && ((Quantifier.ForEach)innerQuantifier).isNullOnEmpty()) {
            referenceBuilder = call.memoizePlanBuilder(new RecordQueryDefaultOnEmptyPlan(((Quantifier.Physical.PhysicalBuilder)Quantifier.physicalBuilder().withAlias(innerQuantifier.getAlias())).build(referenceBuilder.reference()), new NullValue(innerQuantifier.getFlowedObjectType())));
        }
        ImmutableList nonTautologyPredicates = predicates.stream().filter(predicate -> !predicate.isTautology()).collect(ImmutableList.toImmutableList());
        if (nonTautologyPredicates.isEmpty() && isSimpleResultValue) {
            return referenceBuilder;
        }
        if (!nonTautologyPredicates.isEmpty()) {
            referenceBuilder = call.memoizePlanBuilder(new RecordQueryPredicatesFilterPlan(((Quantifier.Physical.PhysicalBuilder)Quantifier.physicalBuilder().withAlias(innerQuantifier.getAlias())).build(referenceBuilder.reference()), nonTautologyPredicates.stream().map(QueryPredicate::toResidualPredicate).collect(ImmutableList.toImmutableList())));
        }
        if (!isSimpleResultValue) {
            Quantifier.Physical beforeMapQuantifier;
            if (!nonTautologyPredicates.isEmpty()) {
                CorrelationIdentifier lowerAlias = innerQuantifier.getAlias();
                beforeMapQuantifier = Quantifier.physical(referenceBuilder.reference());
                resultValue = resultValue.rebase(AliasMap.ofAliases(lowerAlias, beforeMapQuantifier.getAlias()));
            } else {
                beforeMapQuantifier = ((Quantifier.Physical.PhysicalBuilder)Quantifier.physicalBuilder().withAlias(innerQuantifier.getAlias())).build(referenceBuilder.reference());
            }
            referenceBuilder = call.memoizePlanBuilder(new RecordQueryMapPlan(beforeMapQuantifier, resultValue));
        }
        return referenceBuilder;
    }
}

