/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.Ordering;
import com.apple.foundationdb.record.query.plan.cascades.PlanPartition;
import com.apple.foundationdb.record.query.plan.cascades.PlanPartitions;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrderingConstraint;
import com.apple.foundationdb.record.query.plan.cascades.expressions.GroupByExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.AnyMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ReferenceMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ValueMatchers;
import com.apple.foundationdb.record.query.plan.cascades.properties.OrderingProperty;
import com.apple.foundationdb.record.query.plan.cascades.values.AggregateValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.Values;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.DefaultValueSimplificationRuleSet;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryStreamingAggregationPlan;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class ImplementStreamingAggregationRule
extends ImplementationCascadesRule<GroupByExpression> {
    @Nonnull
    private static final BindingMatcher<Reference> lowerRefMatcher = ReferenceMatchers.anyRef();
    @Nonnull
    private static final BindingMatcher<Quantifier.ForEach> innerQuantifierMatcher = QuantifierMatchers.forEachQuantifierOverRef(lowerRefMatcher);
    @Nonnull
    private static final BindingMatcher<GroupByExpression> root = RelationalExpressionMatchers.groupByExpression(ValueMatchers.recordConstructorValue(MultiMatcher.all(ValueMatchers.streamableAggregateValue())), AnyMatcher.any(innerQuantifierMatcher));

    public ImplementStreamingAggregationRule() {
        super(root, ImmutableSet.of(RequestedOrderingConstraint.REQUESTED_ORDERING));
    }

    @Override
    public void onMatch(@Nonnull ImplementationCascadesRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        GroupByExpression groupByExpression = bindings.get(root);
        Set<CorrelationIdentifier> correlatedTo = groupByExpression.getCorrelatedTo();
        Quantifier innerQuantifier = Iterables.getOnlyElement(groupByExpression.getQuantifiers());
        Value groupingValue = groupByExpression.getGroupingValue();
        Value currentGroupingValue = groupingValue == null ? null : groupingValue.rebase(AliasMap.ofAliases(innerQuantifier.getAlias(), Quantifier.current()));
        ImmutableSet<Value> requiredOrderingKeyValues = currentGroupingValue == null ? null : ImmutableSet.copyOf(Values.simplify(Values.primitiveAccessorsForType(currentGroupingValue.getResultType(), () -> currentGroupingValue), DefaultValueSimplificationRuleSet.instance(), call.getEvaluationContext(), AliasMap.emptyMap(), correlatedTo));
        Reference innerReference = innerQuantifier.getRangesOver();
        List<PlanPartition> planPartitions = PlanPartitions.rollUpTo(innerReference.toPlanPartitions(), OrderingProperty.ordering());
        for (PlanPartition planPartition : planPartitions) {
            Ordering providedOrdering = planPartition.getPartitionPropertyValue(OrderingProperty.ordering());
            if (requiredOrderingKeyValues != null && !providedOrdering.satisfiesGroupingValues(requiredOrderingKeyValues)) continue;
            call.yieldPlan(this.implementGroupBy(call, planPartition, groupByExpression));
        }
    }

    @Nonnull
    private RecordQueryStreamingAggregationPlan implementGroupBy(@Nonnull ImplementationCascadesRuleCall call, @Nonnull PlanPartition planPartition, @Nonnull GroupByExpression groupByExpression) {
        Quantifier innerQuantifier = Iterables.getOnlyElement(groupByExpression.getQuantifiers());
        Reference newInnerPlanReference = call.memoizeMemberPlansFromOther(innerQuantifier.getRangesOver(), planPartition.getPlans());
        Quantifier.Physical newPlanQuantifier = Quantifier.physical(newInnerPlanReference);
        AliasMap aliasMap = AliasMap.ofAliases(innerQuantifier.getAlias(), newPlanQuantifier.getAlias());
        Value rebasedAggregatedValue = groupByExpression.getAggregateValue().rebase(aliasMap);
        Value rebasedGroupingValue = groupByExpression.getGroupingValue() == null ? null : groupByExpression.getGroupingValue().rebase(aliasMap);
        return RecordQueryStreamingAggregationPlan.of(newPlanQuantifier, rebasedGroupingValue, (AggregateValue)rebasedAggregatedValue, groupByExpression.getResultValueFunction());
    }
}

