/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentitySet;
import com.apple.foundationdb.record.query.plan.cascades.PlanPartition;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalTypeFilterExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.AnyMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ListMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlanPartitionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.properties.RecordTypesProperty;
import com.apple.foundationdb.record.query.plan.cascades.properties.StoredRecordProperty;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTypeFilterPlan;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class ImplementTypeFilterRule
extends ImplementationCascadesRule<LogicalTypeFilterExpression> {
    @Nonnull
    private static final BindingMatcher<PlanPartition> innerPlanPartitionMatcher = PlanPartitionMatchers.anyPlanPartition();
    @Nonnull
    private static final BindingMatcher<Reference> innerReferenceMatcher = PlanPartitionMatchers.planPartitions(PlanPartitionMatchers.filterPlanPartitions(planPartition -> planPartition.getPartitionPropertyValue(StoredRecordProperty.storedRecord()), AnyMatcher.any(innerPlanPartitionMatcher)));
    @Nonnull
    private static final BindingMatcher<LogicalTypeFilterExpression> root = RelationalExpressionMatchers.logicalTypeFilterExpression(ListMatcher.exactly(QuantifierMatchers.forEachQuantifierOverRef(innerReferenceMatcher)));

    public ImplementTypeFilterRule() {
        super(root);
    }

    @Override
    public void onMatch(@Nonnull ImplementationCascadesRuleCall call) {
        LogicalTypeFilterExpression logicalTypeFilterExpression = call.get(root);
        Reference innerReference = call.get(innerReferenceMatcher);
        PlanPartition planPartition = call.get(innerPlanPartitionMatcher);
        LinkedIdentitySet<RecordQueryPlan> noTypeFilterNeeded = new LinkedIdentitySet<RecordQueryPlan>();
        ImmutableMultimap.Builder unsatisfiedMapBuilder = ImmutableMultimap.builder();
        for (RecordQueryPlan innerPlan : planPartition.getPlans()) {
            Set childRecordTypes = (Set)new RecordTypesProperty.RecordTypesVisitor(call.newAliasResolver()).visit(innerPlan);
            HashSet filterRecordTypes = Sets.newHashSet(logicalTypeFilterExpression.getRecordTypes());
            if (filterRecordTypes.containsAll(childRecordTypes)) {
                noTypeFilterNeeded.add(innerPlan);
                continue;
            }
            unsatisfiedMapBuilder.put(Sets.intersection(filterRecordTypes, childRecordTypes), innerPlan);
        }
        ImmutableMultimap unsatisfiedMap = unsatisfiedMapBuilder.build();
        if (!noTypeFilterNeeded.isEmpty()) {
            call.yieldPlans(noTypeFilterNeeded);
        }
        for (Map.Entry unsatisfiedEntry : ((ImmutableMap)unsatisfiedMap.asMap()).entrySet()) {
            call.yieldPlan(new RecordQueryTypeFilterPlan(Quantifier.physical(call.memoizeMemberPlansFromOther(innerReference, (Collection)unsatisfiedEntry.getValue())), (Collection)unsatisfiedEntry.getKey(), Type.Relation.scalarOf(logicalTypeFilterExpression.getResultType())));
        }
    }
}

