/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.PlanPartition;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalUnionExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.AnyMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlanPartitionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedUnionPlan;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class ImplementUnorderedUnionRule
extends ImplementationCascadesRule<LogicalUnionExpression> {
    @Nonnull
    private static final BindingMatcher<PlanPartition> unionLegPlanPartitionsMatcher = PlanPartitionMatchers.anyPlanPartition();
    @Nonnull
    private static final BindingMatcher<Reference> unionLegReferenceMatcher = PlanPartitionMatchers.planPartitions(PlanPartitionMatchers.rollUpPartitions(AnyMatcher.any(unionLegPlanPartitionsMatcher)));
    @Nonnull
    private static final CollectionMatcher<Quantifier.ForEach> allForEachQuantifiersMatcher = MultiMatcher.all(QuantifierMatchers.forEachQuantifierOverRef(unionLegReferenceMatcher));
    @Nonnull
    private static final BindingMatcher<LogicalUnionExpression> root = RelationalExpressionMatchers.logicalUnionExpression(allForEachQuantifiersMatcher);

    public ImplementUnorderedUnionRule() {
        super(root);
    }

    @Override
    public void onMatch(@Nonnull ImplementationCascadesRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        List<PlanPartition> planPartitions = bindings.getAll(unionLegPlanPartitionsMatcher);
        Collection allQuantifiers = (Collection)((Object)bindings.get(allForEachQuantifiersMatcher));
        ImmutableList<Quantifier.Physical> quantifiers = Streams.zip(planPartitions.stream(), allQuantifiers.stream(), (planPartition, quantifier) -> call.memoizeMemberPlansFromOther(quantifier.getRangesOver(), planPartition.getPlans())).map(Quantifier::physical).collect(ImmutableList.toImmutableList());
        call.yieldPlan(RecordQueryUnorderedUnionPlan.fromQuantifiers(quantifiers));
    }
}

