/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.cascades.Column;
import com.apple.foundationdb.record.query.plan.cascades.ExplorationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ExplorationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.expressions.ExplodeExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QueryPredicateMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ValueMatchers;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ValuePredicate;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.ArrayDistinctValue;
import com.apple.foundationdb.record.query.plan.cascades.values.BooleanValue;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.LiteralValue;
import com.apple.foundationdb.record.query.plan.cascades.values.ParameterObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RelOpValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.Values;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class InComparisonToExplodeRule
extends ExplorationCascadesRule<SelectExpression> {
    private static final BindingMatcher<ValuePredicate> inPredicateMatcher = QueryPredicateMatchers.valuePredicate(ValueMatchers.anyValue(), QueryPredicateMatchers.anyComparisonOfType(Comparisons.Type.IN));
    private static final BindingMatcher<Quantifier.ForEach> innerQuantifierMatcher = QuantifierMatchers.forEachQuantifier();
    private static final BindingMatcher<SelectExpression> root = RelationalExpressionMatchers.selectExpression(MultiMatcher.some(inPredicateMatcher), MultiMatcher.all(innerQuantifierMatcher));

    public InComparisonToExplodeRule() {
        super(root);
    }

    @Override
    public void onMatch(@Nonnull ExplorationCascadesRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        SelectExpression selectExpression = bindings.get(root);
        List<ValuePredicate> inPredicatesList = bindings.getAll(inPredicateMatcher);
        if (inPredicatesList.isEmpty()) {
            return;
        }
        Set<ValuePredicate> inPredicates = Sets.newIdentityHashSet();
        inPredicates.addAll(inPredicatesList);
        ImmutableList.Builder transformedQuantifiers = ImmutableList.builder();
        ImmutableList.Builder transformedPredicates = ImmutableList.builder();
        for (QueryPredicate queryPredicate : selectExpression.getPredicates()) {
            if (inPredicates.contains(queryPredicate)) {
                Quantifier.ForEach newQuantifier;
                ExplodeExpression explodeExpression;
                ValuePredicate valuePredicate = (ValuePredicate)queryPredicate;
                Value value = valuePredicate.getValue();
                Type elementType = value.getResultType();
                Comparisons.Comparison comparison = valuePredicate.getComparison();
                Verify.verify(comparison.getType() == Comparisons.Type.IN);
                if (comparison instanceof Comparisons.ValueComparison) {
                    Comparisons.ValueComparison comparisonValue = (Comparisons.ValueComparison)comparison;
                    Verify.verify(comparisonValue.getComparandValue().getResultType().isArray());
                    Type arrayElementType = ((Type.Array)comparisonValue.getComparandValue().getResultType()).getElementType();
                    Verify.verify(arrayElementType != null);
                    explodeExpression = new ExplodeExpression(new ArrayDistinctValue(comparisonValue.getComparandValue()));
                    newQuantifier = Quantifier.forEach(call.memoizeExploratoryExpression(explodeExpression));
                    if (arrayElementType.isRecord()) {
                        transformedPredicates.addAll(InComparisonToExplodeRule.createSimpleEqualitiesForRecordTypeValue(value, newQuantifier));
                    } else {
                        transformedPredicates.add(new ValuePredicate(value, new Comparisons.ValueComparison(Comparisons.Type.EQUALS, QuantifiedObjectValue.of(newQuantifier.getAlias(), elementType))));
                    }
                } else if (comparison instanceof Comparisons.ListComparison) {
                    Comparisons.ListComparison listComparison = (Comparisons.ListComparison)comparison;
                    explodeExpression = new ExplodeExpression(LiteralValue.ofList(listComparison.getComparand((FDBRecordStoreBase)null, (EvaluationContext)null)));
                    newQuantifier = Quantifier.forEach(call.memoizeExploratoryExpression(explodeExpression));
                    transformedPredicates.add(new ValuePredicate(value, new Comparisons.ValueComparison(Comparisons.Type.EQUALS, QuantifiedObjectValue.of(newQuantifier.getAlias(), elementType))));
                } else if (comparison instanceof Comparisons.ParameterComparison) {
                    explodeExpression = new ExplodeExpression(ParameterObjectValue.of(((Comparisons.ParameterComparison)comparison).getParameter(), new Type.Array(elementType)));
                    newQuantifier = Quantifier.forEach(call.memoizeExploratoryExpression(explodeExpression));
                    transformedPredicates.add(new ValuePredicate(value, new Comparisons.ValueComparison(Comparisons.Type.EQUALS, QuantifiedObjectValue.of(newQuantifier.getAlias(), elementType))));
                } else {
                    throw new RecordCoreException("unknown in comparison " + comparison.getClass().getSimpleName(), new Object[0]);
                }
                transformedQuantifiers.add(newQuantifier);
                continue;
            }
            transformedPredicates.add(queryPredicate);
        }
        transformedQuantifiers.addAll(bindings.getAll(innerQuantifierMatcher));
        call.yieldExploratoryExpression(new SelectExpression(selectExpression.getResultValue(), (List<? extends Quantifier>)((Object)transformedQuantifiers.build()), (List<? extends QueryPredicate>)((Object)transformedPredicates.build())));
    }

    @Nonnull
    private static List<QueryPredicate> createSimpleEqualitiesForRecordTypeValue(@Nonnull Value value, @Nonnull Quantifier.ForEach newQuantifier) {
        Verify.verify(value.getResultType().isRecord(), "value should be of type record and not %s", (Object)value.getResultType());
        List<Value> fieldValues = Values.deconstructRecord(value);
        List<Column<? extends FieldValue>> comparandValueChildren = newQuantifier.getFlowedColumns();
        Verify.verify(fieldValues.size() == comparandValueChildren.size(), "record type value and comparand should have matching number of fields", new Object[0]);
        ImmutableList.Builder resultsBuilder = ImmutableList.builder();
        for (int i = 0; i < fieldValues.size(); ++i) {
            Value fieldValue = fieldValues.get(i);
            BooleanValue currentVal = (BooleanValue)new RelOpValue.EqualsFn().encapsulate(List.of(fieldValue, comparandValueChildren.get(i).getValue()));
            Optional<QueryPredicate> currentQueryPredicate = currentVal.toQueryPredicate(null, Quantifier.current());
            Verify.verify(currentQueryPredicate.isPresent());
            resultsBuilder.add(currentQueryPredicate.get());
        }
        return resultsBuilder.build();
    }
}

