/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.combinatorics.EnumeratingIterable;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.IdentityBiMap;
import com.apple.foundationdb.record.query.plan.cascades.IterableHelpers;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentitySet;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.MatchInfo;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.graph.BoundMatch;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class MatchIntermediateRule
extends CascadesRule<RelationalExpression> {
    private static final BindingMatcher<Quantifier> quantifierMatcher = QuantifierMatchers.anyQuantifier();
    private static final BindingMatcher<RelationalExpression> root = RelationalExpressionMatchers.ofTypeOwning(RelationalExpression.class, MultiMatcher.all(quantifierMatcher));

    public MatchIntermediateRule() {
        super(root);
    }

    @Override
    @Nonnull
    public Optional<Class<?>> getRootOperator() {
        return Optional.empty();
    }

    @Override
    public void onMatch(@Nonnull CascadesRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        RelationalExpression expression = bindings.get(root);
        List<Quantifier> quantifiers = bindings.getAll(quantifierMatcher);
        ImmutableList rangesOverRefs = quantifiers.stream().map(Quantifier::getRangesOver).collect(ImmutableList.toImmutableList());
        LinkedIdentitySet childMatchCandidates = new LinkedIdentitySet();
        for (int i = 0; i < rangesOverRefs.size(); ++i) {
            Reference rangesOverGroup = (Reference)rangesOverRefs.get(i);
            childMatchCandidates.addAll(rangesOverGroup.getMatchCandidates());
        }
        for (MatchCandidate matchCandidate : childMatchCandidates) {
            SetMultimap<Reference, RelationalExpression> refToExpressionMap = matchCandidate.findReferencingExpressions(rangesOverRefs);
            for (Map.Entry entry : refToExpressionMap.entries()) {
                Reference candidateReference = (Reference)entry.getKey();
                RelationalExpression candidateExpression = (RelationalExpression)entry.getValue();
                Iterable<BoundMatch<MatchInfo>> boundMatchInfos = this.matchWithCandidate(expression, matchCandidate, candidateExpression, call.getEvaluationContext());
                boundMatchInfos.forEach(boundMatchInfo -> call.yieldPartialMatch(boundMatchInfo.getAliasMap(), matchCandidate, expression, candidateReference, (MatchInfo)boundMatchInfo.getMatchResult()));
            }
        }
    }

    @Nonnull
    private Iterable<BoundMatch<MatchInfo>> matchWithCandidate(@Nonnull RelationalExpression expression, @Nonnull MatchCandidate matchCandidate, @Nonnull RelationalExpression candidateExpression, @Nonnull EvaluationContext context) {
        Verify.verify(!expression.getQuantifiers().isEmpty());
        Verify.verify(!candidateExpression.getQuantifiers().isEmpty());
        return expression.match(candidateExpression, AliasMap.emptyMap(), expression.getQuantifiers(), candidateExpression.getQuantifiers(), quantifier -> this.constraintsForQuantifier(matchCandidate, (Quantifier)quantifier), (quantifier, otherQuantifier, aliasMap) -> this.matchQuantifiers(matchCandidate, (Quantifier)quantifier, (Quantifier)otherQuantifier, aliasMap), (boundCorrelatedToMap, boundMatches) -> this.combineMatches(expression, candidateExpression, boundCorrelatedToMap, boundMatches, context));
    }

    @Nonnull
    private Collection<AliasMap> constraintsForQuantifier(@Nonnull MatchCandidate matchCandidate, @Nonnull Quantifier quantifier) {
        Set<PartialMatch> partialMatchesForCandidate = quantifier.getRangesOver().getPartialMatchesForCandidate(matchCandidate);
        if (partialMatchesForCandidate.isEmpty()) {
            return ImmutableList.of(AliasMap.emptyMap());
        }
        return partialMatchesForCandidate.stream().map(PartialMatch::getBoundAliasMap).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    private Iterable<PartialMatchWithQuantifier> matchQuantifiers(@Nonnull MatchCandidate matchCandidate, @Nonnull Quantifier quantifier, @Nonnull Quantifier candidateQuantifier, @Nonnull AliasMap aliasMap) {
        Reference rangesOver = quantifier.getRangesOver();
        Reference otherRangesOver = candidateQuantifier.getRangesOver();
        Set<PartialMatch> partialMatchesForCandidate = rangesOver.getPartialMatchesForCandidate(matchCandidate);
        return partialMatchesForCandidate.stream().filter(partialMatch -> partialMatch.getCandidateRef() == otherRangesOver && partialMatch.getBoundAliasMap().isCompatible(aliasMap)).map(partialMatch -> PartialMatchWithQuantifier.of(partialMatch, quantifier)).collect(Collectors.toList());
    }

    @Nonnull
    private Iterable<BoundMatch<MatchInfo>> combineMatches(@Nonnull RelationalExpression expression, @Nonnull RelationalExpression candidateExpression, @Nonnull AliasMap boundCorrelatedToMap, @Nonnull Iterable<BoundMatch<EnumeratingIterable<PartialMatchWithQuantifier>>> boundMatches, @Nonnull EvaluationContext context) {
        return () -> StreamSupport.stream(boundMatches.spliterator(), false).flatMap(boundMatch -> boundMatch.getMatchResultOptional().map(matchResultIterable -> IterableHelpers.flatMap(matchResultIterable, matchResult -> {
            IdentityBiMap<Quantifier, PartialMatch> partialMatchMap = this.partialMatchMap((Iterable<PartialMatchWithQuantifier>)matchResult);
            return expression.subsumedBy(candidateExpression, boundMatch.getAliasMap(), partialMatchMap, context);
        })).map(matchesWithCompensation -> StreamSupport.stream(matchesWithCompensation.spliterator(), false)).orElseGet(Stream::empty)).map(matchInfo -> BoundMatch.withAliasMapAndMatchResult(boundCorrelatedToMap, matchInfo)).iterator();
    }

    @Nonnull
    private IdentityBiMap<Quantifier, PartialMatch> partialMatchMap(Iterable<PartialMatchWithQuantifier> partialMatchWithQuantifiers) {
        return StreamSupport.stream(partialMatchWithQuantifiers.spliterator(), false).collect(IdentityBiMap.toImmutableIdentityBiMap(PartialMatchWithQuantifier::getQuantifier, PartialMatchWithQuantifier::getPartialMatch, (v1, v2) -> {
            throw new RecordCoreException("matching produced duplicate quantifiers", new Object[0]);
        }));
    }

    public static class PartialMatchWithQuantifier {
        @Nonnull
        private final PartialMatch partialMatch;
        @Nonnull
        private final Quantifier quantifier;

        private PartialMatchWithQuantifier(@Nonnull PartialMatch partialMatch, @Nonnull Quantifier quantifier) {
            this.partialMatch = partialMatch;
            this.quantifier = quantifier;
        }

        @Nonnull
        public static PartialMatchWithQuantifier of(@Nonnull PartialMatch partialMatch, @Nonnull Quantifier quantifier) {
            return new PartialMatchWithQuantifier(partialMatch, quantifier);
        }

        @Nonnull
        public PartialMatch getPartialMatch() {
            return this.partialMatch;
        }

        @Nonnull
        public Quantifier getQuantifier() {
            return this.quantifier;
        }
    }
}

