/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.IdentityBiMap;
import com.apple.foundationdb.record.query.plan.cascades.IterableHelpers;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.MatchInfo;
import com.apple.foundationdb.record.query.plan.cascades.PlanContext;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.Traversal;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.graph.BoundMatch;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class MatchLeafRule
extends CascadesRule<RelationalExpression> {
    private static final BindingMatcher<RelationalExpression> root = RelationalExpressionMatchers.ofTypeOwning(RelationalExpression.class, CollectionMatcher.empty());

    public MatchLeafRule() {
        super(root);
    }

    @Override
    @Nonnull
    public Optional<Class<?>> getRootOperator() {
        return Optional.empty();
    }

    @Override
    public void onMatch(@Nonnull CascadesRuleCall call) {
        PlanContext context = call.getContext();
        RelationalExpression expression = call.get(root);
        for (MatchCandidate matchCandidate : context.getMatchCandidates()) {
            Traversal traversal = matchCandidate.getTraversal();
            Set<Reference> leafRefs = traversal.getLeafReferences();
            for (Reference leafRef : leafRefs) {
                for (RelationalExpression leafExpression : leafRef.getFinalExpressions()) {
                    if (!leafExpression.getQuantifiers().isEmpty()) continue;
                    Iterable<BoundMatch<MatchInfo>> boundMatchInfos = this.matchWithCandidate(expression, leafExpression, call.getEvaluationContext());
                    boundMatchInfos.forEach(boundMatchInfo -> call.yieldPartialMatch(boundMatchInfo.getAliasMap(), matchCandidate, expression, leafRef, (MatchInfo)boundMatchInfo.getMatchResult()));
                }
            }
        }
    }

    private Iterable<BoundMatch<MatchInfo>> matchWithCandidate(@Nonnull RelationalExpression expression, @Nonnull RelationalExpression candidateExpression, @Nonnull EvaluationContext context) {
        Iterable<AliasMap> boundCorrelatedIterable = expression.enumerateUnboundCorrelatedTo(AliasMap.emptyMap(), candidateExpression);
        return IterableHelpers.flatMap(boundCorrelatedIterable, boundAliasMap -> IterableHelpers.map(expression.subsumedBy(candidateExpression, (AliasMap)boundAliasMap, IdentityBiMap.create(), context), matchInfo -> BoundMatch.withAliasMapAndMatchResult(boundAliasMap, matchInfo)));
    }
}

