/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalProjectionExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ListMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RecordQueryPlanMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class MergeProjectionAndFetchRule
extends ImplementationCascadesRule<LogicalProjectionExpression> {
    @Nonnull
    private static final BindingMatcher<RecordQueryFetchFromPartialRecordPlan> innerPlanMatcher = RecordQueryPlanMatchers.fetchFromPartialRecordPlan(RecordQueryPlanMatchers.anyPlan());
    @Nonnull
    private static final BindingMatcher<Quantifier.ForEach> innerQuantifierMatcher = QuantifierMatchers.forEachQuantifier(innerPlanMatcher);
    @Nonnull
    private static final BindingMatcher<LogicalProjectionExpression> root = RelationalExpressionMatchers.logicalProjectionExpression(ListMatcher.exactly(innerQuantifierMatcher));

    public MergeProjectionAndFetchRule() {
        super(root);
    }

    @Override
    public void onMatch(@Nonnull ImplementationCascadesRuleCall call) {
        LogicalProjectionExpression projectionExpression = call.get(root);
        RecordQueryFetchFromPartialRecordPlan fetchPlan = call.get(innerPlanMatcher);
        CorrelationIdentifier oldInnerAlias = Iterables.getOnlyElement(projectionExpression.getQuantifiers()).getAlias();
        CorrelationIdentifier newInnerAlias = Quantifier.uniqueId();
        List<? extends Value> projectedValues = projectionExpression.getProjectedValues();
        boolean allPushable = projectedValues.stream().allMatch(value -> fetchPlan.pushValue((Value)value, oldInnerAlias, newInnerAlias).isPresent());
        if (allPushable) {
            call.yieldPlan(fetchPlan.getChild());
        }
    }
}

