/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.rules;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.ExplorationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ExplorationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QuantifierMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.QueryPredicateMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AndPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.planning.BooleanPredicateNormalizer;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class NormalizePredicatesRule
extends ExplorationCascadesRule<SelectExpression> {
    private static final CollectionMatcher<QueryPredicate> predicatesMatcher = MultiMatcher.all(QueryPredicateMatchers.anyPredicate());
    private static final CollectionMatcher<Quantifier> innerQuantifiersMatcher = MultiMatcher.all(QuantifierMatchers.anyQuantifier());
    private static final BindingMatcher<SelectExpression> root = RelationalExpressionMatchers.selectExpression(predicatesMatcher, innerQuantifiersMatcher);

    public NormalizePredicatesRule() {
        super(root);
    }

    @Override
    public void onMatch(@Nonnull ExplorationCascadesRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        SelectExpression selectExpression = bindings.get(root);
        Collection predicates = (Collection)((Object)bindings.get(predicatesMatcher));
        Collection quantifiers = (Collection)((Object)bindings.get(innerQuantifiersMatcher));
        QueryPredicate conjunctedPredicate = AndPredicate.and(predicates);
        BooleanPredicateNormalizer cnfNormalizer = BooleanPredicateNormalizer.forConfiguration(BooleanPredicateNormalizer.Mode.CNF, call.getContext().getPlannerConfiguration());
        cnfNormalizer.normalizeAndSimplify(conjunctedPredicate, false).ifPresent(cnfPredicate -> call.yieldExploratoryExpression(new SelectExpression(selectExpression.getResultValue(), quantifiers.stream().map(quantifier -> quantifier.toBuilder().build(quantifier.getRangesOver())).collect(ImmutableList.toImmutableList()), AndPredicate.conjuncts(cnfPredicate))));
    }
}

